/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.core.internal.io.IOUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.AbstractIndexComponent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.AnalyzerScope;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.NamedAnalyzer;

public final class IndexAnalyzers
extends AbstractIndexComponent
implements Closeable {
    private final NamedAnalyzer defaultIndexAnalyzer;
    private final NamedAnalyzer defaultSearchAnalyzer;
    private final NamedAnalyzer defaultSearchQuoteAnalyzer;
    private final Map<String, NamedAnalyzer> analyzers;
    private final Map<String, NamedAnalyzer> normalizers;
    private final Map<String, NamedAnalyzer> whitespaceNormalizers;
    private final IndexSettings indexSettings;

    public IndexAnalyzers(IndexSettings indexSettings, NamedAnalyzer defaultIndexAnalyzer, NamedAnalyzer defaultSearchAnalyzer, NamedAnalyzer defaultSearchQuoteAnalyzer, Map<String, NamedAnalyzer> analyzers, Map<String, NamedAnalyzer> normalizers, Map<String, NamedAnalyzer> whitespaceNormalizers) {
        super(indexSettings);
        this.defaultIndexAnalyzer = defaultIndexAnalyzer;
        this.defaultSearchAnalyzer = defaultSearchAnalyzer;
        this.defaultSearchQuoteAnalyzer = defaultSearchQuoteAnalyzer;
        this.analyzers = analyzers;
        this.normalizers = normalizers;
        this.whitespaceNormalizers = whitespaceNormalizers;
        this.indexSettings = indexSettings;
    }

    public NamedAnalyzer get(String name) {
        return this.analyzers.get(name);
    }

    public NamedAnalyzer getNormalizer(String name) {
        return this.normalizers.get(name);
    }

    public NamedAnalyzer getWhitespaceNormalizer(String name) {
        return this.whitespaceNormalizers.get(name);
    }

    public NamedAnalyzer getDefaultIndexAnalyzer() {
        return this.defaultIndexAnalyzer;
    }

    public NamedAnalyzer getDefaultSearchAnalyzer() {
        return this.defaultSearchAnalyzer;
    }

    public NamedAnalyzer getDefaultSearchQuoteAnalyzer() {
        return this.defaultSearchQuoteAnalyzer;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(Stream.of(this.analyzers.values().stream(), this.normalizers.values().stream(), this.whitespaceNormalizers.values().stream()).flatMap(s -> s).filter(a -> a.scope() == AnalyzerScope.INDEX).collect(Collectors.toList()));
    }

    @Override
    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }
}

