/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.http;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Booleans;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.network.InetAddresses;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.transport.BoundTransportAddress;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.transport.TransportAddress;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.ByteSizeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.logging.log4j.LogManager;

public class HttpInfo
implements Writeable,
ToXContentFragment {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(HttpInfo.class));
    private static final boolean CNAME_IN_PUBLISH_HOST = Booleans.parseBoolean(System.getProperty("es.http.cname_in_publish_address"), false);
    private final BoundTransportAddress address;
    private final long maxContentLength;
    private final boolean cnameInPublishHost;

    public HttpInfo(StreamInput in) throws IOException {
        this(BoundTransportAddress.readBoundTransportAddress(in), in.readLong(), CNAME_IN_PUBLISH_HOST);
    }

    public HttpInfo(BoundTransportAddress address, long maxContentLength) {
        this(address, maxContentLength, CNAME_IN_PUBLISH_HOST);
    }

    HttpInfo(BoundTransportAddress address, long maxContentLength, boolean cnameInPublishHost) {
        this.address = address;
        this.maxContentLength = maxContentLength;
        this.cnameInPublishHost = cnameInPublishHost;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.address.writeTo(out);
        out.writeLong(this.maxContentLength);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("http");
        builder.array("bound_address", this.address.boundAddresses());
        TransportAddress publishAddress = this.address.publishAddress();
        String publishAddressString = publishAddress.toString();
        String hostString = publishAddress.address().getHostString();
        if (!InetAddresses.isInetAddress(hostString)) {
            if (this.cnameInPublishHost) {
                publishAddressString = hostString + '/' + publishAddress.toString();
            } else {
                DEPRECATION_LOGGER.deprecated("[http.publish_host] was printed as [ip:port] instead of [hostname/ip:port]. This format is deprecated and will change to [hostname/ip:port] in a future version. Use -Des.http.cname_in_publish_address=true to enforce non-deprecated formatting.", new Object[0]);
            }
        }
        builder.field("publish_address", publishAddressString);
        builder.humanReadableField("max_content_length_in_bytes", "max_content_length", this.maxContentLength());
        builder.endObject();
        return builder;
    }

    public BoundTransportAddress address() {
        return this.address;
    }

    public BoundTransportAddress getAddress() {
        return this.address();
    }

    public ByteSizeValue maxContentLength() {
        return new ByteSizeValue(this.maxContentLength);
    }

    public ByteSizeValue getMaxContentLength() {
        return this.maxContentLength();
    }

    static final class Fields {
        static final String HTTP = "http";
        static final String BOUND_ADDRESS = "bound_address";
        static final String PUBLISH_ADDRESS = "publish_address";
        static final String MAX_CONTENT_LENGTH = "max_content_length";
        static final String MAX_CONTENT_LENGTH_IN_BYTES = "max_content_length_in_bytes";

        Fields() {
        }
    }
}

