/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.gateway;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterChangedEvent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterStateApplier;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.MetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.MetaDataIndexUpgradeService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.RoutingNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.env.NodeEnvironment;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.gateway.MetaStateService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.plugins.MetaDataUpgrader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GatewayMetaState
implements ClusterStateApplier {
    private static final Logger logger = LogManager.getLogger(GatewayMetaState.class);
    private final NodeEnvironment nodeEnv;
    private final MetaStateService metaStateService;
    @Nullable
    private volatile MetaData previousMetaData;
    private volatile Set<Index> previouslyWrittenIndices = Collections.emptySet();

    public GatewayMetaState(Settings settings, NodeEnvironment nodeEnv, MetaStateService metaStateService, MetaDataIndexUpgradeService metaDataIndexUpgradeService, MetaDataUpgrader metaDataUpgrader) throws IOException {
        this.nodeEnv = nodeEnv;
        this.metaStateService = metaStateService;
        if (DiscoveryNode.isDataNode(settings)) {
            this.ensureNoPre019ShardState(nodeEnv);
        }
        if (DiscoveryNode.isMasterNode(settings) || DiscoveryNode.isDataNode(settings)) {
            nodeEnv.ensureAtomicMoveSupported();
        }
        if (DiscoveryNode.isMasterNode(settings) || DiscoveryNode.isDataNode(settings)) {
            try {
                this.ensureNoPre019State();
                MetaData metaData = metaStateService.loadFullState();
                MetaData upgradedMetaData = GatewayMetaState.upgradeMetaData(metaData, metaDataIndexUpgradeService, metaDataUpgrader);
                if (metaData != upgradedMetaData) {
                    if (!MetaData.isGlobalStateEquals(metaData, upgradedMetaData)) {
                        metaStateService.writeGlobalState("upgrade", upgradedMetaData);
                    }
                    for (IndexMetaData indexMetaData : upgradedMetaData) {
                        if (metaData.hasIndexMetaData(indexMetaData)) continue;
                        metaStateService.writeIndex("upgrade", indexMetaData);
                    }
                }
                long startNS = System.nanoTime();
                metaStateService.loadFullState();
                logger.debug("took {} to load state", (Object)TimeValue.timeValueMillis(TimeValue.nsecToMSec(System.nanoTime() - startNS)));
            }
            catch (Exception e) {
                logger.error("failed to read local state, exiting...", (Throwable)e);
                throw e;
            }
        }
    }

    public MetaData loadMetaState() throws IOException {
        return this.metaStateService.loadFullState();
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().disableStatePersistence()) {
            this.previousMetaData = null;
            this.previouslyWrittenIndices = Collections.emptySet();
            return;
        }
        MetaData newMetaData = state.metaData();
        Set<Index> relevantIndices = Collections.emptySet();
        boolean success = true;
        if (state.nodes().getLocalNode().isMasterNode() || state.nodes().getLocalNode().isDataNode()) {
            if (this.previousMetaData == null) {
                try {
                    if (GatewayMetaState.isDataOnlyNode(state)) {
                        HashSet<Index> newPreviouslyWrittenIndices = new HashSet<Index>(this.previouslyWrittenIndices.size());
                        for (IndexMetaData indexMetaData : newMetaData) {
                            IndexMetaData indexMetaDataOnDisk = null;
                            if (indexMetaData.getState().equals((Object)IndexMetaData.State.CLOSE)) {
                                indexMetaDataOnDisk = this.metaStateService.loadIndexState(indexMetaData.getIndex());
                            }
                            if (indexMetaDataOnDisk == null) continue;
                            newPreviouslyWrittenIndices.add(indexMetaDataOnDisk.getIndex());
                        }
                        newPreviouslyWrittenIndices.addAll(this.previouslyWrittenIndices);
                        this.previouslyWrittenIndices = Collections.unmodifiableSet(newPreviouslyWrittenIndices);
                    }
                }
                catch (Exception e) {
                    success = false;
                }
            }
            if (this.previousMetaData == null || !MetaData.isGlobalStateEquals(this.previousMetaData, newMetaData)) {
                try {
                    this.metaStateService.writeGlobalState("changed", newMetaData);
                }
                catch (Exception e) {
                    success = false;
                }
            }
            relevantIndices = GatewayMetaState.getRelevantIndices(event.state(), event.previousState(), this.previouslyWrittenIndices);
            Iterable<IndexMetaWriteInfo> writeInfo = GatewayMetaState.resolveStatesToBeWritten(this.previouslyWrittenIndices, relevantIndices, this.previousMetaData, event.state().metaData());
            for (IndexMetaWriteInfo indexMetaWrite : writeInfo) {
                try {
                    this.metaStateService.writeIndex(indexMetaWrite.reason, indexMetaWrite.newMetaData);
                }
                catch (Exception e) {
                    success = false;
                }
            }
        }
        if (success) {
            this.previousMetaData = newMetaData;
            this.previouslyWrittenIndices = Collections.unmodifiableSet(relevantIndices);
        }
    }

    public static Set<Index> getRelevantIndices(ClusterState state, ClusterState previousState, Set<Index> previouslyWrittenIndices) {
        Set<Index> relevantIndices = GatewayMetaState.isDataOnlyNode(state) ? GatewayMetaState.getRelevantIndicesOnDataOnlyNode(state, previousState, previouslyWrittenIndices) : (state.nodes().getLocalNode().isMasterNode() ? GatewayMetaState.getRelevantIndicesForMasterEligibleNode(state) : Collections.emptySet());
        return relevantIndices;
    }

    protected static boolean isDataOnlyNode(ClusterState state) {
        return !state.nodes().getLocalNode().isMasterNode() && state.nodes().getLocalNode().isDataNode();
    }

    private void ensureNoPre019State() throws IOException {
        for (Path dataLocation : this.nodeEnv.nodeDataPaths()) {
            Path stateLocation = dataLocation.resolve("_state");
            if (!Files.exists(stateLocation, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(stateLocation);){
                for (Path stateFile : stream) {
                    String name;
                    if (logger.isTraceEnabled()) {
                        logger.trace("[upgrade]: processing [{}]", (Object)stateFile.getFileName());
                    }
                    if (!(name = stateFile.getFileName().toString()).startsWith("metadata-")) continue;
                    throw new IllegalStateException("Detected pre 0.19 metadata file please upgrade to a version before " + Version.CURRENT.minimumIndexCompatibilityVersion() + " first to upgrade state structures - metadata found: [" + stateFile.getParent().toAbsolutePath());
                }
            }
        }
    }

    static MetaData upgradeMetaData(MetaData metaData, MetaDataIndexUpgradeService metaDataIndexUpgradeService, MetaDataUpgrader metaDataUpgrader) throws IOException {
        boolean changed = false;
        MetaData.Builder upgradedMetaData = MetaData.builder(metaData);
        for (IndexMetaData indexMetaData : metaData) {
            IndexMetaData newMetaData;
            changed |= indexMetaData != (newMetaData = metaDataIndexUpgradeService.upgradeIndexMetaData(indexMetaData, Version.CURRENT.minimumIndexCompatibilityVersion()));
            upgradedMetaData.put(newMetaData, false);
        }
        if (GatewayMetaState.applyPluginUpgraders(metaData.getCustoms(), metaDataUpgrader.customMetaDataUpgraders, upgradedMetaData::removeCustom, upgradedMetaData::putCustom)) {
            changed = true;
        }
        if (GatewayMetaState.applyPluginUpgraders(metaData.getTemplates(), metaDataUpgrader.indexTemplateMetaDataUpgraders, upgradedMetaData::removeTemplate, (s, indexTemplateMetaData) -> upgradedMetaData.put((IndexTemplateMetaData)indexTemplateMetaData))) {
            changed = true;
        }
        return changed ? upgradedMetaData.build() : metaData;
    }

    private static <Data> boolean applyPluginUpgraders(ImmutableOpenMap<String, Data> existingData, UnaryOperator<Map<String, Data>> upgrader, Consumer<String> removeData, BiConsumer<String, Data> putData) {
        HashMap<String, Object> existingMap = new HashMap<String, Object>();
        for (ObjectObjectCursor<String, Data> objectObjectCursor : existingData) {
            existingMap.put((String)objectObjectCursor.key, objectObjectCursor.value);
        }
        Map upgradedCustoms = (Map)upgrader.apply(existingMap);
        if (!upgradedCustoms.equals(existingMap)) {
            existingMap.keySet().forEach(removeData);
            for (Map.Entry upgradedCustomEntry : upgradedCustoms.entrySet()) {
                putData.accept((String)upgradedCustomEntry.getKey(), upgradedCustomEntry.getValue());
            }
            return true;
        }
        return false;
    }

    private void ensureNoPre019ShardState(NodeEnvironment nodeEnv) throws IOException {
        for (Path dataLocation : nodeEnv.nodeDataPaths()) {
            Path stateLocation = dataLocation.resolve("_state");
            if (!Files.exists(stateLocation, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(stateLocation, "shards-*");){
                Iterator<Path> iterator = stream.iterator();
                if (!iterator.hasNext()) continue;
                Path stateFile = iterator.next();
                throw new IllegalStateException("Detected pre 0.19 shard state file please upgrade to a version before " + Version.CURRENT.minimumIndexCompatibilityVersion() + " first to upgrade state structures - shard state found: [" + stateFile.getParent().toAbsolutePath());
            }
        }
    }

    public static Iterable<IndexMetaWriteInfo> resolveStatesToBeWritten(Set<Index> previouslyWrittenIndices, Set<Index> potentiallyUnwrittenIndices, MetaData previousMetaData, MetaData newMetaData) {
        ArrayList<IndexMetaWriteInfo> indicesToWrite = new ArrayList<IndexMetaWriteInfo>();
        for (Index index : potentiallyUnwrittenIndices) {
            IndexMetaData newIndexMetaData = newMetaData.getIndexSafe(index);
            IndexMetaData previousIndexMetaData = previousMetaData == null ? null : previousMetaData.index(index);
            String writeReason = null;
            if (!previouslyWrittenIndices.contains(index) || previousIndexMetaData == null) {
                writeReason = "freshly created";
            } else if (previousIndexMetaData.getVersion() != newIndexMetaData.getVersion()) {
                writeReason = "version changed from [" + previousIndexMetaData.getVersion() + "] to [" + newIndexMetaData.getVersion() + "]";
            }
            if (writeReason == null) continue;
            indicesToWrite.add(new IndexMetaWriteInfo(newIndexMetaData, previousIndexMetaData, writeReason));
        }
        return indicesToWrite;
    }

    public static Set<Index> getRelevantIndicesOnDataOnlyNode(ClusterState state, ClusterState previousState, Set<Index> previouslyWrittenIndices) {
        RoutingNode newRoutingNode = state.getRoutingNodes().node(state.nodes().getLocalNodeId());
        if (newRoutingNode == null) {
            throw new IllegalStateException("cluster state does not contain this node - cannot write index meta state");
        }
        HashSet<Index> indices = new HashSet<Index>();
        for (ShardRouting routing : newRoutingNode) {
            indices.add(routing.index());
        }
        for (IndexMetaData indexMetaData : state.metaData()) {
            boolean isOrWasClosed = indexMetaData.getState().equals((Object)IndexMetaData.State.CLOSE);
            IndexMetaData previousMetaData = previousState.metaData().index(indexMetaData.getIndex());
            if (previousMetaData != null) {
                boolean bl = isOrWasClosed = isOrWasClosed || previousMetaData.getState().equals((Object)IndexMetaData.State.CLOSE);
            }
            if (!previouslyWrittenIndices.contains(indexMetaData.getIndex()) || !isOrWasClosed) continue;
            indices.add(indexMetaData.getIndex());
        }
        return indices;
    }

    public static Set<Index> getRelevantIndicesForMasterEligibleNode(ClusterState state) {
        HashSet<Index> relevantIndices = new HashSet<Index>();
        for (IndexMetaData indexMetaData : state.metaData()) {
            relevantIndices.add(indexMetaData.getIndex());
        }
        return relevantIndices;
    }

    public static class IndexMetaWriteInfo {
        final IndexMetaData newMetaData;
        final String reason;
        final IndexMetaData previousMetaData;

        public IndexMetaWriteInfo(IndexMetaData newMetaData, IndexMetaData previousMetaData, String reason) {
            this.newMetaData = newMetaData;
            this.reason = reason;
            this.previousMetaData = previousMetaData;
        }

        public IndexMetaData getNewMetaData() {
            return this.newMetaData;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

