/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.time;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.joda.Joda;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.time.DateFormatters;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.time.DateMathParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.time.DateUtils;
import org.joda.time.DateTime;

public interface DateFormatter {
    public TemporalAccessor parse(String var1);

    default public long parseMillis(String input) {
        return DateFormatters.from(this.parse(input)).toInstant().toEpochMilli();
    }

    default public DateTime parseJoda(String input) {
        ZonedDateTime dateTime = ZonedDateTime.from(this.parse(input));
        return new DateTime(dateTime.toInstant().toEpochMilli(), DateUtils.zoneIdToDateTimeZone(dateTime.getZone()));
    }

    public DateFormatter withZone(ZoneId var1);

    public DateFormatter withLocale(Locale var1);

    public String format(TemporalAccessor var1);

    default public String formatMillis(long millis) {
        return this.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC));
    }

    default public String formatJoda(DateTime dateTime) {
        return this.format(ZonedDateTime.ofInstant(Instant.ofEpochMilli(dateTime.getMillis()), DateUtils.dateTimeZoneToZoneId(dateTime.getZone())));
    }

    public String pattern();

    public Locale locale();

    public ZoneId zone();

    public DateMathParser toDateMathParser();

    public static DateFormatter forPattern(String input) {
        if (!Strings.hasLength(input)) {
            throw new IllegalArgumentException("No date pattern provided");
        }
        if (!input.startsWith("8")) {
            return Joda.forPattern(input);
        }
        List<String> patterns = DateFormatter.splitCombinedPatterns(input = input.substring(1));
        List<DateFormatter> formatters = patterns.stream().map(DateFormatters::forPattern).collect(Collectors.toList());
        if (formatters.size() == 1) {
            return (DateFormatter)formatters.get(0);
        }
        return DateFormatters.merge(input, formatters);
    }

    public static List<String> splitCombinedPatterns(String input) {
        ArrayList<String> patterns = new ArrayList<String>();
        for (String pattern : Strings.delimitedListToStringArray(input, "||")) {
            if (!Strings.hasLength(pattern)) {
                throw new IllegalArgumentException("Cannot have empty element in multi date format pattern: " + input);
            }
            patterns.add(pattern);
        }
        return patterns;
    }
}

