/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.master.MasterNodeRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.Client;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterChangedEvent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterStateListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.ThreadContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentHelper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.gateway.GatewayService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.IndexTemplateMissingException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class TemplateUpgradeService
implements ClusterStateListener {
    private static final Logger logger = LogManager.getLogger(TemplateUpgradeService.class);
    private final UnaryOperator<Map<String, IndexTemplateMetaData>> indexTemplateMetaDataUpgraders;
    public final ClusterService clusterService;
    public final ThreadPool threadPool;
    public final Client client;
    final AtomicInteger upgradesInProgress = new AtomicInteger();
    private ImmutableOpenMap<String, IndexTemplateMetaData> lastTemplateMetaData;
    private static final ToXContent.Params PARAMS = new ToXContent.MapParams(Collections.singletonMap("reduce_mappings", "true"));

    public TemplateUpgradeService(Client client, ClusterService clusterService, ThreadPool threadPool, Collection<UnaryOperator<Map<String, IndexTemplateMetaData>>> indexTemplateMetaDataUpgraders) {
        this.client = client;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.indexTemplateMetaDataUpgraders = templates -> {
            Map upgradedTemplates = new HashMap(templates);
            for (UnaryOperator upgrader : indexTemplateMetaDataUpgraders) {
                upgradedTemplates = (Map)upgrader.apply(upgradedTemplates);
            }
            return upgradedTemplates;
        };
        clusterService.addListener(this);
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        ClusterState state = event.state();
        if (state.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        if (this.upgradesInProgress.get() > 0) {
            return;
        }
        ImmutableOpenMap<String, IndexTemplateMetaData> templates = state.getMetaData().getTemplates();
        if (templates == this.lastTemplateMetaData) {
            return;
        }
        if (!state.nodes().isLocalNodeElectedMaster()) {
            return;
        }
        this.lastTemplateMetaData = templates;
        Optional<Tuple<Map<String, BytesReference>, Set<String>>> changes = this.calculateTemplateChanges(templates);
        if (changes.isPresent() && this.upgradesInProgress.compareAndSet(0, changes.get().v1().size() + changes.get().v2().size() + 1)) {
            logger.info("Starting template upgrade to version {}, {} templates will be updated and {} will be removed", (Object)Version.CURRENT, (Object)changes.get().v1().size(), (Object)changes.get().v2().size());
            ThreadContext threadContext = this.threadPool.getThreadContext();
            try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
                threadContext.markAsSystemContext();
                this.threadPool.generic().execute(() -> this.upgradeTemplates((Map)((Tuple)changes.get()).v1(), (Set)((Tuple)changes.get()).v2()));
            }
        }
    }

    void upgradeTemplates(Map<String, BytesReference> changes, Set<String> deletions) {
        MasterNodeRequest request;
        final AtomicBoolean anyUpgradeFailed = new AtomicBoolean(false);
        if (!this.threadPool.getThreadContext().isSystemContext()) {
            throw new IllegalStateException("template updates from the template upgrade service should always happen in a system context");
        }
        for (final Map.Entry<String, BytesReference> change : changes.entrySet()) {
            request = new PutIndexTemplateRequest(change.getKey()).source(change.getValue(), XContentType.JSON);
            request.masterNodeTimeout(TimeValue.timeValueMinutes(1L));
            this.client.admin().indices().putTemplate((PutIndexTemplateRequest)request, new ActionListener<AcknowledgedResponse>(){

                @Override
                public void onResponse(AcknowledgedResponse response) {
                    if (!response.isAcknowledged()) {
                        anyUpgradeFailed.set(true);
                        logger.warn("Error updating template [{}], request was not acknowledged", change.getKey());
                    }
                    TemplateUpgradeService.this.tryFinishUpgrade(anyUpgradeFailed);
                }

                @Override
                public void onFailure(Exception e) {
                    anyUpgradeFailed.set(true);
                    logger.warn((Message)new ParameterizedMessage("Error updating template [{}]", change.getKey()), (Throwable)e);
                    TemplateUpgradeService.this.tryFinishUpgrade(anyUpgradeFailed);
                }
            });
        }
        for (final String template : deletions) {
            request = new DeleteIndexTemplateRequest(template);
            request.masterNodeTimeout(TimeValue.timeValueMinutes(1L));
            this.client.admin().indices().deleteTemplate((DeleteIndexTemplateRequest)request, new ActionListener<AcknowledgedResponse>(){

                @Override
                public void onResponse(AcknowledgedResponse response) {
                    if (!response.isAcknowledged()) {
                        anyUpgradeFailed.set(true);
                        logger.warn("Error deleting template [{}], request was not acknowledged", (Object)template);
                    }
                    TemplateUpgradeService.this.tryFinishUpgrade(anyUpgradeFailed);
                }

                @Override
                public void onFailure(Exception e) {
                    anyUpgradeFailed.set(true);
                    if (!(e instanceof IndexTemplateMissingException)) {
                        logger.warn((Message)new ParameterizedMessage("Error deleting template [{}]", (Object)template), (Throwable)e);
                    }
                    TemplateUpgradeService.this.tryFinishUpgrade(anyUpgradeFailed);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryFinishUpgrade(AtomicBoolean anyUpgradeFailed) {
        assert (this.upgradesInProgress.get() > 0);
        if (this.upgradesInProgress.decrementAndGet() == 1) {
            try {
                if (anyUpgradeFailed.get()) {
                    logger.info("Templates were partially upgraded to version {}", (Object)Version.CURRENT);
                } else {
                    logger.info("Templates were upgraded successfully to version {}", (Object)Version.CURRENT);
                }
                ImmutableOpenMap<String, IndexTemplateMetaData> upgradedTemplates = this.clusterService.state().getMetaData().getTemplates();
                boolean changesRequired = this.calculateTemplateChanges(upgradedTemplates).isPresent();
                if (changesRequired) {
                    logger.warn("Templates are still reported as out of date after the upgrade. The template upgrade will be retried.");
                }
            }
            finally {
                int noMoreUpgrades = this.upgradesInProgress.decrementAndGet();
                assert (noMoreUpgrades == 0);
            }
        }
    }

    Optional<Tuple<Map<String, BytesReference>, Set<String>>> calculateTemplateChanges(ImmutableOpenMap<String, IndexTemplateMetaData> templates) {
        HashMap<String, IndexTemplateMetaData> existingMap = new HashMap<String, IndexTemplateMetaData>();
        for (ObjectObjectCursor<String, IndexTemplateMetaData> objectObjectCursor : templates) {
            existingMap.put((String)objectObjectCursor.key, (IndexTemplateMetaData)objectObjectCursor.value);
        }
        Map upgradedMap = (Map)this.indexTemplateMetaDataUpgraders.apply(existingMap);
        if (!upgradedMap.equals(existingMap)) {
            HashSet hashSet = new HashSet();
            HashMap changes = new HashMap();
            existingMap.keySet().forEach(s -> {
                if (!upgradedMap.containsKey(s)) {
                    deletes.add(s);
                }
            });
            upgradedMap.forEach((key, value) -> {
                if (!value.equals(existingMap.get(key))) {
                    changes.put(key, this.toBytesReference((IndexTemplateMetaData)value));
                }
            });
            return Optional.of(new Tuple(changes, hashSet));
        }
        return Optional.empty();
    }

    private BytesReference toBytesReference(IndexTemplateMetaData templateMetaData) {
        try {
            return XContentHelper.toXContent((builder, params) -> {
                IndexTemplateMetaData.Builder.toInnerXContent(templateMetaData, builder, params);
                return builder;
            }, XContentType.JSON, PARAMS, false);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot serialize template [" + templateMetaData.getName() + "]", ex);
        }
    }
}

