/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.Diff;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.NamedDiff;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.MetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.joda.Joda;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ContextParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.Index;

public final class IndexGraveyard
implements MetaData.Custom {
    public static final Setting<Integer> SETTING_MAX_TOMBSTONES = Setting.intSetting("cluster.indices.tombstones.size", 500, Setting.Property.NodeScope);
    public static final String TYPE = "index-graveyard";
    private static final ParseField TOMBSTONES_FIELD = new ParseField("tombstones", new String[0]);
    private static final ObjectParser<List<Tombstone>, Void> GRAVEYARD_PARSER = new ObjectParser("index_graveyard", ArrayList::new);
    private final List<Tombstone> tombstones;

    private IndexGraveyard(List<Tombstone> list) {
        assert (list != null);
        this.tombstones = Collections.unmodifiableList(list);
    }

    public IndexGraveyard(StreamInput in) throws IOException {
        int queueSize = in.readVInt();
        ArrayList<Tombstone> tombstones = new ArrayList<Tombstone>(queueSize);
        for (int i = 0; i < queueSize; ++i) {
            tombstones.add(new Tombstone(in));
        }
        this.tombstones = Collections.unmodifiableList(tombstones);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    @Override
    public EnumSet<MetaData.XContentContext> context() {
        return MetaData.API_AND_GATEWAY;
    }

    public boolean equals(Object obj) {
        return obj instanceof IndexGraveyard && Objects.equals(this.tombstones, ((IndexGraveyard)obj).tombstones);
    }

    public int hashCode() {
        return this.tombstones.hashCode();
    }

    public List<Tombstone> getTombstones() {
        return this.tombstones;
    }

    public boolean containsIndex(Index index) {
        for (Tombstone tombstone : this.tombstones) {
            if (!tombstone.getIndex().equals(index)) continue;
            return true;
        }
        return false;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray(TOMBSTONES_FIELD.getPreferredName());
        for (Tombstone tombstone : this.tombstones) {
            tombstone.toXContent(builder, params);
        }
        return builder.endArray();
    }

    public static IndexGraveyard fromXContent(XContentParser parser) throws IOException {
        return new IndexGraveyard(GRAVEYARD_PARSER.parse(parser, null));
    }

    public String toString() {
        return "IndexGraveyard[" + this.tombstones + "]";
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.tombstones.size());
        for (Tombstone tombstone : this.tombstones) {
            tombstone.writeTo(out);
        }
    }

    @Override
    public Diff<MetaData.Custom> diff(MetaData.Custom previous) {
        return new IndexGraveyardDiff((IndexGraveyard)previous, this);
    }

    public static NamedDiff<MetaData.Custom> readDiffFrom(StreamInput in) throws IOException {
        return new IndexGraveyardDiff(in);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(IndexGraveyard graveyard) {
        return new Builder(graveyard);
    }

    static {
        GRAVEYARD_PARSER.declareObjectArray(List::addAll, Tombstone.getParser(), TOMBSTONES_FIELD);
    }

    public static final class Tombstone
    implements ToXContentObject,
    Writeable {
        private static final String INDEX_KEY = "index";
        private static final String DELETE_DATE_IN_MILLIS_KEY = "delete_date_in_millis";
        private static final String DELETE_DATE_KEY = "delete_date";
        private static final ObjectParser<Builder, Void> TOMBSTONE_PARSER = new ObjectParser("tombstoneEntry", () -> new Builder());
        private final Index index;
        private final long deleteDateInMillis;

        static ContextParser<Void, Tombstone> getParser() {
            return (parser, context) -> TOMBSTONE_PARSER.apply(parser, null).build();
        }

        private Tombstone(Index index, long deleteDateInMillis) {
            Objects.requireNonNull(index);
            if (deleteDateInMillis < 0L) {
                throw new IllegalArgumentException("invalid deleteDateInMillis [" + deleteDateInMillis + "]");
            }
            this.index = index;
            this.deleteDateInMillis = deleteDateInMillis;
        }

        private Tombstone(StreamInput in) throws IOException {
            this.index = new Index(in);
            this.deleteDateInMillis = in.readLong();
        }

        public Index getIndex() {
            return this.index;
        }

        public long getDeleteDateInMillis() {
            return this.deleteDateInMillis;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.index.writeTo(out);
            out.writeLong(this.deleteDateInMillis);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Tombstone that = (Tombstone)other;
            return this.index.equals(that.index) && this.deleteDateInMillis == that.deleteDateInMillis;
        }

        public int hashCode() {
            int result = this.index.hashCode();
            result = 31 * result + Long.hashCode(this.deleteDateInMillis);
            return result;
        }

        public String toString() {
            return "[index=" + this.index + ", deleteDate=" + Joda.getStrictStandardDateFormatter().formatMillis(this.deleteDateInMillis) + "]";
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(INDEX_KEY);
            this.index.toXContent(builder, params);
            builder.timeField(DELETE_DATE_IN_MILLIS_KEY, DELETE_DATE_KEY, this.deleteDateInMillis);
            return builder.endObject();
        }

        public static Tombstone fromXContent(XContentParser parser) throws IOException {
            return TOMBSTONE_PARSER.parse(parser, null).build();
        }

        static {
            TOMBSTONE_PARSER.declareObject(Builder::index, (parser, context) -> Index.fromXContent(parser), new ParseField(INDEX_KEY, new String[0]));
            TOMBSTONE_PARSER.declareLong(Builder::deleteDateInMillis, new ParseField(DELETE_DATE_IN_MILLIS_KEY, new String[0]));
            TOMBSTONE_PARSER.declareString((b, s) -> {}, new ParseField(DELETE_DATE_KEY, new String[0]));
        }

        private static final class Builder {
            private Index index;
            private long deleteDateInMillis = -1L;

            private Builder() {
            }

            public void index(Index index) {
                this.index = index;
            }

            public void deleteDateInMillis(long deleteDate) {
                this.deleteDateInMillis = deleteDate;
            }

            public Tombstone build() {
                assert (this.index != null);
                assert (this.deleteDateInMillis > -1L);
                return new Tombstone(this.index, this.deleteDateInMillis);
            }
        }
    }

    public static final class IndexGraveyardDiff
    implements NamedDiff<MetaData.Custom> {
        private final List<Tombstone> added;
        private final int removedCount;

        IndexGraveyardDiff(StreamInput in) throws IOException {
            this.added = Collections.unmodifiableList(in.readList(streamInput -> new Tombstone(streamInput)));
            this.removedCount = in.readVInt();
        }

        IndexGraveyardDiff(IndexGraveyard previous, IndexGraveyard current) {
            int removed;
            List<Object> added;
            List previousTombstones = previous.tombstones;
            List currentTombstones = current.tombstones;
            if (previousTombstones.isEmpty()) {
                added = new ArrayList(currentTombstones);
                removed = 0;
            } else if (currentTombstones.isEmpty()) {
                added = Collections.emptyList();
                removed = previousTombstones.size();
            } else {
                Tombstone lastAddedTombstone = (Tombstone)previousTombstones.get(previousTombstones.size() - 1);
                int addedIndex = currentTombstones.lastIndexOf(lastAddedTombstone);
                added = addedIndex < currentTombstones.size() ? currentTombstones.subList(addedIndex + 1, currentTombstones.size()) : Collections.emptyList();
                Tombstone firstTombstone = (Tombstone)currentTombstones.get(0);
                int idx = previousTombstones.indexOf(firstTombstone);
                if (idx < 0) {
                    assert (added.equals(currentTombstones));
                    idx = previousTombstones.size();
                }
                removed = idx;
            }
            this.added = Collections.unmodifiableList(added);
            this.removedCount = removed;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.added);
            out.writeVInt(this.removedCount);
        }

        @Override
        public IndexGraveyard apply(MetaData.Custom previous) {
            IndexGraveyard old = (IndexGraveyard)previous;
            if (this.removedCount > old.tombstones.size()) {
                throw new IllegalStateException("IndexGraveyardDiff cannot remove [" + this.removedCount + "] entries from [" + old.tombstones.size() + "] tombstones.");
            }
            ArrayList<Tombstone> newTombstones = new ArrayList<Tombstone>(old.tombstones.subList(this.removedCount, old.tombstones.size()));
            for (Tombstone tombstone : this.added) {
                newTombstones.add(tombstone);
            }
            return new Builder().addBuiltTombstones(newTombstones).build();
        }

        public List<Tombstone> getAdded() {
            return this.added;
        }

        public int getRemovedCount() {
            return this.removedCount;
        }

        @Override
        public String getWriteableName() {
            return IndexGraveyard.TYPE;
        }
    }

    public static final class Builder {
        private List<Tombstone> tombstones;
        private int numPurged = -1;
        private final long currentTime = System.currentTimeMillis();

        private Builder() {
            this.tombstones = new ArrayList<Tombstone>();
        }

        private Builder(IndexGraveyard that) {
            this.tombstones = new ArrayList<Tombstone>(that.getTombstones());
        }

        public List<Tombstone> tombstones() {
            return Collections.unmodifiableList(this.tombstones);
        }

        public Builder addTombstone(Index index) {
            this.tombstones.add(new Tombstone(index, this.currentTime));
            return this;
        }

        public Builder addTombstones(Collection<Index> indices) {
            for (Index index : indices) {
                this.addTombstone(index);
            }
            return this;
        }

        Builder addBuiltTombstones(List<Tombstone> tombstones) {
            this.tombstones.addAll(tombstones);
            return this;
        }

        public int getNumPurged() {
            assert (this.numPurged != -1);
            return this.numPurged;
        }

        private int purge(int maxTombstones) {
            int count = this.tombstones().size() - maxTombstones;
            if (count <= 0) {
                return 0;
            }
            this.tombstones = this.tombstones.subList(count, this.tombstones.size());
            return count;
        }

        public IndexGraveyard build() {
            return this.build(Settings.EMPTY);
        }

        public IndexGraveyard build(Settings settings) {
            this.numPurged = this.purge(SETTING_MAX_TOMBSTONES.get(settings));
            return new IndexGraveyard(this.tombstones);
        }
    }
}

