/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.AbstractNamedDiffable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.NamedDiff;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.ImmutableOpenMap;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.snapshots.Snapshot;

public class RestoreInProgress
extends AbstractNamedDiffable<ClusterState.Custom>
implements ClusterState.Custom,
Iterable<Entry> {
    public static final String BWC_UUID = new UUID(0L, 0L).toString();
    public static final String TYPE = "restore";
    private final ImmutableOpenMap<String, Entry> entries;

    private RestoreInProgress(ImmutableOpenMap<String, Entry> entries) {
        this.entries = entries;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreInProgress that = (RestoreInProgress)o;
        return this.entries.equals(that.entries);
    }

    public int hashCode() {
        return this.entries.hashCode();
    }

    public String toString() {
        return "RestoreInProgress[" + this.entries + "]";
    }

    public Entry get(String restoreUUID) {
        return this.entries.get(restoreUUID);
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries.valuesIt();
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public Version getMinimalSupportedVersion() {
        return Version.CURRENT.minimumCompatibilityVersion();
    }

    public static NamedDiff<ClusterState.Custom> readDiffFrom(StreamInput in) throws IOException {
        return RestoreInProgress.readDiffFrom(ClusterState.Custom.class, TYPE, in);
    }

    public RestoreInProgress(StreamInput in) throws IOException {
        int count = in.readVInt();
        ImmutableOpenMap.Builder<String, Entry> entriesBuilder = ImmutableOpenMap.builder(count);
        for (int i = 0; i < count; ++i) {
            String uuid = in.getVersion().onOrAfter(Version.V_6_6_0) ? in.readString() : BWC_UUID;
            Snapshot snapshot = new Snapshot(in);
            State state = State.fromValue(in.readByte());
            int indices = in.readVInt();
            ArrayList<String> indexBuilder = new ArrayList<String>();
            for (int j = 0; j < indices; ++j) {
                indexBuilder.add(in.readString());
            }
            ImmutableOpenMap.Builder<ShardId, ShardRestoreStatus> builder = ImmutableOpenMap.builder();
            int shards = in.readVInt();
            for (int j = 0; j < shards; ++j) {
                ShardId shardId = ShardId.readShardId(in);
                ShardRestoreStatus shardState = ShardRestoreStatus.readShardRestoreStatus(in);
                builder.put(shardId, shardState);
            }
            entriesBuilder.put(uuid, new Entry(uuid, snapshot, state, Collections.unmodifiableList(indexBuilder), builder.build()));
        }
        this.entries = entriesBuilder.build();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.entries.size());
        for (ObjectCursor v : this.entries.values()) {
            Entry entry = (Entry)v.value;
            if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
                out.writeString(entry.uuid);
            }
            entry.snapshot().writeTo(out);
            out.writeByte(entry.state().value());
            out.writeVInt(entry.indices().size());
            for (String index : entry.indices()) {
                out.writeString(index);
            }
            out.writeVInt(entry.shards().size());
            for (ObjectObjectCursor shardEntry : entry.shards()) {
                ((ShardId)shardEntry.key).writeTo(out);
                ((ShardRestoreStatus)shardEntry.value).writeTo(out);
            }
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startArray("snapshots");
        for (ObjectCursor entry : this.entries.values()) {
            this.toXContent((Entry)entry.value, builder, params);
        }
        builder.endArray();
        return builder;
    }

    public void toXContent(Entry entry, XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("snapshot", entry.snapshot().getSnapshotId().getName());
        builder.field("repository", entry.snapshot().getRepository());
        builder.field("state", (Object)entry.state());
        builder.startArray("indices");
        for (String index : entry.indices()) {
            builder.value(index);
        }
        builder.endArray();
        builder.startArray("shards");
        for (ObjectObjectCursor shardEntry : entry.shards) {
            ShardId shardId = (ShardId)shardEntry.key;
            ShardRestoreStatus status = (ShardRestoreStatus)shardEntry.value;
            builder.startObject();
            builder.field("index", shardId.getIndex());
            builder.field("shard", shardId.getId());
            builder.field("state", (Object)status.state());
            builder.endObject();
        }
        builder.endArray();
        builder.endObject();
    }

    public static enum State {
        INIT(0),
        STARTED(1),
        SUCCESS(2),
        FAILURE(3);

        private byte value;

        private State(byte value) {
            this.value = value;
        }

        public byte value() {
            return this.value;
        }

        public boolean completed() {
            return this == SUCCESS || this == FAILURE;
        }

        public static State fromValue(byte value) {
            switch (value) {
                case 0: {
                    return INIT;
                }
                case 1: {
                    return STARTED;
                }
                case 2: {
                    return SUCCESS;
                }
                case 3: {
                    return FAILURE;
                }
            }
            throw new IllegalArgumentException("No snapshot state for value [" + value + "]");
        }
    }

    public static class ShardRestoreStatus {
        private State state;
        private String nodeId;
        private String reason;

        private ShardRestoreStatus() {
        }

        public ShardRestoreStatus(String nodeId) {
            this(nodeId, State.INIT);
        }

        public ShardRestoreStatus(String nodeId, State state) {
            this(nodeId, state, null);
        }

        public ShardRestoreStatus(String nodeId, State state, String reason) {
            this.nodeId = nodeId;
            this.state = state;
            this.reason = reason;
        }

        public State state() {
            return this.state;
        }

        public String nodeId() {
            return this.nodeId;
        }

        public String reason() {
            return this.reason;
        }

        public static ShardRestoreStatus readShardRestoreStatus(StreamInput in) throws IOException {
            ShardRestoreStatus shardSnapshotStatus = new ShardRestoreStatus();
            shardSnapshotStatus.readFrom(in);
            return shardSnapshotStatus;
        }

        public void readFrom(StreamInput in) throws IOException {
            this.nodeId = in.readOptionalString();
            this.state = State.fromValue(in.readByte());
            this.reason = in.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.nodeId);
            out.writeByte(this.state.value);
            out.writeOptionalString(this.reason);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ShardRestoreStatus status = (ShardRestoreStatus)o;
            return this.state == status.state && Objects.equals(this.nodeId, status.nodeId) && Objects.equals(this.reason, status.reason);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.state, this.nodeId, this.reason});
        }
    }

    public static class Entry {
        private final String uuid;
        private final State state;
        private final Snapshot snapshot;
        private final ImmutableOpenMap<ShardId, ShardRestoreStatus> shards;
        private final List<String> indices;

        public Entry(String uuid, Snapshot snapshot, State state, List<String> indices, ImmutableOpenMap<ShardId, ShardRestoreStatus> shards) {
            this.snapshot = Objects.requireNonNull(snapshot);
            this.state = Objects.requireNonNull(state);
            this.indices = Objects.requireNonNull(indices);
            this.shards = shards == null ? ImmutableOpenMap.of() : shards;
            this.uuid = Objects.requireNonNull(uuid);
        }

        public String uuid() {
            return this.uuid;
        }

        public Snapshot snapshot() {
            return this.snapshot;
        }

        public ImmutableOpenMap<ShardId, ShardRestoreStatus> shards() {
            return this.shards;
        }

        public State state() {
            return this.state;
        }

        public List<String> indices() {
            return this.indices;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            return this.uuid.equals(entry.uuid) && this.snapshot.equals(entry.snapshot) && this.state == entry.state && this.indices.equals(entry.indices) && this.shards.equals(entry.shards);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.uuid, this.snapshot, this.state, this.indices, this.shards});
        }
    }

    public static final class Builder {
        private final ImmutableOpenMap.Builder<String, Entry> entries = ImmutableOpenMap.builder();

        public Builder() {
        }

        public Builder(RestoreInProgress restoreInProgress) {
            this.entries.putAll(restoreInProgress.entries);
        }

        public Builder add(Entry entry) {
            this.entries.put(entry.uuid, entry);
            return this;
        }

        public RestoreInProgress build() {
            return new RestoreInProgress(this.entries.build());
        }
    }
}

