/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.transport;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.Action;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionRequestBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.GenericAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.TransportActionNodeProxy;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.transport.TransportClientNodesService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportService;

final class TransportProxyClient {
    private final TransportClientNodesService nodesService;
    private final Map<Action, TransportActionNodeProxy> proxies;

    TransportProxyClient(Settings settings, TransportService transportService, TransportClientNodesService nodesService, List<GenericAction> actions) {
        this.nodesService = nodesService;
        HashMap proxies = new HashMap();
        for (GenericAction action : actions) {
            if (!(action instanceof Action)) continue;
            proxies.put((Action)action, new TransportActionNodeProxy(settings, action, transportService));
        }
        this.proxies = Collections.unmodifiableMap(proxies);
    }

    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder>> void execute(Action<Request, Response, RequestBuilder> action, Request request, ActionListener<Response> listener) {
        TransportActionNodeProxy proxy = this.proxies.get(action);
        assert (proxy != null) : "no proxy found for action: " + action;
        this.nodesService.execute((n, l) -> proxy.execute(n, request, l), listener);
    }
}

