/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.rollup;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.ValidationException;

public class GetRollupJobRequest
implements Validatable {
    private final String jobId;

    public GetRollupJobRequest(String jobId) {
        Objects.requireNonNull(jobId, "jobId is required");
        if ("_all".equals(jobId)) {
            throw new IllegalArgumentException("use the default ctor to ask for all jobs");
        }
        this.jobId = jobId;
    }

    public GetRollupJobRequest() {
        this.jobId = "_all";
    }

    public String getJobId() {
        return this.jobId;
    }

    @Override
    public Optional<ValidationException> validate() {
        return Optional.empty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetRollupJobRequest that = (GetRollupJobRequest)o;
        return this.jobId.equals(that.jobId);
    }

    public int hashCode() {
        return Objects.hash(this.jobId);
    }
}

