/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.ml.job.config;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class ModelPlotConfig
implements ToXContentObject {
    private static final ParseField TYPE_FIELD = new ParseField("model_plot_config", new String[0]);
    private static final ParseField ENABLED_FIELD = new ParseField("enabled", new String[0]);
    public static final ParseField TERMS_FIELD = new ParseField("terms", new String[0]);
    public static final ConstructingObjectParser<ModelPlotConfig, Void> PARSER = new ConstructingObjectParser(TYPE_FIELD.getPreferredName(), true, a -> new ModelPlotConfig((Boolean)a[0], (String)a[1]));
    private final boolean enabled;
    private final String terms;

    public ModelPlotConfig(boolean enabled, String terms) {
        this.enabled = enabled;
        this.terms = terms;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
        if (this.terms != null) {
            builder.field(TERMS_FIELD.getPreferredName(), this.terms);
        }
        builder.endObject();
        return builder;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTerms() {
        return this.terms;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModelPlotConfig)) {
            return false;
        }
        ModelPlotConfig that = (ModelPlotConfig)other;
        return this.enabled == that.enabled && Objects.equals(this.terms, that.terms);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.terms);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TERMS_FIELD);
    }
}

