/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.ml.datafeed;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class ChunkingConfig
implements ToXContentObject {
    public static final ParseField MODE_FIELD = new ParseField("mode", new String[0]);
    public static final ParseField TIME_SPAN_FIELD = new ParseField("time_span", new String[0]);
    public static final ConstructingObjectParser<ChunkingConfig, Void> PARSER = new ConstructingObjectParser("chunking_config", true, a -> new ChunkingConfig((Mode)((Object)((Object)a[0])), (TimeValue)a[1]));
    private final Mode mode;
    private final TimeValue timeSpan;

    ChunkingConfig(Mode mode, @Nullable TimeValue timeSpan) {
        this.mode = Objects.requireNonNull(mode, MODE_FIELD.getPreferredName());
        this.timeSpan = timeSpan;
    }

    @Nullable
    public TimeValue getTimeSpan() {
        return this.timeSpan;
    }

    Mode getMode() {
        return this.mode;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(MODE_FIELD.getPreferredName(), (Object)this.mode);
        if (this.timeSpan != null) {
            builder.field(TIME_SPAN_FIELD.getPreferredName(), this.timeSpan.getStringRep());
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.timeSpan});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ChunkingConfig other = (ChunkingConfig)obj;
        return Objects.equals((Object)this.mode, (Object)other.mode) && Objects.equals(this.timeSpan, other.timeSpan);
    }

    public static ChunkingConfig newAuto() {
        return new ChunkingConfig(Mode.AUTO, null);
    }

    public static ChunkingConfig newOff() {
        return new ChunkingConfig(Mode.OFF, null);
    }

    public static ChunkingConfig newManual(TimeValue timeSpan) {
        return new ChunkingConfig(Mode.MANUAL, timeSpan);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return Mode.fromString(p.text());
            }
            throw new IllegalArgumentException("Unsupported token [" + (Object)((Object)p.currentToken()) + "]");
        }, MODE_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return TimeValue.parseTimeValue(p.text(), TIME_SPAN_FIELD.getPreferredName());
            }
            throw new IllegalArgumentException("Unsupported token [" + (Object)((Object)p.currentToken()) + "]");
        }, TIME_SPAN_FIELD, ObjectParser.ValueType.STRING);
    }

    public static enum Mode {
        AUTO,
        MANUAL,
        OFF;


        public static Mode fromString(String value) {
            return Mode.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

