/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client;

import java.util.concurrent.TimeUnit;

final class DeadHostState
implements Comparable<DeadHostState> {
    private static final long MIN_CONNECTION_TIMEOUT_NANOS = TimeUnit.MINUTES.toNanos(1L);
    static final long MAX_CONNECTION_TIMEOUT_NANOS = TimeUnit.MINUTES.toNanos(30L);
    private final int failedAttempts;
    private final long deadUntilNanos;
    private final TimeSupplier timeSupplier;

    DeadHostState(TimeSupplier timeSupplier) {
        this.failedAttempts = 1;
        this.deadUntilNanos = timeSupplier.nanoTime() + MIN_CONNECTION_TIMEOUT_NANOS;
        this.timeSupplier = timeSupplier;
    }

    DeadHostState(DeadHostState previousDeadHostState) {
        long timeoutNanos = (long)Math.min((double)(MIN_CONNECTION_TIMEOUT_NANOS * 2L) * Math.pow(2.0, (double)previousDeadHostState.failedAttempts * 0.5 - 1.0), (double)MAX_CONNECTION_TIMEOUT_NANOS);
        this.deadUntilNanos = previousDeadHostState.timeSupplier.nanoTime() + timeoutNanos;
        this.failedAttempts = previousDeadHostState.failedAttempts + 1;
        this.timeSupplier = previousDeadHostState.timeSupplier;
    }

    boolean shallBeRetried() {
        return this.timeSupplier.nanoTime() - this.deadUntilNanos > 0L;
    }

    long getDeadUntilNanos() {
        return this.deadUntilNanos;
    }

    int getFailedAttempts() {
        return this.failedAttempts;
    }

    @Override
    public int compareTo(DeadHostState other) {
        if (this.timeSupplier != other.timeSupplier) {
            throw new IllegalArgumentException("can't compare DeadHostStates with different clocks [" + this.timeSupplier + " != " + other.timeSupplier + "]");
        }
        return Long.compare(this.deadUntilNanos, other.deadUntilNanos);
    }

    public String toString() {
        return "DeadHostState{failedAttempts=" + this.failedAttempts + ", deadUntilNanos=" + this.deadUntilNanos + ", timeSupplier=" + this.timeSupplier + '}';
    }

    static interface TimeSupplier {
        public static final TimeSupplier DEFAULT = new TimeSupplier(){

            @Override
            public long nanoTime() {
                return System.nanoTime();
            }

            public String toString() {
                return "nanoTime";
            }
        };

        public long nanoTime();
    }
}

