/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ExceptionsHelper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ShardOperationFailedException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.ShardSearchFailure;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestStatus;

public class SearchPhaseExecutionException
extends ElasticsearchException {
    private final String phaseName;
    private final ShardSearchFailure[] shardFailures;

    public SearchPhaseExecutionException(String phaseName, String msg, ShardSearchFailure[] shardFailures) {
        this(phaseName, msg, null, shardFailures);
    }

    public SearchPhaseExecutionException(String phaseName, String msg, Throwable cause, ShardSearchFailure[] shardFailures) {
        super(msg, SearchPhaseExecutionException.deduplicateCause(cause, shardFailures), new Object[0]);
        this.phaseName = phaseName;
        this.shardFailures = shardFailures;
    }

    public SearchPhaseExecutionException(StreamInput in) throws IOException {
        super(in);
        this.phaseName = in.readOptionalString();
        int numFailures = in.readVInt();
        this.shardFailures = new ShardSearchFailure[numFailures];
        for (int i = 0; i < numFailures; ++i) {
            this.shardFailures[i] = ShardSearchFailure.readShardSearchFailure(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.phaseName);
        out.writeVInt(this.shardFailures.length);
        for (ShardSearchFailure failure : this.shardFailures) {
            failure.writeTo(out);
        }
    }

    private static Throwable deduplicateCause(Throwable cause, ShardSearchFailure[] shardFailures) {
        if (shardFailures == null) {
            throw new IllegalArgumentException("shardSearchFailures must not be null");
        }
        if (cause != null) {
            for (ShardSearchFailure failure : shardFailures) {
                if (failure.getCause() != cause) continue;
                return null;
            }
        }
        return cause;
    }

    @Override
    public RestStatus status() {
        if (this.shardFailures.length == 0) {
            return RestStatus.SERVICE_UNAVAILABLE;
        }
        RestStatus status = this.shardFailures[0].status();
        if (this.shardFailures.length > 1) {
            for (int i = 1; i < this.shardFailures.length; ++i) {
                if (this.shardFailures[i].status().getStatus() < 500) continue;
                status = this.shardFailures[i].status();
            }
        }
        return status;
    }

    public ShardSearchFailure[] shardFailures() {
        return this.shardFailures;
    }

    @Override
    public Throwable getCause() {
        ElasticsearchException[] elasticsearchExceptionArray;
        int n;
        int n2;
        Throwable cause = super.getCause();
        if (cause == null && (n2 = 0) < (n = (elasticsearchExceptionArray = this.guessRootCauses()).length)) {
            ElasticsearchException rootCause = elasticsearchExceptionArray[n2];
            return rootCause;
        }
        return cause;
    }

    private static String buildMessage(String phaseName, String msg, ShardSearchFailure[] shardFailures) {
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to execute phase [").append(phaseName).append("], ").append(msg);
        if (shardFailures != null && shardFailures.length > 0) {
            sb.append("; shardFailures ");
            for (ShardSearchFailure shardFailure : shardFailures) {
                if (shardFailure.shard() != null) {
                    sb.append("{").append(shardFailure.shard()).append(": ").append(shardFailure.reason()).append("}");
                    continue;
                }
                sb.append("{").append(shardFailure.reason()).append("}");
            }
        }
        return sb.toString();
    }

    @Override
    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        ShardOperationFailedException[] failures;
        builder.field("phase", this.phaseName);
        builder.field("grouped", true);
        builder.field("failed_shards");
        builder.startArray();
        for (ShardOperationFailedException failure : failures = ExceptionsHelper.groupBy(this.shardFailures)) {
            builder.startObject();
            failure.toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Throwable ex = ExceptionsHelper.unwrapCause(this);
        if (ex != this) {
            SearchPhaseExecutionException.generateThrowableXContent(builder, params, this);
        } else {
            SearchPhaseExecutionException.innerToXContent(builder, params, this, this.getExceptionName(), this.getMessage(), this.getHeaders(), this.getMetadata(), super.getCause());
        }
        return builder;
    }

    @Override
    public ElasticsearchException[] guessRootCauses() {
        ShardOperationFailedException[] failures = ExceptionsHelper.groupBy(this.shardFailures);
        ArrayList<ElasticsearchException> rootCauses = new ArrayList<ElasticsearchException>(failures.length);
        for (ShardOperationFailedException failure : failures) {
            ElasticsearchException[] guessRootCauses = ElasticsearchException.guessRootCauses(failure.getCause());
            rootCauses.addAll(Arrays.asList(guessRootCauses));
        }
        return rootCauses.toArray(new ElasticsearchException[0]);
    }

    @Override
    public String toString() {
        return SearchPhaseExecutionException.buildMessage(this.phaseName, this.getMessage(), this.shardFailures);
    }

    public String getPhaseName() {
        return this.phaseName;
    }
}

