/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.main;

import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Build;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.main.MainRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.main.MainResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.HandledTransportAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.node.Node;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestStatus;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportService;

public class TransportMainAction
extends HandledTransportAction<MainRequest, MainResponse> {
    private final String nodeName;
    private final ClusterService clusterService;

    @Inject
    public TransportMainAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService) {
        super(settings, "cluster:monitor/main", threadPool, transportService, actionFilters, indexNameExpressionResolver, MainRequest::new);
        this.nodeName = Node.NODE_NAME_SETTING.get(settings);
        this.clusterService = clusterService;
    }

    @Override
    protected void doExecute(MainRequest request, ActionListener<MainResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        boolean available = !clusterState.getBlocks().hasGlobalBlockWithStatus(RestStatus.SERVICE_UNAVAILABLE);
        listener.onResponse(new MainResponse(this.nodeName, Version.CURRENT, clusterState.getClusterName(), clusterState.metaData().clusterUUID(), Build.CURRENT, available));
    }
}

