/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.SimulateDocumentResult;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ingest.WriteableIngestDocument;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ingest.IngestDocument;

public final class SimulateDocumentBaseResult
implements SimulateDocumentResult {
    private final WriteableIngestDocument ingestDocument;
    private final Exception failure;
    public static final ConstructingObjectParser<SimulateDocumentBaseResult, Void> PARSER = new ConstructingObjectParser("simulate_document_base_result", true, a -> {
        if (a[1] == null) {
            assert (a[0] != null);
            return new SimulateDocumentBaseResult(((WriteableIngestDocument)a[0]).getIngestDocument());
        }
        assert (a[0] == null);
        return new SimulateDocumentBaseResult((ElasticsearchException)a[1]);
    });

    public SimulateDocumentBaseResult(IngestDocument ingestDocument) {
        this.ingestDocument = new WriteableIngestDocument(ingestDocument);
        this.failure = null;
    }

    public SimulateDocumentBaseResult(Exception failure) {
        this.ingestDocument = null;
        this.failure = failure;
    }

    public SimulateDocumentBaseResult(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            this.ingestDocument = null;
            this.failure = in.readException();
        } else {
            this.ingestDocument = new WriteableIngestDocument(in);
            this.failure = null;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (this.failure == null) {
            out.writeBoolean(false);
            this.ingestDocument.writeTo(out);
        } else {
            out.writeBoolean(true);
            out.writeException(this.failure);
        }
    }

    public IngestDocument getIngestDocument() {
        if (this.ingestDocument == null) {
            return null;
        }
        return this.ingestDocument.getIngestDocument();
    }

    public Exception getFailure() {
        return this.failure;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.failure == null) {
            this.ingestDocument.toXContent(builder, params);
        } else {
            ElasticsearchException.generateFailureXContent(builder, params, this.failure, true);
        }
        builder.endObject();
        return builder;
    }

    public static SimulateDocumentBaseResult fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), WriteableIngestDocument.INGEST_DOC_PARSER, new ParseField("doc", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), new ParseField("error", new String[0]));
    }
}

