/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.com.github.mustachejava.reflect;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Logger;
import org.apache.flink.elasticsearch6.shaded.com.github.mustachejava.Binding;
import org.apache.flink.elasticsearch6.shaded.com.github.mustachejava.Code;
import org.apache.flink.elasticsearch6.shaded.com.github.mustachejava.MustacheException;
import org.apache.flink.elasticsearch6.shaded.com.github.mustachejava.ObjectHandler;
import org.apache.flink.elasticsearch6.shaded.com.github.mustachejava.TemplateContext;
import org.apache.flink.elasticsearch6.shaded.com.github.mustachejava.codes.PartialCode;
import org.apache.flink.elasticsearch6.shaded.com.github.mustachejava.reflect.MissingWrapper;
import org.apache.flink.elasticsearch6.shaded.com.github.mustachejava.util.GuardException;
import org.apache.flink.elasticsearch6.shaded.com.github.mustachejava.util.Wrapper;

public class GuardedBinding
implements Binding {
    private static Logger logger = Logger.getLogger("mustache");
    private static boolean debug = Boolean.getBoolean("mustache.debug");
    private final ObjectHandler oh;
    private final TemplateContext tc;
    private final String name;
    private final Code code;
    private Set<Wrapper> previousSet = new CopyOnWriteArraySet<Wrapper>();
    private volatile Wrapper[] prevWrappers;

    public GuardedBinding(ObjectHandler oh, String name, TemplateContext tc, Code code) {
        this.name = name;
        this.code = code;
        this.oh = oh;
        this.tc = tc;
    }

    @Override
    public Object get(List<Object> scopes) {
        Wrapper current = null;
        Wrapper[] wrappers = this.prevWrappers;
        if (wrappers != null) {
            for (Wrapper prevWrapper : wrappers) {
                try {
                    current = prevWrapper;
                    return this.oh.coerce(prevWrapper.call(scopes));
                }
                catch (GuardException guardException) {
                }
                catch (MustacheException me) {
                    throw new MustacheException("Failed: " + current, me);
                }
            }
        }
        return this.createAndGet(scopes);
    }

    private Object createAndGet(List<Object> scopes) {
        Wrapper wrapper = this.getWrapper(this.name, scopes);
        this.previousSet.add(wrapper);
        if (this.prevWrappers == null || this.prevWrappers.length != this.previousSet.size()) {
            this.prevWrappers = this.previousSet.toArray(new Wrapper[this.previousSet.size()]);
        }
        try {
            return this.oh.coerce(wrapper.call(scopes));
        }
        catch (GuardException e) {
            throw new GuardException("BUG: Unexpected guard failure: " + this.name + " " + this.previousSet + " " + Collections.singletonList(scopes));
        }
    }

    protected synchronized Wrapper getWrapper(String name, List<Object> scopes) {
        Wrapper wrapper = this.oh.find(name, scopes);
        if (wrapper instanceof MissingWrapper && debug && !(this.code instanceof PartialCode)) {
            GuardedBinding.logWarning("Failed to find: ", name, scopes, this.tc);
        }
        return wrapper;
    }

    public static void logWarning(String warning, String name, List<Object> scopes, TemplateContext tc) {
        StringBuilder sb = new StringBuilder(warning).append(name).append(" (").append(tc.file()).append(":").append(tc.line()).append(") ").append("in");
        scopes.stream().filter(scope -> scope != null).forEach(scope -> {
            Class<?> aClass = scope.getClass();
            try {
                sb.append(" ").append(aClass.getSimpleName());
            }
            catch (Exception e) {
                try {
                    sb.append(" ").append(aClass.getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        logger.warning(sb.toString());
    }
}

