/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.lang.reflect.Proxy;
import java.util.Objects;
import org.jline.utils.Log;

public final class Signals {
    private Signals() {
    }

    public static Object register(String name, Runnable handler) {
        Objects.requireNonNull(handler);
        return Signals.register(name, handler, handler.getClass().getClassLoader());
    }

    public static Object register(String name, Runnable handler, ClassLoader loader) {
        try {
            Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            Object signalHandler = Proxy.newProxyInstance(loader, new Class[]{signalHandlerClass}, (proxy, method, args) -> {
                if (method.getDeclaringClass() == Object.class) {
                    if ("toString".equals(method.getName())) {
                        return handler.toString();
                    }
                } else if (method.getDeclaringClass() == signalHandlerClass) {
                    Log.trace(() -> "Calling handler " + Signals.toString(handler) + " for signal " + name);
                    handler.run();
                }
                return null;
            });
            return Signals.doRegister(name, signalHandler);
        }
        catch (Exception e2) {
            Log.debug("Error registering handler for signal ", name, e2);
            return null;
        }
    }

    public static Object registerDefault(String name) {
        try {
            Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            return Signals.doRegister(name, signalHandlerClass.getField("SIG_DFL").get(null));
        }
        catch (Exception e2) {
            Log.debug("Error registering default handler for signal ", name, e2);
            return null;
        }
    }

    public static void unregister(String name, Object previous) {
        try {
            if (previous != null) {
                Signals.doRegister(name, previous);
            }
        }
        catch (Exception e2) {
            Log.debug("Error unregistering handler for signal ", name, e2);
        }
    }

    private static Object doRegister(String name, Object handler) throws Exception {
        Log.trace(() -> "Registering signal " + name + " with handler " + Signals.toString(handler));
        if ("QUIT".equals(name) || "INFO".equals(name) && "9".equals(System.getProperty("java.specification.version"))) {
            Log.trace(() -> "Ignoring unsupported signal " + name);
            return null;
        }
        Class<?> signalClass = Class.forName("sun.misc.Signal");
        Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
        Object signal = signalClass.getConstructor(String.class).newInstance(name);
        return signalClass.getMethod("handle", signalClass, signalHandlerClass).invoke(null, signal, handler);
    }

    private static String toString(Object handler) {
        try {
            Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            if (handler == signalHandlerClass.getField("SIG_DFL").get(null)) {
                return "SIG_DFL";
            }
            if (handler == signalHandlerClass.getField("SIG_IGN").get(null)) {
                return "SIG_IGN";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return handler != null ? handler.toString() : "null";
    }
}

