/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.CsvValidator;
import org.apache.flink.table.descriptors.CsvValidator$;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FileSystemValidator;
import org.apache.flink.table.descriptors.FileSystemValidator$;
import org.apache.flink.table.descriptors.SchemaValidator;
import org.apache.flink.table.descriptors.SchemaValidator$;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.sinks.CsvTableSink;
import org.apache.flink.table.util.JavaScalaConversionUtil$;
import scala.Function0;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-3Q!\u0001\u0002\u0002\u00025\u0011qcQ:w)\u0006\u0014G.Z*j].4\u0015m\u0019;pef\u0014\u0015m]3\u000b\u0005\r!\u0011!B:j].\u001c(BA\u0003\u0007\u0003\u0015!\u0018M\u00197f\u0015\t9\u0001\"A\u0003gY&t7N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u000191\u0002CA\b\u0015\u001b\u0005\u0001\"BA\t\u0013\u0003\u0011a\u0017M\\4\u000b\u0003M\tAA[1wC&\u0011Q\u0003\u0005\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005]QR\"\u0001\r\u000b\u0005e!\u0011!\u00034bGR|'/[3t\u0013\tY\u0002D\u0001\u0007UC\ndWMR1di>\u0014\u0018\u0010C\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002\u0005!)!\u0005\u0001C!G\u0005y!/Z9vSJ,GmQ8oi\u0016DH\u000fF\u0001%!\u0011)\u0003F\u000b\u0016\u000e\u0003\u0019R!a\n\n\u0002\tU$\u0018\u000e\\\u0005\u0003S\u0019\u00121!T1q!\tYCG\u0004\u0002-eA\u0011Q\u0006M\u0007\u0002])\u0011q\u0006D\u0001\u0007yI|w\u000e\u001e \u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0002\rA\u0013X\rZ3g\u0013\t)dG\u0001\u0004TiJLgn\u001a\u0006\u0003gABQ\u0001\u000f\u0001\u0005Be\n1c];qa>\u0014H/\u001a3Qe>\u0004XM\u001d;jKN$\u0012A\u000f\t\u0004KmR\u0013B\u0001\u001f'\u0005\u0011a\u0015n\u001d;\t\u000by\u0002A\u0011C \u0002\u001f\r\u0014X-\u0019;f)\u0006\u0014G.Z*j].$2\u0001Q\"J!\t\u0001\u0013)\u0003\u0002C\u0005\ta1i\u001d<UC\ndWmU5oW\")A)\u0010a\u0001\u000b\u0006Y\u0011n]*ue\u0016\fW.\u001b8h!\t1u)D\u00011\u0013\tA\u0005GA\u0004C_>dW-\u00198\t\u000b)k\u0004\u0019\u0001\u0013\u0002\u0015A\u0014x\u000e]3si&,7\u000f")
public abstract class CsvTableSinkFactoryBase
implements TableFactory {
    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> requiredContext() {
        void var1_1;
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("connector.type", FileSystemValidator$.MODULE$.CONNECTOR_TYPE_VALUE());
        context.put("format.type", CsvValidator$.MODULE$.FORMAT_TYPE_VALUE());
        context.put("connector.property-version", "1");
        context.put("format.property-version", "1");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> supportedProperties() {
        void var1_1;
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(FileSystemValidator$.MODULE$.CONNECTOR_PATH());
        properties.add(new StringBuilder(7).append(CsvValidator$.MODULE$.FORMAT_FIELDS()).append(".#.").append("type").toString());
        properties.add(new StringBuilder(7).append(CsvValidator$.MODULE$.FORMAT_FIELDS()).append(".#.").append("name").toString());
        properties.add(CsvValidator$.MODULE$.FORMAT_FIELD_DELIMITER());
        properties.add(FileSystemValidator$.MODULE$.CONNECTOR_PATH());
        properties.add(new StringBuilder(7).append(SchemaValidator$.MODULE$.SCHEMA()).append(".#.").append("type").toString());
        properties.add(new StringBuilder(7).append(SchemaValidator$.MODULE$.SCHEMA()).append(".#.").append("name").toString());
        return var1_1;
    }

    public CsvTableSink createTableSink(boolean isStreaming, Map<String, String> properties) {
        DescriptorProperties params = new DescriptorProperties();
        params.putProperties(properties);
        new FileSystemValidator().validate(params);
        new CsvValidator().validate(params);
        new SchemaValidator(isStreaming, false, false).validate(params);
        TableSchema formatSchema = params.getTableSchema(CsvValidator$.MODULE$.FORMAT_FIELDS());
        TableSchema tableSchema = params.getTableSchema(SchemaValidator$.MODULE$.SCHEMA());
        if (!formatSchema.equals(tableSchema)) {
            throw new TableException("Encodings that differ from the schema are not supported yet for CsvTableSink.");
        }
        String path = params.getString(FileSystemValidator$.MODULE$.CONNECTOR_PATH());
        String fieldDelimiter = (String)JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalString(CsvValidator$.MODULE$.FORMAT_FIELD_DELIMITER())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ",");
        CsvTableSink csvTableSink = new CsvTableSink(path, fieldDelimiter);
        return (CsvTableSink)csvTableSink.configure(formatSchema.getFieldNames(), formatSchema.getFieldTypes());
    }
}

