/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sinks;

import java.io.Serializable;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.DataSink;
import org.apache.flink.api.java.operators.MapOperator;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.table.sinks.AppendStreamTableSink;
import org.apache.flink.table.sinks.BatchTableSink;
import org.apache.flink.table.sinks.CsvFormatter;
import org.apache.flink.table.sinks.CsvTableSink$;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sinks.TableSinkBase;
import org.apache.flink.table.util.TableConnectorUtil$;
import org.apache.flink.types.Row;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u00015\u0011AbQ:w)\u0006\u0014G.Z*j].T!a\u0001\u0003\u0002\u000bMLgn[:\u000b\u0005\u00151\u0011!\u0002;bE2,'BA\u0004\t\u0003\u00151G.\u001b8l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M)\u0001A\u0004\u000b\u001fCA\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u00042!\u0006\f\u0019\u001b\u0005\u0011\u0011BA\f\u0003\u00055!\u0016M\u00197f'&t7NQ1tKB\u0011\u0011\u0004H\u0007\u00025)\u00111DB\u0001\u0006if\u0004Xm]\u0005\u0003;i\u00111AU8x!\r)r\u0004G\u0005\u0003A\t\u0011aBQ1uG\"$\u0016M\u00197f'&t7\u000eE\u0002\u0016EaI!a\t\u0002\u0003+\u0005\u0003\b/\u001a8e'R\u0014X-Y7UC\ndWmU5oW\"AQ\u0005\u0001B\u0001B\u0003%a%\u0001\u0003qCRD\u0007CA\u0014/\u001d\tAC\u0006\u0005\u0002*!5\t!F\u0003\u0002,\u0019\u00051AH]8pizJ!!\f\t\u0002\rA\u0013X\rZ3g\u0013\ty\u0003G\u0001\u0004TiJLgn\u001a\u0006\u0003[AA\u0001B\r\u0001\u0003\u0002\u0003\u0006IaM\u0001\u000bM&,G\u000e\u001a#fY&l\u0007cA\b5M%\u0011Q\u0007\u0005\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011]\u0002!\u0011!Q\u0001\na\n\u0001B\\;n\r&dWm\u001d\t\u0004\u001fQJ\u0004CA\b;\u0013\tY\u0004CA\u0002J]RD\u0001\"\u0010\u0001\u0003\u0002\u0003\u0006IAP\u0001\noJLG/Z'pI\u0016\u00042a\u0004\u001b@!\t\u0001\u0015K\u0004\u0002B\u001d:\u0011!i\u0013\b\u0003\u0007&s!\u0001\u0012%\u000f\u0005\u0015;eBA\u0015G\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002K\r\u0005!1m\u001c:f\u0013\taU*\u0001\u0002gg*\u0011!JB\u0005\u0003\u001fB\u000b!BR5mKNK8\u000f^3n\u0015\taU*\u0003\u0002S'\nIqK]5uK6{G-\u001a\u0006\u0003\u001fBCQ!\u0016\u0001\u0005\u0002Y\u000ba\u0001P5oSRtD#B,Y3j[\u0006CA\u000b\u0001\u0011\u0015)C\u000b1\u0001'\u0011\u0015\u0011D\u000b1\u00014\u0011\u00159D\u000b1\u00019\u0011\u0015iD\u000b1\u0001?\u0011\u0015)\u0006\u0001\"\u0001^)\r9fl\u0018\u0005\u0006Kq\u0003\rA\n\u0005\beq\u0003\n\u00111\u0001'\u0011\u0015)\u0006\u0001\"\u0001b)\u00159&m\u00193f\u0011\u0015)\u0003\r1\u0001'\u0011\u0015\u0011\u0004\r1\u0001'\u0011\u00159\u0004\r1\u0001:\u0011\u0015i\u0004\r1\u0001@\u0011\u00159\u0007\u0001\"\u0011i\u0003-)W.\u001b;ECR\f7+\u001a;\u0015\u0005%d\u0007CA\bk\u0013\tY\u0007C\u0001\u0003V]&$\b\"B7g\u0001\u0004q\u0017a\u00023bi\u0006\u001cV\r\u001e\t\u0004_RDR\"\u00019\u000b\u0005E\u0014\u0018\u0001\u00026bm\u0006T!a\u001d\u0004\u0002\u0007\u0005\u0004\u0018.\u0003\u0002va\n9A)\u0019;b'\u0016$\b\"B<\u0001\t\u0003B\u0018AD3nSR$\u0015\r^1TiJ,\u0017-\u001c\u000b\u0003SfDQA\u001f<A\u0002m\f!\u0002Z1uCN#(/Z1n!\u0011a\u0018Q\u0001\r\u000e\u0003uT!A`@\u0002\u0015\u0011\fG/Y:ue\u0016\fWNC\u0002t\u0003\u0003Q1!a\u0001\u0007\u0003%\u0019HO]3b[&tw-C\u0002\u0002\bu\u0014!\u0002R1uCN#(/Z1n\u0011\u001d\tY\u0001\u0001C)\u0003\u001b\tAaY8qsV\tA\u0003C\u0004\u0002\u0012\u0001!\t%a\u0005\u0002\u001b\u001d,GoT;uaV$H+\u001f9f+\t\t)\u0002E\u0003\u0002\u0018\u0005\u0005\u0002$\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003!!\u0018\u0010]3j]\u001a|'bAA\u0010e\u000611m\\7n_:LA!a\t\u0002\u001a\tyA+\u001f9f\u0013:4wN]7bi&|gnB\u0005\u0002(\t\t\t\u0011#\u0001\u0002*\u0005a1i\u001d<UC\ndWmU5oWB\u0019Q#a\u000b\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003[\u00192!a\u000b\u000f\u0011\u001d)\u00161\u0006C\u0001\u0003c!\"!!\u000b\t\u0015\u0005U\u00121FI\u0001\n\u0003\t9$A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003sQ3AJA\u001eW\t\ti\u0004\u0005\u0003\u0002@\u0005%SBAA!\u0015\u0011\t\u0019%!\u0012\u0002\u0013Ut7\r[3dW\u0016$'bAA$!\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005-\u0013\u0011\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class CsvTableSink
implements TableSinkBase<Row>,
BatchTableSink<Row>,
AppendStreamTableSink<Row> {
    private final String path;
    private final Option<String> fieldDelim;
    private final Option<Object> numFiles;
    private final Option<FileSystem.WriteMode> writeMode;
    private Option<String[]> org$apache$flink$table$sinks$TableSinkBase$$fieldNames;
    private Option<TypeInformation<?>[]> org$apache$flink$table$sinks$TableSinkBase$$fieldTypes;

    public static String $lessinit$greater$default$2() {
        return CsvTableSink$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String[] getFieldNames() {
        return TableSinkBase.getFieldNames$(this);
    }

    @Override
    public TypeInformation<?>[] getFieldTypes() {
        return TableSinkBase.getFieldTypes$(this);
    }

    @Override
    public final TableSink<Row> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        return TableSinkBase.configure$(this, fieldNames, fieldTypes);
    }

    @Override
    public Option<String[]> org$apache$flink$table$sinks$TableSinkBase$$fieldNames() {
        return this.org$apache$flink$table$sinks$TableSinkBase$$fieldNames;
    }

    @Override
    public void org$apache$flink$table$sinks$TableSinkBase$$fieldNames_$eq(Option<String[]> x$1) {
        this.org$apache$flink$table$sinks$TableSinkBase$$fieldNames = x$1;
    }

    @Override
    public Option<TypeInformation<?>[]> org$apache$flink$table$sinks$TableSinkBase$$fieldTypes() {
        return this.org$apache$flink$table$sinks$TableSinkBase$$fieldTypes;
    }

    @Override
    public void org$apache$flink$table$sinks$TableSinkBase$$fieldTypes_$eq(Option<TypeInformation<?>[]> x$1) {
        this.org$apache$flink$table$sinks$TableSinkBase$$fieldTypes = x$1;
    }

    @Override
    public void emitDataSet(DataSet<Row> dataSet) {
        DataSink dataSink;
        MapOperator csvRows = dataSet.map((MapFunction)new CsvFormatter((String)this.fieldDelim.getOrElse((Function0 & Serializable & scala.Serializable)() -> ",")));
        Object object = this.numFiles.isDefined() ? csvRows.setParallelism(BoxesRunTime.unboxToInt((Object)this.numFiles.get())) : BoxedUnit.UNIT;
        Option<FileSystem.WriteMode> option = this.writeMode;
        if (None$.MODULE$.equals(option)) {
            dataSink = csvRows.writeAsText(this.path);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            FileSystem.WriteMode wm = (FileSystem.WriteMode)some.value();
            dataSink = csvRows.writeAsText(this.path, wm);
        } else {
            throw new MatchError(option);
        }
        DataSink sink = dataSink;
        Object object2 = this.numFiles.isDefined() ? sink.setParallelism(BoxesRunTime.unboxToInt((Object)this.numFiles.get())) : BoxedUnit.UNIT;
        sink.name(TableConnectorUtil$.MODULE$.generateRuntimeName(this.getClass(), this.getFieldNames()));
    }

    @Override
    public void emitDataStream(DataStream<Row> dataStream) {
        DataStreamSink dataStreamSink;
        SingleOutputStreamOperator csvRows = dataStream.map((MapFunction)new CsvFormatter((String)this.fieldDelim.getOrElse((Function0 & Serializable & scala.Serializable)() -> ",")));
        Object object = this.numFiles.isDefined() ? csvRows.setParallelism(BoxesRunTime.unboxToInt((Object)this.numFiles.get())) : BoxedUnit.UNIT;
        Option<FileSystem.WriteMode> option = this.writeMode;
        if (None$.MODULE$.equals(option)) {
            dataStreamSink = csvRows.writeAsText(this.path);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            FileSystem.WriteMode wm = (FileSystem.WriteMode)some.value();
            dataStreamSink = csvRows.writeAsText(this.path, wm);
        } else {
            throw new MatchError(option);
        }
        DataStreamSink sink = dataStreamSink;
        Object object2 = this.numFiles.isDefined() ? sink.setParallelism(BoxesRunTime.unboxToInt((Object)this.numFiles.get())) : BoxedUnit.UNIT;
        sink.name(TableConnectorUtil$.MODULE$.generateRuntimeName(this.getClass(), this.getFieldNames()));
    }

    @Override
    public TableSinkBase<Row> copy() {
        return new CsvTableSink(this.path, this.fieldDelim, this.numFiles, this.writeMode);
    }

    @Override
    public TypeInformation<Row> getOutputType() {
        return new RowTypeInfo(this.getFieldTypes());
    }

    public CsvTableSink(String path, Option<String> fieldDelim, Option<Object> numFiles, Option<FileSystem.WriteMode> writeMode) {
        this.path = path;
        this.fieldDelim = fieldDelim;
        this.numFiles = numFiles;
        this.writeMode = writeMode;
        TableSinkBase.$init$(this);
    }

    public CsvTableSink(String path, String fieldDelim) {
        this(path, (Option<String>)new Some((Object)fieldDelim), (Option<Object>)None$.MODULE$, (Option<FileSystem.WriteMode>)None$.MODULE$);
    }

    public CsvTableSink(String path, String fieldDelim, int numFiles, FileSystem.WriteMode writeMode) {
        this(path, (Option<String>)new Some((Object)fieldDelim), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numFiles)), (Option<FileSystem.WriteMode>)new Some((Object)writeMode));
    }
}

