/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.triggers;

import org.apache.flink.api.common.functions.ReduceFunction;
import org.apache.flink.api.common.state.ReducingState;
import org.apache.flink.api.common.state.ReducingStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.streaming.api.windowing.triggers.Trigger;
import org.apache.flink.streaming.api.windowing.triggers.TriggerResult;
import org.apache.flink.streaming.api.windowing.windows.GlobalWindow;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.runtime.triggers.StateCleaningCountTrigger$;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u0001\u0003\u0001=\u0011\u0011d\u0015;bi\u0016\u001cE.Z1oS:<7i\\;oiR\u0013\u0018nZ4fe*\u00111\u0001B\u0001\tiJLwmZ3sg*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\tEI2$I\u0007\u0002%)\u00111a\u0005\u0006\u0003)U\t\u0011b^5oI><\u0018N\\4\u000b\u0005Y9\u0012aA1qS*\u0011\u0001\u0004C\u0001\ngR\u0014X-Y7j]\u001eL!A\u0007\n\u0003\u000fQ\u0013\u0018nZ4feB\u0011AdH\u0007\u0002;)\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\t\u0019\u0011I\\=\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011\u001a\u0012aB<j]\u0012|wo]\u0005\u0003M\r\u0012Ab\u00127pE\u0006dw+\u001b8e_^D\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!K\u0001\fcV,'/_\"p]\u001aLw\r\u0005\u0002+Y5\t1F\u0003\u0002\u0017\r%\u0011Qf\u000b\u0002\u0012'R\u0014X-Y7Rk\u0016\u0014\u0018pQ8oM&<\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002\u00115\f\u0007pQ8v]R\u0004\"\u0001H\u0019\n\u0005Ij\"\u0001\u0002'p]\u001eDQ\u0001\u000e\u0001\u0005\u0002U\na\u0001P5oSRtDc\u0001\u001c9sA\u0011q\u0007A\u0007\u0002\u0005!)\u0001f\ra\u0001S!)qf\ra\u0001a!91\b\u0001b\u0001\n#a\u0014\u0001E7j]J+G/\u001a8uS>tG+[7f+\u0005\u0001\u0004B\u0002 \u0001A\u0003%\u0001'A\tnS:\u0014V\r^3oi&|g\u000eV5nK\u0002Bq\u0001\u0011\u0001C\u0002\u0013EA(\u0001\tnCb\u0014V\r^3oi&|g\u000eV5nK\"1!\t\u0001Q\u0001\nA\n\u0011#\\1y%\u0016$XM\u001c;j_:$\u0016.\\3!\u0011\u001d!\u0005A1A\u0005\u0012\u0015\u000bAc\u001d;bi\u0016\u001cE.Z1oS:<WI\\1cY\u0016$W#\u0001$\u0011\u0005q9\u0015B\u0001%\u001e\u0005\u001d\u0011un\u001c7fC:DaA\u0013\u0001!\u0002\u00131\u0015!F:uCR,7\t\\3b]&tw-\u00128bE2,G\r\t\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003N\u0003%\u0019H/\u0019;f\t\u0016\u001c8-F\u0001O!\ryUkV\u0007\u0002!*\u0011\u0011KU\u0001\u0006gR\fG/\u001a\u0006\u0003'R\u000baaY8n[>t'B\u0001\f\t\u0013\t1\u0006KA\fSK\u0012,8-\u001b8h'R\fG/\u001a#fg\u000e\u0014\u0018\u000e\u001d;peB\u0011\u0001,X\u0007\u00023*\u0011!lW\u0001\u0005Y\u0006twMC\u0001]\u0003\u0011Q\u0017M^1\n\u0005IJ\u0006BB0\u0001A\u0003%a*\u0001\u0006ti\u0006$X\rR3tG\u0002Bq!\u0019\u0001C\u0002\u0013%!-\u0001\tdY\u0016\fg.\u001e9Ti\u0006$X\rR3tGV\t1\rE\u0002PI^K!!\u001a)\u0003)Y\u000bG.^3Ti\u0006$X\rR3tGJL\u0007\u000f^8s\u0011\u00199\u0007\u0001)A\u0005G\u0006\t2\r\\3b]V\u00048\u000b^1uK\u0012+7o\u0019\u0011\t\u000b%\u0004A\u0011\t6\u0002\u0011\r\fg.T3sO\u0016$\u0012A\u0012\u0005\u0006Y\u0002!\t%\\\u0001\ti>\u001cFO]5oOR\ta\u000e\u0005\u0002pm:\u0011\u0001\u000f\u001e\t\u0003cvi\u0011A\u001d\u0006\u0003g:\ta\u0001\u0010:p_Rt\u0014BA;\u001e\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000f\u001f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Ul\u0002\"\u0002>\u0001\t\u0003Z\u0018!C8o\u000b2,W.\u001a8u)!ax0a\u0001\u0002\b\u0005-\u0001CA\t~\u0013\tq(CA\u0007Ue&<w-\u001a:SKN,H\u000e\u001e\u0005\u0007\u0003\u0003I\b\u0019A\u000e\u0002\u000f\u0015dW-\\3oi\"1\u0011QA=A\u0002A\n\u0011\u0002^5nKN$\u0018-\u001c9\t\r\u0005%\u0011\u00101\u0001\"\u0003\u00199\u0018N\u001c3po\"9\u0011QB=A\u0002\u0005=\u0011aA2uqB!\u0011\u0011CA\u001a\u001d\u0011\t\u0019\"a\f\u000f\t\u0005U\u0011Q\u0006\b\u0005\u0003/\tYC\u0004\u0003\u0002\u001a\u0005%b\u0002BA\u000e\u0003OqA!!\b\u0002&9!\u0011qDA\u0012\u001d\r\t\u0018\u0011E\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!\u0001\u0007\u0005\n\u0005Y9\u0012B\u0001\u000b\u0016\u0013\t\u00191#C\u0002\u00022I\tq\u0001\u0016:jO\u001e,'/\u0003\u0003\u00026\u0005]\"A\u0004+sS\u001e<WM]\"p]R,\u0007\u0010\u001e\u0006\u0004\u0003c\u0011\u0002bBA\u001e\u0001\u0011\u0005\u0013QH\u0001\u0011_:\u0004&o\\2fgNLgn\u001a+j[\u0016$r\u0001`A \u0003\u0007\n)\u0005C\u0004\u0002B\u0005e\u0002\u0019\u0001\u0019\u0002\tQLW.\u001a\u0005\b\u0003\u0013\tI\u00041\u0001\"\u0011!\ti!!\u000fA\u0002\u0005=\u0001bBA%\u0001\u0011\u0005\u00131J\u0001\f_:,e/\u001a8u)&lW\rF\u0004}\u0003\u001b\ny%!\u0015\t\u000f\u0005\u0005\u0013q\ta\u0001a!9\u0011\u0011BA$\u0001\u0004\t\u0003\u0002CA\u0007\u0003\u000f\u0002\r!a\u0004\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X\u0005)1\r\\3beR1\u0011\u0011LA0\u0003C\u00022\u0001HA.\u0013\r\ti&\b\u0002\u0005+:LG\u000fC\u0004\u0002\n\u0005M\u0003\u0019A\u0011\t\u0011\u00055\u00111\u000ba\u0001\u0003\u001f9q!!\u001a\u0003\u0011\u0003\t9'A\rTi\u0006$Xm\u00117fC:LgnZ\"pk:$HK]5hO\u0016\u0014\bcA\u001c\u0002j\u00191\u0011A\u0001E\u0001\u0003W\u001ab!!\u001b\u0002n\u0005M\u0004c\u0001\u000f\u0002p%\u0019\u0011\u0011O\u000f\u0003\r\u0005s\u0017PU3g!\ra\u0012QO\u0005\u0004\u0003oj\"\u0001D*fe&\fG.\u001b>bE2,\u0007b\u0002\u001b\u0002j\u0011\u0005\u00111\u0010\u000b\u0003\u0003OB\u0001\"a \u0002j\u0011\u0005\u0011\u0011Q\u0001\u0003_\u001a$RANAB\u0003\u000bCa\u0001KA?\u0001\u0004I\u0003BB\u0018\u0002~\u0001\u0007\u0001GB\u0004\u0002\n\u0006%\u0004!a#\u0003\u0007M+Xn\u0005\u0004\u0002\b\u00065\u00151\u0013\t\u00041\u0006=\u0015bAAI3\n1qJ\u00196fGR\u0004R!!&\u0002\u001c^k!!a&\u000b\u0007\u0005e%+A\u0005gk:\u001cG/[8og&!\u0011QTAL\u00059\u0011V\rZ;dK\u001a+hn\u0019;j_:Dq\u0001NAD\t\u0003\t\t\u000b\u0006\u0002\u0002$B!\u0011QUAD\u001b\t\tI\u0007\u0003\u0005\u0002*\u0006\u001dE\u0011IAV\u0003\u0019\u0011X\rZ;dKR)q+!,\u00022\"9\u0011qVAT\u0001\u00049\u0016A\u0002<bYV,\u0017\u0007C\u0004\u00024\u0006\u001d\u0006\u0019A,\u0002\rY\fG.^33\u0011)\t9,!\u001b\u0002\u0002\u0013%\u0011\u0011X\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u000e\u0002")
public class StateCleaningCountTrigger
extends Trigger<Object, GlobalWindow> {
    private final StreamQueryConfig queryConfig;
    private final long maxCount;
    private final long minRetentionTime;
    private final long maxRetentionTime;
    private final boolean stateCleaningEnabled;
    private final ReducingStateDescriptor<Long> stateDesc;
    private final ValueStateDescriptor<Long> cleanupStateDesc;

    public static StateCleaningCountTrigger of(StreamQueryConfig streamQueryConfig, long l) {
        return StateCleaningCountTrigger$.MODULE$.of(streamQueryConfig, l);
    }

    public long minRetentionTime() {
        return this.minRetentionTime;
    }

    public long maxRetentionTime() {
        return this.maxRetentionTime;
    }

    public boolean stateCleaningEnabled() {
        return this.stateCleaningEnabled;
    }

    private ReducingStateDescriptor<Long> stateDesc() {
        return this.stateDesc;
    }

    private ValueStateDescriptor<Long> cleanupStateDesc() {
        return this.cleanupStateDesc;
    }

    public boolean canMerge() {
        return false;
    }

    public String toString() {
        return new StringBuilder(106).append("CountTriggerGlobalWindowithCleanupState(minIdleStateRetentionTime=").append(this.queryConfig.getMinIdleStateRetentionTime()).append(", ").append("maxIdleStateRetentionTime=").append(this.queryConfig.getMaxIdleStateRetentionTime()).append(", ").append("maxCount=").append(this.maxCount).append(")").toString();
    }

    public TriggerResult onElement(Object element, long timestamp, GlobalWindow window, Trigger.TriggerContext ctx) {
        TriggerResult triggerResult;
        Long curCleanupTime;
        long currentTime2 = ctx.getCurrentProcessingTime();
        if (this.stateCleaningEnabled() && ((curCleanupTime = (Long)((ValueState)ctx.getPartitionedState(this.cleanupStateDesc())).value()) == null || currentTime2 + this.minRetentionTime() > Predef$.MODULE$.Long2long(curCleanupTime))) {
            long cleanupTime = currentTime2 + this.maxRetentionTime();
            ctx.registerProcessingTimeTimer(cleanupTime);
            ((ValueState)ctx.getPartitionedState(this.cleanupStateDesc())).update((Object)Predef$.MODULE$.long2Long(cleanupTime));
        }
        ReducingState count = (ReducingState)ctx.getPartitionedState(this.stateDesc());
        count.add((Object)Predef$.MODULE$.long2Long(1L));
        if (Predef$.MODULE$.Long2long((Long)count.get()) >= this.maxCount) {
            count.clear();
            triggerResult = TriggerResult.FIRE;
        } else {
            triggerResult = TriggerResult.CONTINUE;
        }
        return triggerResult;
    }

    public TriggerResult onProcessingTime(long time, GlobalWindow window, Trigger.TriggerContext ctx) {
        Long cleanupTime;
        if (this.stateCleaningEnabled() && (cleanupTime = (Long)((ValueState)ctx.getPartitionedState(this.cleanupStateDesc())).value()) != null && BoxesRunTime.equals((Object)BoxesRunTime.boxToLong((long)time), (Object)cleanupTime)) {
            this.clear(window, ctx);
            return TriggerResult.FIRE_AND_PURGE;
        }
        return TriggerResult.CONTINUE;
    }

    public TriggerResult onEventTime(long time, GlobalWindow window, Trigger.TriggerContext ctx) {
        return TriggerResult.CONTINUE;
    }

    public void clear(GlobalWindow window, Trigger.TriggerContext ctx) {
        ctx.getPartitionedState(this.stateDesc()).clear();
        ctx.getPartitionedState(this.cleanupStateDesc()).clear();
    }

    public StateCleaningCountTrigger(StreamQueryConfig queryConfig, long maxCount) {
        this.queryConfig = queryConfig;
        this.maxCount = maxCount;
        this.minRetentionTime = queryConfig.getMinIdleStateRetentionTime();
        this.maxRetentionTime = queryConfig.getMaxIdleStateRetentionTime();
        this.stateCleaningEnabled = this.minRetentionTime() > 1L;
        this.stateDesc = new ReducingStateDescriptor("count", (ReduceFunction)new Sum(), Types$.MODULE$.LONG());
        this.cleanupStateDesc = new ValueStateDescriptor("countCleanup", Types$.MODULE$.LONG());
    }

    public static class Sum
    implements ReduceFunction<Long> {
        public Long reduce(Long value1, Long value2) {
            return Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(value1) + Predef$.MODULE$.Long2long(value2));
        }
    }
}

