/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.co.CoProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.runtime.join.CRowWrappingMultiOutputCollector;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.typeutils.TypeCheckUtils$;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0005d!B\u0001\u0003\u0003\u0003y!!\u0004(p]^Kg\u000eZ8x\u0015>LgN\u0003\u0002\u0004\t\u0005!!n\\5o\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\u00126!\u0015\t\"\u0004\b\u000f\u001d\u001b\u0005\u0011\"BA\n\u0015\u0003\t\u0019wN\u0003\u0002\u0016-\u0005Ia-\u001e8di&|gn\u001d\u0006\u0003/a\t1!\u00199j\u0015\tI\u0002\"A\u0005tiJ,\u0017-\\5oO&\u00111D\u0005\u0002\u0012\u0007>\u0004&o\\2fgN4UO\\2uS>t\u0007CA\u000f!\u001b\u0005q\"BA\u0010\u0005\u0003\u0015!\u0018\u0010]3t\u0013\t\tcD\u0001\u0003D%><\bcA\u0012'Q5\tAE\u0003\u0002&\r\u000591m\u001c3fO\u0016t\u0017BA\u0014%\u0005!\u0019u.\u001c9jY\u0016\u0014\b#B\u0015/aA\u0002T\"\u0001\u0016\u000b\u0005UY#B\u0001\u0017.\u0003\u0019\u0019w.\\7p]*\u0011q\u0003C\u0005\u0003_)\u0012\u0001C\u00127bi*{\u0017N\u001c$v]\u000e$\u0018n\u001c8\u0011\u0005E\u001aT\"\u0001\u001a\u000b\u0005}A\u0011B\u0001\u001b3\u0005\r\u0011vn\u001e\t\u0003mej\u0011a\u000e\u0006\u0003q\u0019\tA!\u001e;jY&\u0011!h\u000e\u0002\b\u0019><w-\u001b8h\u0011!a\u0004A!A!\u0002\u0013i\u0014\u0001\u00037fMR$\u0016\u0010]3\u0011\u0007y\n\u0005'D\u0001@\u0015\t\u00015&\u0001\u0005usB,\u0017N\u001c4p\u0013\t\u0011uHA\bUsB,\u0017J\u001c4pe6\fG/[8o\u0011!!\u0005A!A!\u0002\u0013i\u0014!\u0003:jO\"$H+\u001f9f\u0011!1\u0005A!A!\u0002\u00139\u0015aD4f]*{\u0017N\u001c$v]\u000et\u0015-\\3\u0011\u0005!\u000bfBA%P!\tQU*D\u0001L\u0015\tae\"\u0001\u0004=e>|GO\u0010\u0006\u0002\u001d\u0006)1oY1mC&\u0011\u0001+T\u0001\u0007!J,G-\u001a4\n\u0005I\u001b&AB*ue&twM\u0003\u0002Q\u001b\"AQ\u000b\u0001B\u0001B\u0003%q)A\bhK:Tu.\u001b8Gk:\u001c7i\u001c3f\u0011!9\u0006A!A!\u0002\u0013A\u0016aC9vKJL8i\u001c8gS\u001e\u0004\"!W.\u000e\u0003iS!a\u0006\u0004\n\u0005qS&!E*ue\u0016\fW.U;fef\u001cuN\u001c4jO\")a\f\u0001C\u0001?\u00061A(\u001b8jiz\"b\u0001\u00192dI\u00164\u0007CA1\u0001\u001b\u0005\u0011\u0001\"\u0002\u001f^\u0001\u0004i\u0004\"\u0002#^\u0001\u0004i\u0004\"\u0002$^\u0001\u00049\u0005\"B+^\u0001\u00049\u0005\"B,^\u0001\u0004A\u0006\"\u00035\u0001\u0001\u0004\u0005\r\u0011\"\u0005j\u0003%aWM\u001a;Ti\u0006$X-F\u0001k!\u0011Yg\u000e\r9\u000e\u00031T!!\\\u0016\u0002\u000bM$\u0018\r^3\n\u0005=d'\u0001C'baN#\u0018\r^3\u0011\tE4\b\u0010_\u0007\u0002e*\u00111\u000f^\u0001\u0006iV\u0004H.\u001a\u0006\u0003k6\nAA[1wC&\u0011qO\u001d\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005eTX\"A'\n\u0005ml%\u0001\u0002'p]\u001eD\u0011\" \u0001A\u0002\u0003\u0007I\u0011\u0003@\u0002\u001b1,g\r^*uCR,w\fJ3r)\ry\u0018Q\u0001\t\u0004s\u0006\u0005\u0011bAA\u0002\u001b\n!QK\\5u\u0011!\t9\u0001`A\u0001\u0002\u0004Q\u0017a\u0001=%c!Q\u00111\u0002\u0001A\u0002\u0003\u0005\u000b\u0015\u00026\u0002\u00151,g\r^*uCR,\u0007\u0005\u0003\u0006\u0002\u0010\u0001\u0001\r\u00111A\u0005\u0012%\f!B]5hQR\u001cF/\u0019;f\u0011-\t\u0019\u0002\u0001a\u0001\u0002\u0004%\t\"!\u0006\u0002\u001dILw\r\u001b;Ti\u0006$Xm\u0018\u0013fcR\u0019q0a\u0006\t\u0013\u0005\u001d\u0011\u0011CA\u0001\u0002\u0004Q\u0007BCA\u000e\u0001\u0001\u0007\t\u0011)Q\u0005U\u0006Y!/[4iiN#\u0018\r^3!\u0011-\ty\u0002\u0001a\u0001\u0002\u0004%\t\"!\t\u0002\u0017\r\u0014vn^,sCB\u0004XM]\u000b\u0003\u0003G\u00012!YA\u0013\u0013\r\t9C\u0001\u0002!\u0007J{wo\u0016:baBLgnZ'vYRLw*\u001e;qkR\u001cu\u000e\u001c7fGR|'\u000fC\u0006\u0002,\u0001\u0001\r\u00111A\u0005\u0012\u00055\u0012aD2S_^<&/\u00199qKJ|F%Z9\u0015\u0007}\fy\u0003\u0003\u0006\u0002\b\u0005%\u0012\u0011!a\u0001\u0003GA1\"a\r\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002$\u0005a1MU8x/J\f\u0007\u000f]3sA!I\u0011q\u0007\u0001C\u0002\u0013E\u0011\u0011H\u0001\u0011[&t'+\u001a;f]RLwN\u001c+j[\u0016,\u0012\u0001\u001f\u0005\b\u0003{\u0001\u0001\u0015!\u0003y\u0003Ei\u0017N\u001c*fi\u0016tG/[8o)&lW\r\t\u0005\n\u0003\u0003\u0002!\u0019!C\t\u0003s\t\u0001#\\1y%\u0016$XM\u001c;j_:$\u0016.\\3\t\u000f\u0005\u0015\u0003\u0001)A\u0005q\u0006\tR.\u0019=SKR,g\u000e^5p]RKW.\u001a\u0011\t\u0013\u0005%\u0003A1A\u0005\u0012\u0005-\u0013\u0001F:uCR,7\t\\3b]&tw-\u00128bE2,G-\u0006\u0002\u0002NA\u0019\u00110a\u0014\n\u0007\u0005ESJA\u0004C_>dW-\u00198\t\u0011\u0005U\u0003\u0001)A\u0005\u0003\u001b\nQc\u001d;bi\u0016\u001cE.Z1oS:<WI\\1cY\u0016$\u0007\u0005C\u0006\u0002Z\u0001\u0001\r\u00111A\u0005\u0012\u0005m\u0013!\u00037fMR$\u0016.\\3s+\t\ti\u0006\u0005\u0003l\u0003?B\u0018bAA1Y\nQa+\u00197vKN#\u0018\r^3\t\u0017\u0005\u0015\u0004\u00011AA\u0002\u0013E\u0011qM\u0001\u000eY\u00164G\u000fV5nKJ|F%Z9\u0015\u0007}\fI\u0007\u0003\u0006\u0002\b\u0005\r\u0014\u0011!a\u0001\u0003;B1\"!\u001c\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002^\u0005QA.\u001a4u)&lWM\u001d\u0011\t\u0017\u0005E\u0004\u00011AA\u0002\u0013E\u00111L\u0001\u000be&<\u0007\u000e\u001e+j[\u0016\u0014\bbCA;\u0001\u0001\u0007\t\u0019!C\t\u0003o\naB]5hQR$\u0016.\\3s?\u0012*\u0017\u000fF\u0002\u0000\u0003sB!\"a\u0002\u0002t\u0005\u0005\t\u0019AA/\u0011-\ti\b\u0001a\u0001\u0002\u0003\u0006K!!\u0018\u0002\u0017ILw\r\u001b;US6,'\u000f\t\u0005\f\u0003\u0003\u0003\u0001\u0019!a\u0001\n#\t\u0019)\u0001\u0007k_&tg)\u001e8di&|g.F\u0001)\u0011-\t9\t\u0001a\u0001\u0002\u0004%\t\"!#\u0002!)|\u0017N\u001c$v]\u000e$\u0018n\u001c8`I\u0015\fHcA@\u0002\f\"I\u0011qAAC\u0003\u0003\u0005\r\u0001\u000b\u0005\u000b\u0003\u001f\u0003\u0001\u0019!A!B\u0013A\u0013!\u00046pS:4UO\\2uS>t\u0007\u0005C\u0006\u0002\u0014\u0002\u0001\r\u00111A\u0005\u0012\u0005e\u0012AD2veB\u0013xnY3tgRKW.\u001a\u0005\f\u0003/\u0003\u0001\u0019!a\u0001\n#\tI*\u0001\ndkJ\u0004&o\\2fgN$\u0016.\\3`I\u0015\fHcA@\u0002\u001c\"I\u0011qAAK\u0003\u0003\u0005\r\u0001\u001f\u0005\u000b\u0003?\u0003\u0001\u0019!A!B\u0013A\u0018aD2veB\u0013xnY3tgRKW.\u001a\u0011\t\u000f\u0005\r\u0006\u0001\"\u0011\u0002&\u0006!q\u000e]3o)\ry\u0018q\u0015\u0005\t\u0003S\u000b\t\u000b1\u0001\u0002,\u0006Q\u0001/\u0019:b[\u0016$XM]:\u0011\t\u00055\u00161W\u0007\u0003\u0003_S1!!-\t\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&!\u0011QWAX\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9\u0011\u0011\u0018\u0001\u0005B\u0005m\u0016a\u00049s_\u000e,7o]#mK6,g\u000e^\u0019\u0015\u000f}\fi,!1\u0002L\"9\u0011qXA\\\u0001\u0004a\u0012A\u0002<bYV,7\t\u0003\u0005\u0002D\u0006]\u0006\u0019AAc\u0003\r\u0019G\u000f\u001f\t\u0004!\u0005\u001d\u0017bAAe5\t91i\u001c8uKb$\b\u0002CAg\u0003o\u0003\r!a4\u0002\u0007=,H\u000fE\u0003\u0002R\u0006UG$\u0004\u0002\u0002T*\u0011\u0001\bC\u0005\u0005\u0003/\f\u0019NA\u0005D_2dWm\u0019;pe\"9\u00111\u001c\u0001\u0005B\u0005u\u0017a\u00049s_\u000e,7o]#mK6,g\u000e\u001e\u001a\u0015\u000f}\fy.!9\u0002d\"9\u0011qXAm\u0001\u0004a\u0002\u0002CAb\u00033\u0004\r!!2\t\u0011\u00055\u0017\u0011\u001ca\u0001\u0003\u001fDq!a:\u0001\t\u0003\nI/A\u0004p]RKW.\u001a:\u0015\u000f}\fY/a<\u0002x\"9\u0011Q^As\u0001\u0004A\u0018!\u0003;j[\u0016\u001cH/Y7q\u0011!\t\u0019-!:A\u0002\u0005E\bc\u0001\t\u0002t&\u0019\u0011Q\u001f\u000e\u0003\u001d=sG+[7fe\u000e{g\u000e^3yi\"A\u0011QZAs\u0001\u0004\ty\rC\u0004\u0002|\u0002!\t!!@\u0002#\u001d,GOT3x\u000bb\u0004\u0018N]3e)&lW\rF\u0003y\u0003\u007f\u0014\t\u0001C\u0004\u0002\u0014\u0006e\b\u0019\u0001=\t\u000f\t\r\u0011\u0011 a\u0001q\u0006qq\u000e\u001c3FqBL'/\u001a3US6,\u0007b\u0002B\u0004\u0001\u0011\u0005!\u0011B\u0001\u0011Kb\u0004\u0018N]3PkR$\u0016.\\3S_^$2b B\u0006\u0005\u001f\u0011\u0019Ba\u0006\u0003\u001c!9!Q\u0002B\u0003\u0001\u0004A\u0018aB2veRKW.\u001a\u0005\b\u0005#\u0011)\u00011\u0001k\u0003-\u0011xn^'baN#\u0018\r^3\t\u0011\tU!Q\u0001a\u0001\u0003;\n!\u0002^5nKJ\u001cF/\u0019;f\u0011!\u0011IB!\u0002A\u0002\u00055\u0013AB5t\u0019\u00164G\u000f\u0003\u0005\u0002D\n\u0015\u0001\u0019AAy\u0011\u001d\u0011y\u0002\u0001D\u0001\u0005C\ta\u0002\u001d:pG\u0016\u001c8/\u00127f[\u0016tG\u000fF\b\u0000\u0005G\u00119C!\u000b\u0003,\t5\"\u0011\u0007B\u001b\u0011\u001d\u0011)C!\bA\u0002q\tQA^1mk\u0016D\u0001\"a1\u0003\u001e\u0001\u0007\u0011Q\u0019\u0005\t\u0003\u001b\u0014i\u00021\u0001\u0002P\"A!Q\u0003B\u000f\u0001\u0004\ti\u0006C\u0004\u00030\tu\u0001\u0019\u00016\u0002!\r,(O]3oiNKG-Z*uCR,\u0007b\u0002B\u001a\u0005;\u0001\rA[\u0001\u000f_RDWM]*jI\u0016\u001cF/\u0019;f\u0011!\u0011IB!\bA\u0002\u00055\u0003b\u0002B\u001d\u0001\u0011\u0005!1H\u0001\u0012kB$\u0017\r^3DkJ\u0014XM\u001c;TS\u0012,G#\u00039\u0003>\t}\"\u0011\tB\"\u0011\u001d\u0011)Ca\u000eA\u0002qA\u0001\"a1\u00038\u0001\u0007\u0011Q\u0019\u0005\t\u0005+\u00119\u00041\u0001\u0002^!9!q\u0006B\u001c\u0001\u0004Q\u0007b\u0002B$\u0001\u0011\u0005!\u0011J\u0001\u0011G\u0006dGNS8j]\u001a+hn\u0019;j_:$\u0012b B&\u0005\u001f\u0012\u0019Fa\u0016\t\u000f\t5#Q\ta\u0001a\u0005A\u0011N\u001c9viJ{w\u000f\u0003\u0005\u0003R\t\u0015\u0003\u0019AA'\u0003AIg\u000e];u%><hI]8n\u0019\u00164G\u000fC\u0004\u0003V\t\u0015\u0003\u0019\u0001\u0019\u0002\u0019=$\b.\u001a:TS\u0012,'k\\<\t\u0011\u0005}!Q\ta\u0001\u00053\u0002R!!5\u0002VBBqA!\u0018\u0001\t\u0003\u0012y&A\u0003dY>\u001cX\rF\u0001\u0000\u0001")
public abstract class NonWindowJoin
extends CoProcessFunction<CRow, CRow, CRow>
implements Compiler<FlatJoinFunction<Row, Row, Row>>,
Logging {
    private final TypeInformation<Row> leftType;
    private final TypeInformation<Row> rightType;
    private final String genJoinFuncName;
    private final String genJoinFuncCode;
    private MapState<Row, Tuple2<Object, Object>> leftState;
    private MapState<Row, Tuple2<Object, Object>> rightState;
    private CRowWrappingMultiOutputCollector cRowWrapper;
    private final long minRetentionTime;
    private final long maxRetentionTime;
    private final boolean stateCleaningEnabled;
    private ValueState<Object> leftTimer;
    private ValueState<Object> rightTimer;
    private FlatJoinFunction<Row, Row, Row> joinFunction;
    private long curProcessTime;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<FlatJoinFunction<Row, Row, Row>> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        NonWindowJoin nonWindowJoin = this;
        synchronized (nonWindowJoin) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    public MapState<Row, Tuple2<Object, Object>> leftState() {
        return this.leftState;
    }

    public void leftState_$eq(MapState<Row, Tuple2<Object, Object>> x$1) {
        this.leftState = x$1;
    }

    public MapState<Row, Tuple2<Object, Object>> rightState() {
        return this.rightState;
    }

    public void rightState_$eq(MapState<Row, Tuple2<Object, Object>> x$1) {
        this.rightState = x$1;
    }

    public CRowWrappingMultiOutputCollector cRowWrapper() {
        return this.cRowWrapper;
    }

    public void cRowWrapper_$eq(CRowWrappingMultiOutputCollector x$1) {
        this.cRowWrapper = x$1;
    }

    public long minRetentionTime() {
        return this.minRetentionTime;
    }

    public long maxRetentionTime() {
        return this.maxRetentionTime;
    }

    public boolean stateCleaningEnabled() {
        return this.stateCleaningEnabled;
    }

    public ValueState<Object> leftTimer() {
        return this.leftTimer;
    }

    public void leftTimer_$eq(ValueState<Object> x$1) {
        this.leftTimer = x$1;
    }

    public ValueState<Object> rightTimer() {
        return this.rightTimer;
    }

    public void rightTimer_$eq(ValueState<Object> x$1) {
        this.rightTimer = x$1;
    }

    public FlatJoinFunction<Row, Row, Row> joinFunction() {
        return this.joinFunction;
    }

    public void joinFunction_$eq(FlatJoinFunction<Row, Row, Row> x$1) {
        this.joinFunction = x$1;
    }

    public long curProcessTime() {
        return this.curProcessTime;
    }

    public void curProcessTime_$eq(long x$1) {
        this.curProcessTime = x$1;
    }

    public void open(Configuration parameters) {
        this.LOG().debug(new StringBuilder(34).append("Compiling JoinFunction: ").append(this.genJoinFuncName).append(" \n\n Code:\n").append(this.genJoinFuncCode).toString());
        Class<FlatJoinFunction<Row, Row, Row>> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genJoinFuncName, this.genJoinFuncCode);
        this.LOG().debug("Instantiating JoinFunction.");
        this.joinFunction_$eq(clazz.newInstance());
        FunctionUtils.setFunctionRuntimeContext(this.joinFunction(), (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.joinFunction(), (Configuration)parameters);
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(new TypeInformation[]{Types$.MODULE$.LONG(), Types$.MODULE$.LONG()});
        MapStateDescriptor leftStateDescriptor = new MapStateDescriptor("left", this.leftType, (TypeInformation)tupleTypeInfo);
        MapStateDescriptor rightStateDescriptor = new MapStateDescriptor("right", this.rightType, (TypeInformation)tupleTypeInfo);
        this.leftState_$eq((MapState<Row, Tuple2<Object, Object>>)this.getRuntimeContext().getMapState(leftStateDescriptor));
        this.rightState_$eq((MapState<Row, Tuple2<Object, Object>>)this.getRuntimeContext().getMapState(rightStateDescriptor));
        ValueStateDescriptor valueStateDescriptor1 = new ValueStateDescriptor("timervaluestate1", Long.TYPE);
        this.leftTimer_$eq((ValueState<Object>)this.getRuntimeContext().getState(valueStateDescriptor1));
        ValueStateDescriptor valueStateDescriptor2 = new ValueStateDescriptor("timervaluestate2", Long.TYPE);
        this.rightTimer_$eq((ValueState<Object>)this.getRuntimeContext().getState(valueStateDescriptor2));
        this.cRowWrapper_$eq(new CRowWrappingMultiOutputCollector());
        this.LOG().debug("Instantiating NonWindowJoin.");
    }

    public void processElement1(CRow valueC, CoProcessFunction.Context ctx, Collector<CRow> out) {
        this.processElement(valueC, ctx, out, this.leftTimer(), this.leftState(), this.rightState(), true);
    }

    public void processElement2(CRow valueC, CoProcessFunction.Context ctx, Collector<CRow> out) {
        this.processElement(valueC, ctx, out, this.rightTimer(), this.rightState(), this.leftState(), false);
    }

    public void onTimer(long timestamp, CoProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        block1: {
            if (this.stateCleaningEnabled() && BoxesRunTime.unboxToLong((Object)this.leftTimer().value()) == timestamp) {
                this.expireOutTimeRow(timestamp, this.leftState(), this.leftTimer(), true, ctx);
            }
            if (!this.stateCleaningEnabled() || BoxesRunTime.unboxToLong((Object)this.rightTimer().value()) != timestamp) break block1;
            this.expireOutTimeRow(timestamp, this.rightState(), this.rightTimer(), false, ctx);
        }
    }

    public long getNewExpiredTime(long curProcessTime, long oldExpiredTime) {
        return this.stateCleaningEnabled() && curProcessTime + this.minRetentionTime() > oldExpiredTime ? curProcessTime + this.maxRetentionTime() : oldExpiredTime;
    }

    public void expireOutTimeRow(long curTime, MapState<Row, Tuple2<Object, Object>> rowMapState, ValueState<Object> timerState, boolean isLeft, CoProcessFunction.OnTimerContext ctx) {
        Iterator rowMapIter = rowMapState.iterator();
        boolean validTimestamp = false;
        while (rowMapIter.hasNext()) {
            Map.Entry mapEntry = (Map.Entry)rowMapIter.next();
            long recordExpiredTime = BoxesRunTime.unboxToLong((Object)((Tuple2)mapEntry.getValue()).f1);
            if (recordExpiredTime <= curTime) {
                rowMapIter.remove();
                continue;
            }
            validTimestamp = true;
        }
        if (validTimestamp) {
            long cleanupTime = curTime + this.maxRetentionTime();
            ctx.timerService().registerProcessingTimeTimer(cleanupTime);
            timerState.update((Object)BoxesRunTime.boxToLong((long)cleanupTime));
        } else {
            timerState.clear();
            rowMapState.clear();
        }
    }

    public abstract void processElement(CRow var1, CoProcessFunction.Context var2, Collector<CRow> var3, ValueState<Object> var4, MapState<Row, Tuple2<Object, Object>> var5, MapState<Row, Tuple2<Object, Object>> var6, boolean var7);

    public Tuple2<Object, Object> updateCurrentSide(CRow value, CoProcessFunction.Context ctx, ValueState<Object> timerState, MapState<Row, Tuple2<Object, Object>> currentSideState) {
        Row inputRow = value.row();
        this.curProcessTime_$eq(ctx.timerService().currentProcessingTime());
        Tuple2 oldCntAndExpiredTime = (Tuple2)currentSideState.get((Object)inputRow);
        Tuple2 cntAndExpiredTime = oldCntAndExpiredTime == null ? Tuple2.of((Object)BoxesRunTime.boxToLong((long)0L), (Object)BoxesRunTime.boxToLong((long)-1L)) : oldCntAndExpiredTime;
        cntAndExpiredTime.f1 = BoxesRunTime.boxToLong((long)this.getNewExpiredTime(this.curProcessTime(), BoxesRunTime.unboxToLong((Object)cntAndExpiredTime.f1)));
        if (this.stateCleaningEnabled() && BoxesRunTime.unboxToLong((Object)timerState.value()) == 0L) {
            timerState.update(cntAndExpiredTime.f1);
            ctx.timerService().registerProcessingTimeTimer(BoxesRunTime.unboxToLong((Object)cntAndExpiredTime.f1));
        }
        if (!value.change()) {
            cntAndExpiredTime.f0 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)cntAndExpiredTime.f0) - 1L));
            if (BoxesRunTime.unboxToLong((Object)cntAndExpiredTime.f0) <= 0L) {
                currentSideState.remove((Object)inputRow);
            } else {
                currentSideState.put((Object)inputRow, (Object)cntAndExpiredTime);
            }
        } else {
            cntAndExpiredTime.f0 = BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)cntAndExpiredTime.f0) + 1L));
            currentSideState.put((Object)inputRow, (Object)cntAndExpiredTime);
        }
        return cntAndExpiredTime;
    }

    public void callJoinFunction(Row inputRow, boolean inputRowFromLeft, Row otherSideRow, Collector<Row> cRowWrapper) {
        if (inputRowFromLeft) {
            this.joinFunction().join((Object)inputRow, (Object)otherSideRow, cRowWrapper);
        } else {
            this.joinFunction().join((Object)otherSideRow, (Object)inputRow, cRowWrapper);
        }
    }

    public void close() {
        FunctionUtils.closeFunction(this.joinFunction());
    }

    public NonWindowJoin(TypeInformation<Row> leftType, TypeInformation<Row> rightType, String genJoinFuncName, String genJoinFuncCode, StreamQueryConfig queryConfig) {
        this.leftType = leftType;
        this.rightType = rightType;
        this.genJoinFuncName = genJoinFuncName;
        this.genJoinFuncCode = genJoinFuncCode;
        Compiler.$init$(this);
        Logging.$init$(this);
        TypeCheckUtils$.MODULE$.validateEqualsHashCode("join", leftType);
        TypeCheckUtils$.MODULE$.validateEqualsHashCode("join", rightType);
        this.minRetentionTime = queryConfig.getMinIdleStateRetentionTime();
        this.maxRetentionTime = queryConfig.getMaxIdleStateRetentionTime();
        this.stateCleaningEnabled = this.minRetentionTime() > 1L;
    }
}

