/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g!B\u0001\u0003\u0003\u0003y!\u0001\u0006*poRKW.Z+oE>,h\u000eZ3e\u001fZ,'O\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001\u0001\"d\t\t\u0005#I!B#D\u0001\u0003\u0013\t\u0019\"AA\u0010Qe>\u001cWm]:Gk:\u001cG/[8o/&$\bn\u00117fC:,\bo\u0015;bi\u0016\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u000bQL\b/Z:\n\u0005e1\"\u0001B\"S_^\u00042a\u0007\u0010!\u001b\u0005a\"BA\u000f\u0007\u0003\u001d\u0019w\u000eZ3hK:L!a\b\u000f\u0003\u0011\r{W\u000e]5mKJ\u0004\"!E\u0011\n\u0005\t\u0012!!F$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003I\u001dj\u0011!\n\u0006\u0003M\u0019\tA!\u001e;jY&\u0011\u0001&\n\u0002\b\u0019><w-\u001b8h\u0011!Q\u0003A!A!\u0002\u0013Y\u0013aD4f]\u0006;wM]3hCRLwN\\:\u0011\u0005ma\u0013BA\u0017\u001d\u0005u9UM\\3sCR,G-Q4he\u0016<\u0017\r^5p]N4UO\\2uS>t\u0007\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002!%tG/\u001a:nK\u0012L\u0017\r^3UsB,\u0007cA\u00199u5\t!G\u0003\u00024i\u0005AA/\u001f9fS:4wN\u0003\u00026m\u000511m\\7n_:T!a\u000e\u0005\u0002\u0007\u0005\u0004\u0018.\u0003\u0002:e\tyA+\u001f9f\u0013:4wN]7bi&|g\u000e\u0005\u0002<{5\tAH\u0003\u0002\u0018\u0011%\u0011a\b\u0010\u0002\u0004%><\b\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\u0002\u0013%t\u0007/\u001e;UsB,\u0007cA\u00199)!A1\t\u0001B\u0001B\u0003%A)\u0001\u0006s_^$\u0016.\\3JIb\u0004\"!\u0012%\u000e\u0003\u0019S\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\u001a\u00131!\u00138u\u0011!Y\u0005A!A!\u0002\u0013a\u0015aC9vKJL8i\u001c8gS\u001e\u0004\"!T(\u000e\u00039S!a\u000e\u0004\n\u0005As%!E*ue\u0016\fW.U;fef\u001cuN\u001c4jO\")!\u000b\u0001C\u0001'\u00061A(\u001b8jiz\"b\u0001V+W/bK\u0006CA\t\u0001\u0011\u0015Q\u0013\u000b1\u0001,\u0011\u0015y\u0013\u000b1\u00011\u0011\u0015\u0001\u0015\u000b1\u0001B\u0011\u0015\u0019\u0015\u000b1\u0001E\u0011\u0015Y\u0015\u000b1\u0001M\u0011%Y\u0006\u00011AA\u0002\u0013EA,\u0001\u0004pkR\u0004X\u000f^\u000b\u0002)!Ia\f\u0001a\u0001\u0002\u0004%\tbX\u0001\u000b_V$\b/\u001e;`I\u0015\fHC\u00011d!\t)\u0015-\u0003\u0002c\r\n!QK\\5u\u0011\u001d!W,!AA\u0002Q\t1\u0001\u001f\u00132\u0011%1\u0007\u00011A\u0001B\u0003&A#A\u0004pkR\u0004X\u000f\u001e\u0011\t\u0013!\u0004\u0001\u0019!a\u0001\n\u0013I\u0017\u0001E1dGVlW\u000f\\1u_J\u001cF/\u0019;f+\u0005Q\u0007cA6ou5\tAN\u0003\u0002ni\u0005)1\u000f^1uK&\u0011q\u000e\u001c\u0002\u000b-\u0006dW/Z*uCR,\u0007\"C9\u0001\u0001\u0004\u0005\r\u0011\"\u0003s\u0003Q\t7mY;nk2\fGo\u001c:Ti\u0006$Xm\u0018\u0013fcR\u0011\u0001m\u001d\u0005\bIB\f\t\u00111\u0001k\u0011%)\b\u00011A\u0001B\u0003&!.A\tbG\u000e,X.\u001e7bi>\u00148\u000b^1uK\u0002B\u0011b\u001e\u0001A\u0002\u0003\u0007I\u0011\u0002=\u0002\u0017I|w/T1q'R\fG/Z\u000b\u0002sB!1N\u001f?\u0000\u0013\tYHN\u0001\u0005NCB\u001cF/\u0019;f!\t)U0\u0003\u0002\u007f\r\n!Aj\u001c8h!\u0015\t\t!!\u0003;\u001b\t\t\u0019AC\u0002'\u0003\u000bQ!!a\u0002\u0002\t)\fg/Y\u0005\u0005\u0003\u0017\t\u0019A\u0001\u0003MSN$\bbCA\b\u0001\u0001\u0007\t\u0019!C\u0005\u0003#\tqB]8x\u001b\u0006\u00048\u000b^1uK~#S-\u001d\u000b\u0004A\u0006M\u0001\u0002\u00033\u0002\u000e\u0005\u0005\t\u0019A=\t\u0015\u0005]\u0001\u00011A\u0001B\u0003&\u00110\u0001\u0007s_^l\u0015\r]*uCR,\u0007\u0005C\u0006\u0002\u001c\u0001\u0001\r\u00111A\u0005\n\u0005u\u0011\u0001E:peR,G\rV5nKN$\u0018-\u001c9t+\t\ty\u0002E\u0003\u0002\u0002\u0005\u0005B0\u0003\u0003\u0002$\u0005\r!A\u0003'j].,G\rT5ti\"Y\u0011q\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0015\u0003Q\u0019xN\u001d;fIRKW.Z:uC6\u00048o\u0018\u0013fcR\u0019\u0001-a\u000b\t\u0013\u0011\f)#!AA\u0002\u0005}\u0001bCA\u0018\u0001\u0001\u0007\t\u0011)Q\u0005\u0003?\t\u0011c]8si\u0016$G+[7fgR\fW\u000e]:!\u0011-\t\u0019\u0004\u0001a\u0001\u0002\u0004%\t\"!\u000e\u0002\u0011\u0019,hn\u0019;j_:,\u0012\u0001\t\u0005\f\u0003s\u0001\u0001\u0019!a\u0001\n#\tY$\u0001\u0007gk:\u001cG/[8o?\u0012*\u0017\u000fF\u0002a\u0003{A\u0001\u0002ZA\u001c\u0003\u0003\u0005\r\u0001\t\u0005\u000b\u0003\u0003\u0002\u0001\u0019!A!B\u0013\u0001\u0013!\u00034v]\u000e$\u0018n\u001c8!\u0011\u001d\t)\u0005\u0001C!\u0003\u000f\nAa\u001c9f]R\u0019\u0001-!\u0013\t\u0011\u0005-\u00131\ta\u0001\u0003\u001b\naaY8oM&<\u0007\u0003BA(\u0003+j!!!\u0015\u000b\u0007\u0005M\u0003\"A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003/\n\tFA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u00037\u0002A\u0011IA/\u00039\u0001(o\\2fgN,E.Z7f]R$r\u0001YA0\u0003G\ny\bC\u0004\u0002b\u0005e\u0003\u0019\u0001\u000b\u0002\r%t\u0007/\u001e;D\u0011!\t)'!\u0017A\u0002\u0005\u001d\u0014aA2uqB!\u0011\u0011NA>!\u0019\tY'a\u001e\u0015)5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(A\u0005gk:\u001cG/[8og*\u0019q'a\u001d\u000b\u0007\u0005U\u0004\"A\u0005tiJ,\u0017-\\5oO&!\u0011\u0011PA7\u0005=\u0001&o\\2fgN4UO\\2uS>t\u0017\u0002BA?\u0003o\u0012qaQ8oi\u0016DH\u000f\u0003\u0005\u0002\u0002\u0006e\u0003\u0019AAB\u0003\ryW\u000f\u001e\t\u0006\u0003\u000b\u000bI\tF\u0007\u0003\u0003\u000fS!A\n\u0005\n\t\u0005-\u0015q\u0011\u0002\n\u0007>dG.Z2u_JDq!a$\u0001\t\u0003\n\t*A\u0004p]RKW.\u001a:\u0015\u000f\u0001\f\u0019*a&\u0002 \"9\u0011QSAG\u0001\u0004a\u0018!\u0003;j[\u0016\u001cH/Y7q\u0011!\t)'!$A\u0002\u0005e\u0005\u0003BA5\u00037KA!!(\u0002x\tqqJ\u001c+j[\u0016\u00148i\u001c8uKb$\b\u0002CAA\u0003\u001b\u0003\r!a!\t\u000f\u0005\r\u0006\u0001\"\u0003\u0002&\u0006\u0011\u0012N\\:feR$vnU8si\u0016$G*[:u)\r\u0001\u0017q\u0015\u0005\b\u0003S\u000b\t\u000b1\u0001}\u0003=\u0011XmY8sIRKW.Z:uC6\u0004\bbBAW\u0001\u0019\u0005\u0011qV\u0001!aJ|7-Z:t\u000b2,W.\u001a8ug^KG\u000f[*b[\u0016$\u0016.\\3ti\u0006l\u0007\u000fF\u0004a\u0003c\u000b),!/\t\u000f\u0005M\u00161\u0016a\u0001\u007f\u0006Q1-\u001e:S_^d\u0015n\u001d;\t\u000f\u0005]\u00161\u0016a\u0001u\u0005yA.Y:u\u0003\u000e\u001cW/\\;mCR|'\u000f\u0003\u0005\u0002\u0002\u0006-\u0006\u0019AAB\u0011\u001d\ti\f\u0001C!\u0003\u007f\u000bQa\u00197pg\u0016$\u0012\u0001\u0019")
public abstract class RowTimeUnboundedOver
extends ProcessFunctionWithCleanupState<CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final TypeInformation<Row> intermediateType;
    private final TypeInformation<CRow> inputType;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> rowMapState;
    private LinkedList<Object> sortedTimestamps;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        RowTimeUnboundedOver rowTimeUnboundedOver = this;
        synchronized (rowTimeUnboundedOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    public CRow output() {
        return this.output;
    }

    public void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> rowMapState() {
        return this.rowMapState;
    }

    private void rowMapState_$eq(MapState<Object, List<Row>> x$1) {
        this.rowMapState = x$1;
    }

    private LinkedList<Object> sortedTimestamps() {
        return this.sortedTimestamps;
    }

    private void sortedTimestamps_$eq(LinkedList<Object> x$1) {
        this.sortedTimestamps = x$1;
    }

    public GeneratedAggregations function() {
        return this.function;
    }

    public void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(30).append("Compiling AggregateHelper: ").append(this.genAggregations.name()).append(" \n\n").append(new StringBuilder(6).append("Code:\n").append(this.genAggregations.code()).toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        this.sortedTimestamps_$eq(new LinkedList<Object>());
        ValueStateDescriptor accDescriptor = new ValueStateDescriptor("accumulatorstate", this.intermediateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accDescriptor));
        ListTypeInfo rowListTypeInfo = new ListTypeInfo((TypeInformation)((CRowTypeInfo)this.inputType).rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("rowmapstate", (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, (TypeInformation)rowListTypeInfo);
        this.rowMapState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeUnboundedOverCleanupTime");
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        block1: {
            Row input = inputC.row();
            this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
            long timestamp = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
            long curWatermark = ctx.timerService().currentWatermark();
            if (timestamp <= curWatermark) break block1;
            ctx.timerService().registerEventTimeTimer(curWatermark + 1L);
            ArrayList<Row> rowList = (ArrayList<Row>)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
            if (rowList == null) {
                rowList = new ArrayList<Row>();
            }
            rowList.add(input);
            this.rowMapState().put((Object)BoxesRunTime.boxToLong((long)timestamp), rowList);
        }
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.needToCleanupState(timestamp)) {
                boolean noRecordsToProcess;
                boolean bl = noRecordsToProcess = !this.rowMapState().keys().iterator().hasNext();
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.rowMapState(), this.accumulatorState()}));
                    this.function().cleanup();
                } else {
                    this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        Iterator keyIterator = this.rowMapState().keys().iterator();
        if (keyIterator.hasNext()) {
            long curWatermark = ctx.timerService().currentWatermark();
            boolean existEarlyRecord = false;
            do {
                long recordTime;
                if ((recordTime = BoxesRunTime.unboxToLong(keyIterator.next())) <= curWatermark) {
                    this.insertToSortedList(recordTime);
                    continue;
                }
                existEarlyRecord = true;
            } while (keyIterator.hasNext());
            Row lastAccumulator = (Row)this.accumulatorState().value();
            if (lastAccumulator == null) {
                lastAccumulator = this.function().createAccumulators();
            }
            while (!this.sortedTimestamps().isEmpty()) {
                long curTimestamp = BoxesRunTime.unboxToLong((Object)this.sortedTimestamps().removeFirst());
                List curRowList = (List)this.rowMapState().get((Object)BoxesRunTime.boxToLong((long)curTimestamp));
                this.processElementsWithSameTimestamp(curRowList, lastAccumulator, out);
                this.rowMapState().remove((Object)BoxesRunTime.boxToLong((long)curTimestamp));
            }
            this.accumulatorState().update((Object)lastAccumulator);
            if (existEarlyRecord) {
                ctx.timerService().registerEventTimeTimer(curWatermark + 1L);
            }
        }
        this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    private void insertToSortedList(long recordTimestamp) {
        block1: {
            ListIterator<Object> listIterator = this.sortedTimestamps().listIterator(this.sortedTimestamps().size());
            boolean bl = true;
            while (listIterator.hasPrevious() && bl) {
                long timestamp = BoxesRunTime.unboxToLong((Object)listIterator.previous());
                if (recordTimestamp < timestamp) continue;
                listIterator.next();
                listIterator.add(BoxesRunTime.boxToLong((long)recordTimestamp));
                bl = false;
            }
            if (!bl) break block1;
            this.sortedTimestamps().addFirst(BoxesRunTime.boxToLong((long)recordTimestamp));
        }
    }

    public abstract void processElementsWithSameTimestamp(List<Row> var1, Row var2, Collector<CRow> var3);

    public void close() {
        this.function().close();
    }

    public RowTimeUnboundedOver(GeneratedAggregationsFunction genAggregations, TypeInformation<Row> intermediateType, TypeInformation<CRow> inputType, int rowTimeIdx, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.intermediateType = intermediateType;
        this.inputType = inputType;
        this.rowTimeIdx = rowTimeIdx;
        super(queryConfig);
        Compiler.$init$(this);
        Logging.$init$(this);
    }
}

