/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.runtime.aggregate.CollectionRowComparator;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0001\u0003\u0001=\u0011!DU8x)&lWmU8siB\u0013xnY3tg\u001a+hn\u0019;j_:T!a\u0001\u0003\u0002\u0013\u0005<wM]3hCR,'BA\u0003\u0007\u0003\u001d\u0011XO\u001c;j[\u0016T!a\u0002\u0005\u0002\u000bQ\f'\r\\3\u000b\u0005%Q\u0011!\u00024mS:\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001!A!\u0011\u0003\u0007\u000e\u001b\u001b\u0005\u0011\"BA\n\u0015\u0003%1WO\\2uS>t7O\u0003\u0002\u0016-\u0005\u0019\u0011\r]5\u000b\u0005]A\u0011!C:ue\u0016\fW.\u001b8h\u0013\tI\"CA\bQe>\u001cWm]:Gk:\u001cG/[8o!\tYb$D\u0001\u001d\u0015\tiB!A\u0003usB,7/\u0003\u0002 9\t!1IU8x\u0011!\t\u0003A!b\u0001\n\u0013\u0011\u0013\u0001D5oaV$(k\\<UsB,W#A\u0012\u0011\u0005m!\u0013BA\u0013\u001d\u00051\u0019%k\\<UsB,\u0017J\u001c4p\u0011!9\u0003A!A!\u0002\u0013\u0019\u0013!D5oaV$(k\\<UsB,\u0007\u0005\u0003\u0005*\u0001\t\u0015\r\u0011\"\u0003+\u0003)\u0011xn\u001e;j[\u0016LE\r_\u000b\u0002WA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t\u0019\u0011J\u001c;\t\u0011I\u0002!\u0011!Q\u0001\n-\n1B]8xi&lW-\u00133yA!AA\u0007\u0001BC\u0002\u0013%Q'A\u0007s_^\u001cu.\u001c9be\u0006$xN]\u000b\u0002mA\u0019AfN\u001d\n\u0005aj#AB(qi&|g\u000e\u0005\u0002;w5\t!!\u0003\u0002=\u0005\t92i\u001c7mK\u000e$\u0018n\u001c8S_^\u001cu.\u001c9be\u0006$xN\u001d\u0005\t}\u0001\u0011\t\u0011)A\u0005m\u0005q!o\\<D_6\u0004\u0018M]1u_J\u0004\u0003\"\u0002!\u0001\t\u0003\t\u0015A\u0002\u001fj]&$h\b\u0006\u0003C\u0007\u0012+\u0005C\u0001\u001e\u0001\u0011\u0015\ts\b1\u0001$\u0011\u0015Is\b1\u0001,\u0011\u0015!t\b1\u00017\u0011%9\u0005\u00011AA\u0002\u0013%\u0001*A\u0005eCR\f7\u000b^1uKV\t\u0011\n\u0005\u0003K!J+V\"A&\u000b\u00051k\u0015!B:uCR,'B\u0001(P\u0003\u0019\u0019w.\\7p]*\u0011Q\u0003C\u0005\u0003#.\u0013\u0001\"T1q'R\fG/\u001a\t\u0003YMK!\u0001V\u0017\u0003\t1{gn\u001a\t\u0004-nkV\"A,\u000b\u0005aK\u0016\u0001B;uS2T\u0011AW\u0001\u0005U\u00064\u0018-\u0003\u0002]/\n!A*[:u!\tq\u0006-D\u0001`\u0015\ti\u0002\"\u0003\u0002b?\n\u0019!k\\<\t\u0013\r\u0004\u0001\u0019!a\u0001\n\u0013!\u0017!\u00043bi\u0006\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0002fQB\u0011AFZ\u0005\u0003O6\u0012A!\u00168ji\"9\u0011NYA\u0001\u0002\u0004I\u0015a\u0001=%c!I1\u000e\u0001a\u0001\u0002\u0003\u0006K!S\u0001\u000bI\u0006$\u0018m\u0015;bi\u0016\u0004\u0003\"C7\u0001\u0001\u0004\u0005\r\u0011\"\u0003o\u0003Ua\u0017m\u001d;Ue&<w-\u001a:j]\u001e$6o\u0015;bi\u0016,\u0012a\u001c\t\u0004\u0015B\u0014\u0016BA9L\u0005)1\u0016\r\\;f'R\fG/\u001a\u0005\ng\u0002\u0001\r\u00111A\u0005\nQ\f\u0011\u0004\\1tiR\u0013\u0018nZ4fe&tw\rV:Ti\u0006$Xm\u0018\u0013fcR\u0011Q-\u001e\u0005\bSJ\f\t\u00111\u0001p\u0011%9\b\u00011A\u0001B\u0003&q.\u0001\fmCN$HK]5hO\u0016\u0014\u0018N\\4UgN#\u0018\r^3!\u0011%I\b\u00011AA\u0002\u0013%!0A\u0004pkR\u0004X\u000f^\"\u0016\u0003iA\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011B?\u0002\u0017=,H\u000f];u\u0007~#S-\u001d\u000b\u0003KzDq![>\u0002\u0002\u0003\u0007!\u0004\u0003\u0006\u0002\u0002\u0001\u0001\r\u0011!Q!\ni\t\u0001b\\;uaV$8\t\t\u0005\b\u0003\u000b\u0001A\u0011IA\u0004\u0003\u0011y\u0007/\u001a8\u0015\u0007\u0015\fI\u0001\u0003\u0005\u0002\f\u0005\r\u0001\u0019AA\u0007\u0003\u0019\u0019wN\u001c4jOB!\u0011qBA\u000b\u001b\t\t\tBC\u0002\u0002\u0014!\tQbY8oM&<WO]1uS>t\u0017\u0002BA\f\u0003#\u0011QbQ8oM&<WO]1uS>t\u0007bBA\u000e\u0001\u0011\u0005\u0013QD\u0001\u000faJ|7-Z:t\u000b2,W.\u001a8u)\u001d)\u0017qDA\u0012\u0003[Aq!!\t\u0002\u001a\u0001\u0007!$\u0001\u0004j]B,Ho\u0011\u0005\t\u0003K\tI\u00021\u0001\u0002(\u0005\u00191\r\u001e=\u0011\u0007A\tI#C\u0002\u0002,a\u0011qaQ8oi\u0016DH\u000f\u0003\u0005\u00020\u0005e\u0001\u0019AA\u0019\u0003\ryW\u000f\u001e\t\u0006\u0003g\t9DG\u0007\u0003\u0003kQ!\u0001\u0017\u0005\n\t\u0005e\u0012Q\u0007\u0002\n\u0007>dG.Z2u_JDq!!\u0010\u0001\t\u0003\ny$A\u0004p]RKW.\u001a:\u0015\u000f\u0015\f\t%!\u0012\u0002N!9\u00111IA\u001e\u0001\u0004\u0011\u0016!\u0003;j[\u0016\u001cH/Y7q\u0011!\t)#a\u000fA\u0002\u0005\u001d\u0003c\u0001\t\u0002J%\u0019\u00111\n\r\u0003\u001d=sG+[7fe\u000e{g\u000e^3yi\"A\u0011qFA\u001e\u0001\u0004\t\t\u0004")
public class RowTimeSortProcessFunction
extends ProcessFunction<CRow, CRow> {
    private final CRowTypeInfo inputRowType;
    private final int rowtimeIdx;
    private final Option<CollectionRowComparator> rowComparator;
    private MapState<Object, List<Row>> dataState;
    private ValueState<Object> lastTriggeringTsState;
    private CRow outputC;

    private CRowTypeInfo inputRowType() {
        return this.inputRowType;
    }

    private int rowtimeIdx() {
        return this.rowtimeIdx;
    }

    private Option<CollectionRowComparator> rowComparator() {
        return this.rowComparator;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private CRow outputC() {
        return this.outputC;
    }

    private void outputC_$eq(CRow x$1) {
        this.outputC = x$1;
    }

    public void open(Configuration config) {
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType().rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        this.outputC_$eq(new CRow());
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        block2: {
            long lastTriggeringTs;
            Row input = inputC.row();
            long rowtime = BoxesRunTime.unboxToLong((Object)input.getField(this.rowtimeIdx()));
            if (rowtime <= (lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value()))) break block2;
            List rows = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)rowtime));
            if (rows != null) {
                rows.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)rowtime), (Object)rows);
            } else {
                ArrayList<Row> rows2 = new ArrayList<Row>();
                rows2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)rowtime), rows2);
                ctx.timerService().registerEventTimeTimer(rowtime);
            }
        }
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        block2: {
            ((TimestampedCollector)out).eraseTimestamp();
            List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
            if (inputs == null) break block2;
            if (this.rowComparator().isDefined()) {
                Collections.sort(inputs, (Comparator)this.rowComparator().get());
            }
            for (int i = 0; i < inputs.size(); ++i) {
                this.outputC().row_$eq((Row)inputs.get(i));
                out.collect((Object)this.outputC());
            }
            this.dataState().remove((Object)BoxesRunTime.boxToLong((long)timestamp));
            this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        }
    }

    public RowTimeSortProcessFunction(CRowTypeInfo inputRowType, int rowtimeIdx, Option<CollectionRowComparator> rowComparator) {
        this.inputRowType = inputRowType;
        this.rowtimeIdx = rowtimeIdx;
        this.rowComparator = rowComparator;
        Preconditions.checkNotNull(rowComparator);
    }
}

