/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0001\u0003\u0001=\u0011aCU8x)&lWMQ8v]\u0012,GMU8xg>3XM\u001d\u0006\u0003\u0007\u0011\t\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001CG\u0012\u0011\tE\u0011B\u0003F\u0007\u0002\u0005%\u00111C\u0001\u0002 !J|7-Z:t\rVt7\r^5p]^KG\u000f[\"mK\u0006tW\u000f]*uCR,\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u0015!\u0018\u0010]3t\u0013\tIbC\u0001\u0003D%><\bcA\u000e\u001fA5\tAD\u0003\u0002\u001e\r\u000591m\u001c3fO\u0016t\u0017BA\u0010\u001d\u0005!\u0019u.\u001c9jY\u0016\u0014\bCA\t\"\u0013\t\u0011#AA\u000bHK:,'/\u0019;fI\u0006;wM]3hCRLwN\\:\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u00192\u0011\u0001B;uS2L!\u0001K\u0013\u0003\u000f1{wmZ5oO\"A!\u0006\u0001B\u0001B\u0003%1&A\bhK:\fum\u001a:fO\u0006$\u0018n\u001c8t!\tYB&\u0003\u0002.9\tir)\u001a8fe\u0006$X\rZ!hOJ,w-\u0019;j_:\u001ch)\u001e8di&|g\u000e\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0003Q\twm\u001a:fO\u0006$\u0018n\u001c8Ti\u0006$X\rV=qKB\u0011\u0011\u0007O\u0007\u0002e)\u00111\u0007N\u0001\nif\u0004X-\u001e;jYNT!!\u000e\u001c\u0002\t)\fg/\u0019\u0006\u0003o!\t1!\u00199j\u0013\tI$GA\u0006S_^$\u0016\u0010]3J]\u001a|\u0007\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\u0019%t\u0007/\u001e;S_^$\u0016\u0010]3\u0011\u0005Ui\u0014B\u0001 \u0017\u00051\u0019%k\\<UsB,\u0017J\u001c4p\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0015a\u00049sK\u000e,G-\u001b8h\u001f\u001a47/\u001a;\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\t1{gn\u001a\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\u0006Q!o\\<US6,\u0017\n\u001a=\u0011\u0005\tS\u0015BA&D\u0005\rIe\u000e\u001e\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\u0006Y\u0011/^3ss\u000e{gNZ5h!\ty\u0015+D\u0001Q\u0015\t9d!\u0003\u0002S!\n\t2\u000b\u001e:fC6\fV/\u001a:z\u0007>tg-[4\t\u000bQ\u0003A\u0011A+\u0002\rqJg.\u001b;?)\u001d1v\u000bW-[7r\u0003\"!\u0005\u0001\t\u000b)\u001a\u0006\u0019A\u0016\t\u000b=\u001a\u0006\u0019\u0001\u0019\t\u000bm\u001a\u0006\u0019\u0001\u001f\t\u000b\u0001\u001b\u0006\u0019A!\t\u000b!\u001b\u0006\u0019A%\t\u000b5\u001b\u0006\u0019\u0001(\t\u0013y\u0003\u0001\u0019!a\u0001\n\u0013y\u0016AB8viB,H/F\u0001\u0015\u0011%\t\u0007\u00011AA\u0002\u0013%!-\u0001\u0006pkR\u0004X\u000f^0%KF$\"a\u00194\u0011\u0005\t#\u0017BA3D\u0005\u0011)f.\u001b;\t\u000f\u001d\u0004\u0017\u0011!a\u0001)\u0005\u0019\u0001\u0010J\u0019\t\u0013%\u0004\u0001\u0019!A!B\u0013!\u0012aB8viB,H\u000f\t\u0005\nW\u0002\u0001\r\u00111A\u0005\n1\fQ\u0003\\1tiR\u0013\u0018nZ4fe&tw\rV:Ti\u0006$X-F\u0001n!\rq7/Q\u0007\u0002_*\u0011\u0001/]\u0001\u0006gR\fG/\u001a\u0006\u0003eZ\naaY8n[>t\u0017B\u0001;p\u0005)1\u0016\r\\;f'R\fG/\u001a\u0005\nm\u0002\u0001\r\u00111A\u0005\n]\f\u0011\u0004\\1tiR\u0013\u0018nZ4fe&tw\rV:Ti\u0006$Xm\u0018\u0013fcR\u00111\r\u001f\u0005\bOV\f\t\u00111\u0001n\u0011%Q\b\u00011A\u0001B\u0003&Q.\u0001\fmCN$HK]5hO\u0016\u0014\u0018N\\4UgN#\u0018\r^3!\u0011%a\b\u00011AA\u0002\u0013%A.\u0001\beCR\f7i\\;oiN#\u0018\r^3\t\u0013y\u0004\u0001\u0019!a\u0001\n\u0013y\u0018A\u00053bi\u0006\u001cu.\u001e8u'R\fG/Z0%KF$2aYA\u0001\u0011\u001d9W0!AA\u00025D!\"!\u0002\u0001\u0001\u0004\u0005\t\u0015)\u0003n\u0003=!\u0017\r^1D_VtGo\u0015;bi\u0016\u0004\u0003bCA\u0005\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0017\t\u0001#Y2dk6,H.\u0019;peN#\u0018\r^3\u0016\u0005\u00055\u0001\u0003\u00028t\u0003\u001f\u0001B!!\u0005\u0002\u00165\u0011\u00111\u0003\u0006\u0003/!IA!a\u0006\u0002\u0014\t\u0019!k\\<\t\u0017\u0005m\u0001\u00011AA\u0002\u0013%\u0011QD\u0001\u0015C\u000e\u001cW/\\;mCR|'o\u0015;bi\u0016|F%Z9\u0015\u0007\r\fy\u0002C\u0005h\u00033\t\t\u00111\u0001\u0002\u000e!Y\u00111\u0005\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0007\u0003E\t7mY;nk2\fGo\u001c:Ti\u0006$X\r\t\u0005\f\u0003O\u0001\u0001\u0019!a\u0001\n\u0013\tI#A\u0005eCR\f7\u000b^1uKV\u0011\u00111\u0006\t\u0007]\u00065\u0012)!\r\n\u0007\u0005=rN\u0001\u0005NCB\u001cF/\u0019;f!\u0019\t\u0019$!\u000f\u0002\u00105\u0011\u0011Q\u0007\u0006\u0004M\u0005]\"\"A\u001b\n\t\u0005m\u0012Q\u0007\u0002\u0005\u0019&\u001cH\u000fC\u0006\u0002@\u0001\u0001\r\u00111A\u0005\n\u0005\u0005\u0013!\u00043bi\u0006\u001cF/\u0019;f?\u0012*\u0017\u000fF\u0002d\u0003\u0007B\u0011bZA\u001f\u0003\u0003\u0005\r!a\u000b\t\u0017\u0005\u001d\u0003\u00011A\u0001B\u0003&\u00111F\u0001\u000bI\u0006$\u0018m\u0015;bi\u0016\u0004\u0003bCA&\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u001b\n\u0001BZ;oGRLwN\\\u000b\u0002A!Y\u0011\u0011\u000b\u0001A\u0002\u0003\u0007I\u0011BA*\u000311WO\\2uS>tw\fJ3r)\r\u0019\u0017Q\u000b\u0005\tO\u0006=\u0013\u0011!a\u0001A!Q\u0011\u0011\f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u0011\u0002\u0013\u0019,hn\u0019;j_:\u0004\u0003bBA/\u0001\u0011\u0005\u0013qL\u0001\u0005_B,g\u000eF\u0002d\u0003CB\u0001\"a\u0019\u0002\\\u0001\u0007\u0011QM\u0001\u0007G>tg-[4\u0011\t\u0005\u001d\u0014QN\u0007\u0003\u0003SR1!a\u001b\t\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&!\u0011qNA5\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\"9\u00111\u000f\u0001\u0005B\u0005U\u0014A\u00049s_\u000e,7o]#mK6,g\u000e\u001e\u000b\bG\u0006]\u00141PAL\u0011\u001d\tI(!\u001dA\u0002Q\ta!\u001b8qkR\u001c\u0005\u0002CA?\u0003c\u0002\r!a \u0002\u0007\r$\b\u0010\u0005\u0003\u0002\u0002\u0006M\u0005CBAB\u0003\u001f#B#\u0004\u0002\u0002\u0006*!\u0011qQAE\u0003%1WO\\2uS>t7OC\u00028\u0003\u0017S1!!$\t\u0003%\u0019HO]3b[&tw-\u0003\u0003\u0002\u0012\u0006\u0015%a\u0004)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8\n\t\u0005U\u0015q\u0012\u0002\b\u0007>tG/\u001a=u\u0011!\tI*!\u001dA\u0002\u0005m\u0015aA8viB)\u0011QTAQ)5\u0011\u0011q\u0014\u0006\u0003M!IA!a)\u0002 \nI1i\u001c7mK\u000e$xN\u001d\u0005\b\u0003O\u0003A\u0011IAU\u0003\u001dyg\u000eV5nKJ$raYAV\u0003_\u000b9\fC\u0004\u0002.\u0006\u0015\u0006\u0019A!\u0002\u0013QLW.Z:uC6\u0004\b\u0002CA?\u0003K\u0003\r!!-\u0011\t\u0005\u0005\u00151W\u0005\u0005\u0003k\u000byI\u0001\bP]RKW.\u001a:D_:$X\r\u001f;\t\u0011\u0005e\u0015Q\u0015a\u0001\u00037Cq!a/\u0001\t\u0003\ni,A\u0003dY>\u001cX\rF\u0001d\u0001")
public class RowTimeBoundedRowsOver
extends ProcessFunctionWithCleanupState<CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final CRowTypeInfo inputRowType;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Object> lastTriggeringTsState;
    private ValueState<Object> dataCountState;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> dataState;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        RowTimeBoundedRowsOver rowTimeBoundedRowsOver = this;
        synchronized (rowTimeBoundedRowsOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private ValueState<Object> dataCountState() {
        return this.dataCountState;
    }

    private void dataCountState_$eq(ValueState<Object> x$1) {
        this.dataCountState = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(30).append("Compiling AggregateHelper: ").append(this.genAggregations.name()).append(" \n\n").append(new StringBuilder(6).append("Code:\n").append(this.genAggregations.code()).toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        ValueStateDescriptor dataCountStateDescriptor = new ValueStateDescriptor("dataCountState", Long.TYPE);
        this.dataCountState_$eq((ValueState<Object>)this.getRuntimeContext().getState(dataCountStateDescriptor));
        ValueStateDescriptor accumulatorStateDescriptor = new ValueStateDescriptor("accumulatorState", (TypeInformation)this.aggregationStateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accumulatorStateDescriptor));
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType.rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeBoundedRowsOverCleanupTime");
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        block2: {
            Row input = inputC.row();
            this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
            long triggeringTs = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
            long lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
            if (triggeringTs <= lastTriggeringTs) break block2;
            List data = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)triggeringTs));
            if (data != null) {
                data.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), (Object)data);
            } else {
                ArrayList<Row> data2 = new ArrayList<Row>();
                data2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), data2);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            }
        }
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.needToCleanupState(timestamp)) {
                Iterator keysIt = this.dataState().keys().iterator();
                long lastProcessedTime = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (BoxesRunTime.unboxToLong(keysIt.next()) <= lastProcessedTime) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.dataState(), this.accumulatorState(), this.dataCountState(), this.lastTriggeringTsState()}));
                    this.function().cleanup();
                } else {
                    this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
        if (inputs != null) {
            Row accumulators = (Row)this.accumulatorState().value();
            long dataCount = BoxesRunTime.unboxToLong((Object)this.dataCountState().value());
            List retractList = null;
            long retractTs = Long.MAX_VALUE;
            int retractCnt = 0;
            for (int i = 0; i < inputs.size(); ++i) {
                Row input = (Row)inputs.get(i);
                if (accumulators == null) {
                    accumulators = this.function().createAccumulators();
                }
                Row retractRow = null;
                if (dataCount >= this.precedingOffset) {
                    if (retractList == null) {
                        retractTs = Long.MAX_VALUE;
                        Iterator dataTimestampIt = this.dataState().keys().iterator();
                        while (dataTimestampIt.hasNext()) {
                            long dataTs = BoxesRunTime.unboxToLong(dataTimestampIt.next());
                            if (dataTs >= retractTs) continue;
                            retractTs = dataTs;
                        }
                        retractList = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)retractTs));
                    }
                    retractRow = (Row)retractList.get(retractCnt);
                    if (retractList.size() == ++retractCnt) {
                        this.dataState().remove((Object)BoxesRunTime.boxToLong((long)retractTs));
                        retractList = null;
                        retractCnt = 0;
                    }
                } else {
                    ++dataCount;
                }
                this.function().setForwardedFields(input, this.output().row());
                if (retractRow != null) {
                    this.function().retract(accumulators, retractRow);
                }
                this.function().accumulate(accumulators, input);
                this.function().setAggregationResults(accumulators, this.output().row());
                out.collect((Object)this.output());
            }
            if (this.dataState().contains((Object)BoxesRunTime.boxToLong((long)retractTs)) && retractCnt > 0) {
                retractList.subList(0, retractCnt).clear();
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)retractTs), (Object)retractList);
            }
            this.dataCountState().update((Object)BoxesRunTime.boxToLong((long)dataCount));
            this.accumulatorState().update((Object)accumulators);
        }
        this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    public void close() {
        this.function().close();
    }

    public RowTimeBoundedRowsOver(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, CRowTypeInfo inputRowType, long precedingOffset, int rowTimeIdx, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.inputRowType = inputRowType;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
        super(queryConfig);
        Compiler.$init$(this);
        Logging.$init$(this);
        Preconditions.checkNotNull((Object)aggregationStateType);
        Preconditions.checkNotNull((Object)BoxesRunTime.boxToLong((long)precedingOffset));
    }
}

