/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.util;

import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.MultisetTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.table.plan.util.BooleanExplodeTableFunc;
import org.apache.flink.table.plan.util.ByteExplodeTableFunc;
import org.apache.flink.table.plan.util.DoubleExplodeTableFunc;
import org.apache.flink.table.plan.util.ExplodeTableFunction;
import org.apache.flink.table.plan.util.FloatExplodeTableFunc;
import org.apache.flink.table.plan.util.IntExplodeTableFunc;
import org.apache.flink.table.plan.util.LongExplodeTableFunc;
import org.apache.flink.table.plan.util.ObjectExplodeTableFunc;
import org.apache.flink.table.plan.util.ShortExplodeTableFunc;

public final class ExplodeFunctionUtil$ {
    public static ExplodeFunctionUtil$ MODULE$;

    static {
        new ExplodeFunctionUtil$();
    }

    public TableFunction<?> explodeTableFuncFromType(TypeInformation<?> ti) {
        TableFunction tableFunction;
        TypeInformation<?> typeInformation = ti;
        if (typeInformation instanceof PrimitiveArrayTypeInfo) {
            PrimitiveArrayTypeInfo primitiveArrayTypeInfo = (PrimitiveArrayTypeInfo)typeInformation;
            tableFunction = this.createTableFuncByType(primitiveArrayTypeInfo.getComponentType());
        } else if (typeInformation instanceof ObjectArrayTypeInfo) {
            tableFunction = new ObjectExplodeTableFunc();
        } else if (typeInformation instanceof BasicArrayTypeInfo) {
            tableFunction = new ObjectExplodeTableFunc();
        } else if (typeInformation instanceof MultisetTypeInfo) {
            MultisetTypeInfo multisetTypeInfo = (MultisetTypeInfo)typeInformation;
            tableFunction = this.createTableFuncByType(multisetTypeInfo.getElementTypeInfo());
        } else {
            throw new TableException(new StringBuilder(33).append("Unnesting of '").append(ti.toString()).append("' is not supported.").toString());
        }
        return tableFunction;
    }

    public TableFunction<?> createTableFuncByType(TypeInformation<?> typeInfo) {
        ExplodeTableFunction explodeTableFunction;
        TypeInformation<?> typeInformation = typeInfo;
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
        TypeInformation<?> typeInformation2 = typeInformation;
        if (!(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null)) {
            explodeTableFunction = new IntExplodeTableFunc();
        } else {
            BasicTypeInfo basicTypeInfo2 = BasicTypeInfo.LONG_TYPE_INFO;
            TypeInformation<?> typeInformation3 = typeInformation;
            if (!(basicTypeInfo2 != null ? !basicTypeInfo2.equals(typeInformation3) : typeInformation3 != null)) {
                explodeTableFunction = new LongExplodeTableFunc();
            } else {
                BasicTypeInfo basicTypeInfo3 = BasicTypeInfo.SHORT_TYPE_INFO;
                TypeInformation<?> typeInformation4 = typeInformation;
                if (!(basicTypeInfo3 != null ? !basicTypeInfo3.equals(typeInformation4) : typeInformation4 != null)) {
                    explodeTableFunction = new ShortExplodeTableFunc();
                } else {
                    BasicTypeInfo basicTypeInfo4 = BasicTypeInfo.FLOAT_TYPE_INFO;
                    TypeInformation<?> typeInformation5 = typeInformation;
                    if (!(basicTypeInfo4 != null ? !basicTypeInfo4.equals(typeInformation5) : typeInformation5 != null)) {
                        explodeTableFunction = new FloatExplodeTableFunc();
                    } else {
                        BasicTypeInfo basicTypeInfo5 = BasicTypeInfo.DOUBLE_TYPE_INFO;
                        TypeInformation<?> typeInformation6 = typeInformation;
                        if (!(basicTypeInfo5 != null ? !basicTypeInfo5.equals(typeInformation6) : typeInformation6 != null)) {
                            explodeTableFunction = new DoubleExplodeTableFunc();
                        } else {
                            BasicTypeInfo basicTypeInfo6 = BasicTypeInfo.BYTE_TYPE_INFO;
                            TypeInformation<?> typeInformation7 = typeInformation;
                            if (!(basicTypeInfo6 != null ? !basicTypeInfo6.equals(typeInformation7) : typeInformation7 != null)) {
                                explodeTableFunction = new ByteExplodeTableFunc();
                            } else {
                                BasicTypeInfo basicTypeInfo7 = BasicTypeInfo.BOOLEAN_TYPE_INFO;
                                TypeInformation<?> typeInformation8 = typeInformation;
                                explodeTableFunction = !(basicTypeInfo7 != null ? !basicTypeInfo7.equals(typeInformation8) : typeInformation8 != null) ? new BooleanExplodeTableFunc() : new ObjectExplodeTableFunc();
                            }
                        }
                    }
                }
            }
        }
        return explodeTableFunction;
    }

    private ExplodeFunctionUtil$() {
        MODULE$ = this;
    }
}

