/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.rules.datastream;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.table.api.TableConfig$;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.plan.nodes.FlinkConventions$;
import org.apache.flink.table.plan.nodes.datastream.DataStreamJoin;
import org.apache.flink.table.plan.nodes.logical.FlinkLogicalJoin;
import org.apache.flink.table.plan.rules.datastream.DataStreamJoinRule$;
import org.apache.flink.table.plan.schema.RowSchema;
import org.apache.flink.table.runtime.join.WindowJoinUtil;
import org.apache.flink.table.runtime.join.WindowJoinUtil$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)3A!\u0001\u0002\u0001#\t\u0011B)\u0019;b'R\u0014X-Y7K_&t'+\u001e7f\u0015\t\u0019A!\u0001\u0006eCR\f7\u000f\u001e:fC6T!!\u0002\u0004\u0002\u000bI,H.Z:\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CG\u0007\u0002))\u0011QCF\u0001\bG>tg/\u001a:u\u0015\t9\u0002$A\u0002sK2T!!\u0007\u0007\u0002\u000f\r\fGnY5uK&\u00111\u0004\u0006\u0002\u000e\u0007>tg/\u001a:uKJ\u0014V\u000f\\3\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u0011\u0001\u001b\u0005\u0011\u0001\"\u0002\u0012\u0001\t\u0003\u001a\u0013aB7bi\u000eDWm\u001d\u000b\u0003I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012qAQ8pY\u0016\fg\u000eC\u0003,C\u0001\u0007A&\u0001\u0003dC2d\u0007CA\u00170\u001b\u0005q#BA\u0004\u0019\u0013\t\u0001dF\u0001\bSK2|\u0005\u000f\u001e*vY\u0016\u001c\u0015\r\u001c7\t\u000bU\u0001A\u0011\t\u001a\u0015\u0005M:\u0004C\u0001\u001b6\u001b\u00051\u0012B\u0001\u001c\u0017\u0005\u001d\u0011V\r\u001c(pI\u0016DQaF\u0019A\u0002M:Q!\u000f\u0002\t\u0002i\n!\u0003R1uCN#(/Z1n\u0015>LgNU;mKB\u0011\u0001e\u000f\u0004\u0006\u0003\tA\t\u0001P\n\u0003wu\u0002\"!\n \n\u0005}2#AB!osJ+g\rC\u0003\u001ew\u0011\u0005\u0011\tF\u0001;\u0011\u001d\u00195H1A\u0005\u0002\u0011\u000b\u0001\"\u0013(T)\u0006s5)R\u000b\u0002\u000bB\u0011QFR\u0005\u0003\u000f:\u0012!BU3m\u001fB$(+\u001e7f\u0011\u0019I5\b)A\u0005\u000b\u0006I\u0011JT*U\u0003:\u001bU\t\t")
public class DataStreamJoinRule
extends ConverterRule {
    public static RelOptRule INSTANCE() {
        return DataStreamJoinRule$.MODULE$.INSTANCE();
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        Option windowBounds;
        FlinkLogicalJoin join = (FlinkLogicalJoin)call.rel(0);
        JoinInfo joinInfo = join.analyzeCondition();
        Tuple2<Option<WindowJoinUtil.WindowBounds>, Option<RexNode>> tuple2 = WindowJoinUtil$.MODULE$.extractWindowBoundsFromPredicate(joinInfo.getRemaining(join.getCluster().getRexBuilder()), join.getLeft().getRowType().getFieldCount(), join.getRowType(), join.getCluster().getRexBuilder(), TableConfig$.MODULE$.DEFAULT());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option option = windowBounds = (Option)tuple2._1();
        Option windowBounds2 = option;
        if (windowBounds2.isDefined()) {
            return false;
        }
        boolean rowTimeAttrInOutput = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(join.getRowType().getFieldList()).asScala()).exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType(f.getType())));
        if (rowTimeAttrInOutput) {
            throw new TableException("Rowtime attributes must not be in the input rows of a regular join. As a workaround you can cast the time attributes of input tables to TIMESTAMP before.");
        }
        return true;
    }

    @Override
    public RelNode convert(RelNode rel) {
        FlinkLogicalJoin join = (FlinkLogicalJoin)rel;
        RelTraitSet traitSet = rel.getTraitSet().replace(FlinkConventions$.MODULE$.DATASTREAM());
        RelNode convLeft = RelOptRule.convert(join.getInput(0), FlinkConventions$.MODULE$.DATASTREAM());
        RelNode convRight = RelOptRule.convert(join.getInput(1), FlinkConventions$.MODULE$.DATASTREAM());
        JoinInfo joinInfo = join.analyzeCondition();
        RowSchema leftRowSchema = new RowSchema(convLeft.getRowType());
        RowSchema rightRowSchema = new RowSchema(convRight.getRowType());
        return new DataStreamJoin(rel.getCluster(), traitSet, convLeft, convRight, join.getCondition(), joinInfo, join.getJoinType(), leftRowSchema, rightRowSchema, new RowSchema(rel.getRowType()), this.description);
    }

    public DataStreamJoinRule() {
        super(FlinkLogicalJoin.class, FlinkConventions$.MODULE$.LOGICAL(), FlinkConventions$.MODULE$.DATASTREAM(), "DataStreamJoinRule");
    }
}

