/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.datastream;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Pair;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.functions.NullByteKeySelector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.StreamTableEnvironment;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.codegen.AggregationCodeGenerator;
import org.apache.flink.table.plan.nodes.CommonAggregate;
import org.apache.flink.table.plan.nodes.FlinkRelNode;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel;
import org.apache.flink.table.plan.rules.datastream.DataStreamRetractionRules$;
import org.apache.flink.table.plan.schema.RowSchema;
import org.apache.flink.table.runtime.CRowKeySelector;
import org.apache.flink.table.runtime.aggregate.AggregateUtil$;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.runtime.types.CRowTypeInfo$;
import org.apache.flink.table.util.Logging;
import org.slf4j.Logger;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u0001E\u0011\u0001\u0004R1uCN#(/Z1n\u000fJ|W\u000f]!hOJ,w-\u0019;f\u0015\t\u0019A!\u0001\u0006eCR\f7\u000f\u001e:fC6T!!\u0002\u0004\u0002\u000b9|G-Z:\u000b\u0005\u001dA\u0011\u0001\u00029mC:T!!\u0003\u0006\u0002\u000bQ\f'\r\\3\u000b\u0005-a\u0011!\u00024mS:\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001%iq\"\u0005\u0005\u0002\u001415\tAC\u0003\u0002\u0016-\u0005\u0019!/\u001a7\u000b\u0005]a\u0011aB2bY\u000eLG/Z\u0005\u00033Q\u0011\u0011bU5oO2,'+\u001a7\u0011\u0005maR\"\u0001\u0003\n\u0005u!!aD\"p[6|g.Q4he\u0016<\u0017\r^3\u0011\u0005}\u0001S\"\u0001\u0002\n\u0005\u0005\u0012!!\u0004#bi\u0006\u001cFO]3b[J+G\u000e\u0005\u0002$M5\tAE\u0003\u0002&\u0011\u0005!Q\u000f^5m\u0013\t9CEA\u0004M_\u001e<\u0017N\\4\t\u0011%\u0002!\u0011!Q\u0001\n)\nqa\u00197vgR,'\u000f\u0005\u0002,[5\tAF\u0003\u0002\b-%\u0011a\u0006\f\u0002\u000e%\u0016dw\n\u001d;DYV\u001cH/\u001a:\t\u0011A\u0002!\u0011!Q\u0001\nE\n\u0001\u0002\u001e:bSR\u001cV\r\u001e\t\u0003WIJ!a\r\u0017\u0003\u0017I+G\u000e\u0016:bSR\u001cV\r\u001e\u0005\tk\u0001\u0011\t\u0011)A\u0005m\u0005I\u0011N\u001c9vi:{G-\u001a\t\u0003']J!\u0001\u000f\u000b\u0003\u000fI+GNT8eK\"A!\b\u0001B\u0001B\u0003%1(A\boC6,G-Q4he\u0016<\u0017\r^3t!\rad)\u0013\b\u0003{\rs!AP!\u000e\u0003}R!\u0001\u0011\t\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0015!B:dC2\f\u0017B\u0001#F\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011AQ\u0005\u0003\u000f\"\u00131aU3r\u0015\t!U\t\u0005\u0003K;\u00024gBA&[\u001d\tauK\u0004\u0002N+:\u0011a\n\u0016\b\u0003\u001fNs!\u0001\u0015*\u000f\u0005y\n\u0016\"A\b\n\u00055q\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002W\u0011\u00059!/\u001e8uS6,\u0017B\u0001-Z\u0003%\twm\u001a:fO\u0006$XM\u0003\u0002W\u0011%\u00111\fX\u0001\u000e\u0003\u001e<'/Z4bi\u0016,F/\u001b7\u000b\u0005aK\u0016B\u00010`\u0005-\u0019\u0015\r\\2ji\u0016\u0004\u0016-\u001b:\u000b\u0005mc\u0006CA1e\u001b\u0005\u0011'BA2\u0015\u0003\u0011\u0019wN]3\n\u0005\u0015\u0014'!D!hOJ,w-\u0019;f\u0007\u0006dG\u000e\u0005\u0002hW:\u0011\u0001.\u001b\t\u0003}\u0015K!A[#\u0002\rA\u0013X\rZ3g\u0013\taWN\u0001\u0004TiJLgn\u001a\u0006\u0003U\u0016C\u0001b\u001c\u0001\u0003\u0002\u0003\u0006I\u0001]\u0001\u0007g\u000eDW-\\1\u0011\u0005E\u001cX\"\u0001:\u000b\u0005=4\u0011B\u0001;s\u0005%\u0011vn^*dQ\u0016l\u0017\r\u0003\u0005w\u0001\t\u0005\t\u0015!\u0003q\u0003-Ig\u000e];u'\u000eDW-\\1\t\u0011a\u0004!\u0011!Q\u0001\ne\f\u0011b\u001a:pkBLgnZ:\u0011\u0007i\\X0D\u0001F\u0013\taXIA\u0003BeJ\f\u0017\u0010\u0005\u0002{}&\u0011q0\u0012\u0002\u0004\u0013:$\bbBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005\u001d\u0011\u0011BA\u0006\u0003\u001b\ty!!\u0005\u0002\u0014\u0005U\u0001CA\u0010\u0001\u0011\u0019I\u0013\u0011\u0001a\u0001U!1\u0001'!\u0001A\u0002EBa!NA\u0001\u0001\u00041\u0004B\u0002\u001e\u0002\u0002\u0001\u00071\b\u0003\u0004p\u0003\u0003\u0001\r\u0001\u001d\u0005\u0007m\u0006\u0005\u0001\u0019\u00019\t\ra\f\t\u00011\u0001z\u0011\u001d\tI\u0002\u0001C!\u00037\tQ\u0002Z3sSZ,'k\\<UsB,GCAA\u000f!\u0011\ty\"!\n\u000e\u0005\u0005\u0005\"bAA\u0012)\u0005!A/\u001f9f\u0013\u0011\t9#!\t\u0003\u0017I+G\u000eR1uCRK\b/\u001a\u0005\b\u0003W\u0001A\u0011IA\u0017\u0003aqW-\u001a3t+B$\u0017\r^3t\u0003N\u0014V\r\u001e:bGRLwN\\\u000b\u0003\u0003_\u00012A_A\u0019\u0013\r\t\u0019$\u0012\u0002\b\u0005>|G.Z1o\u0011\u001d\t9\u0004\u0001C!\u0003[\tq\u0002\u001d:pIV\u001cWm]+qI\u0006$Xm\u001d\u0005\b\u0003w\u0001A\u0011IA\u0017\u0003M\u0019wN\\:v[\u0016\u001c(+\u001a;sC\u000e$\u0018n\u001c8t\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003\nAbZ3u\u000fJ|W\u000f]5oON,\u0012!\u001f\u0005\b\u0003\u000b\u0002A\u0011IA$\u0003\u0011\u0019w\u000e]=\u0015\u000bY\nI%a\u0013\t\rA\n\u0019\u00051\u00012\u0011!\ti%a\u0011A\u0002\u0005=\u0013AB5oaV$8\u000fE\u0003\u0002R\u0005ec'\u0004\u0002\u0002T)\u0019Q%!\u0016\u000b\u0005\u0005]\u0013\u0001\u00026bm\u0006LA!a\u0017\u0002T\t!A*[:u\u0011\u001d\ty\u0006\u0001C!\u0003C\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002M\"9\u0011Q\r\u0001\u0005B\u0005\u001d\u0014\u0001D3ya2\f\u0017N\u001c+fe6\u001cH\u0003BA5\u0003_\u00022aEA6\u0013\r\ti\u0007\u0006\u0002\n%\u0016dwK]5uKJD\u0001\"!\u001d\u0002d\u0001\u0007\u0011\u0011N\u0001\u0003a^Dq!!\u001e\u0001\t\u0003\n9(A\bue\u0006t7\u000f\\1uKR{\u0007\u000b\\1o)\u0019\tI(a&\u0002&B1\u00111PAD\u0003\u0017k!!! \u000b\u0007\r\tyH\u0003\u0003\u0002\u0002\u0006\r\u0015aA1qS*\u0019\u0011Q\u0011\u0006\u0002\u0013M$(/Z1nS:<\u0017\u0002BAE\u0003{\u0012!\u0002R1uCN#(/Z1n!\u0011\ti)a%\u000e\u0005\u0005=%bAAI3\u0006)A/\u001f9fg&!\u0011QSAH\u0005\u0011\u0019%k\\<\t\u0011\u0005e\u00151\u000fa\u0001\u00037\u000b\u0001\u0002^1cY\u0016,eN\u001e\t\u0005\u0003;\u000b\t+\u0004\u0002\u0002 *\u0019\u0011\u0011\u0011\u0005\n\t\u0005\r\u0016q\u0014\u0002\u0017'R\u0014X-Y7UC\ndW-\u00128wSJ|g.\\3oi\"A\u0011qUA:\u0001\u0004\tI+A\u0006rk\u0016\u0014\u0018pQ8oM&<\u0007\u0003BAO\u0003WKA!!,\u0002 \n\t2\u000b\u001e:fC6\fV/\u001a:z\u0007>tg-[4")
public class DataStreamGroupAggregate
extends SingleRel
implements CommonAggregate,
DataStreamRel,
Logging {
    private final RelOptCluster cluster;
    private final Seq<Pair<AggregateCall, String>> namedAggregates;
    private final RowSchema schema;
    private final RowSchema inputSchema;
    private final int[] groupings;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public boolean producesRetractions() {
        return DataStreamRel.producesRetractions$(this);
    }

    @Override
    public String getExpressionString(RexNode expr, Seq<String> inFields, Option<Seq<RexNode>> localExprsTable) {
        return FlinkRelNode.getExpressionString$(this, expr, inFields, localExprsTable);
    }

    @Override
    public double estimateRowSize(RelDataType rowType) {
        return FlinkRelNode.estimateRowSize$(this, rowType);
    }

    @Override
    public double estimateDataTypeSize(RelDataType t) {
        return FlinkRelNode.estimateDataTypeSize$(this, t);
    }

    @Override
    public String groupingToString(RelDataType inputType, int[] grouping) {
        return CommonAggregate.groupingToString$(this, inputType, grouping);
    }

    @Override
    public String aggregationToString(RelDataType inputType, int[] grouping, RelDataType rowType, Seq<Pair<AggregateCall, String>> namedAggregates, Seq<FlinkRelBuilder.NamedWindowProperty> namedProperties) {
        return CommonAggregate.aggregationToString$(this, inputType, grouping, rowType, namedAggregates, namedProperties);
    }

    private Logger LOG$lzycompute() {
        DataStreamGroupAggregate dataStreamGroupAggregate = this;
        synchronized (dataStreamGroupAggregate) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    @Override
    public RelDataType deriveRowType() {
        return this.schema.relDataType();
    }

    @Override
    public boolean needsUpdatesAsRetraction() {
        return true;
    }

    @Override
    public boolean producesUpdates() {
        return true;
    }

    @Override
    public boolean consumesRetractions() {
        return true;
    }

    public int[] getGroupings() {
        return this.groupings;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DataStreamGroupAggregate(this.cluster, traitSet, inputs.get(0), this.namedAggregates, this.schema, this.inputSchema, this.groupings);
    }

    @Override
    public String toString() {
        return new StringBuilder(20).append("Aggregate(").append((Object)(!new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.groupings)).isEmpty() ? new StringBuilder(13).append("groupBy: (").append(this.groupingToString(this.inputSchema.relDataType(), this.groupings)).append("), ").toString() : "")).append("select:(").append(this.aggregationToString(this.inputSchema.relDataType(), this.groupings, this.getRowType(), this.namedAggregates, (Seq<FlinkRelBuilder.NamedWindowProperty>)Nil$.MODULE$)).append("))").toString();
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).itemIf("groupBy", this.groupingToString(this.inputSchema.relDataType(), this.groupings), !new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.groupings)).isEmpty()).item("select", this.aggregationToString(this.inputSchema.relDataType(), this.groupings, this.getRowType(), this.namedAggregates, (Seq<FlinkRelBuilder.NamedWindowProperty>)Nil$.MODULE$));
    }

    @Override
    public DataStream<CRow> translateToPlan(StreamTableEnvironment tableEnv, StreamQueryConfig queryConfig) {
        if (this.groupings.length > 0 && queryConfig.getMinIdleStateRetentionTime() < 0L) {
            this.LOG().warn("No state retention interval configured for a query which accumulates state. Please provide a query configuration with valid retention interval to prevent excessive state size. You may specify a retention time of 0 to not clean up the state.");
        }
        DataStream<CRow> inputDS = ((DataStreamRel)this.input).translateToPlan(tableEnv, queryConfig);
        CRowTypeInfo outRowType = CRowTypeInfo$.MODULE$.apply(this.schema.typeInfo());
        AggregationCodeGenerator generator = new AggregationCodeGenerator(tableEnv.getConfig(), false, this.inputSchema.typeInfo(), (Option<Seq<RexLiteral>>)None$.MODULE$);
        String aggString = this.aggregationToString(this.inputSchema.relDataType(), this.groupings, this.getRowType(), this.namedAggregates, (Seq<FlinkRelBuilder.NamedWindowProperty>)Nil$.MODULE$);
        String keyedAggOpName = new StringBuilder(13).append("groupBy: (").append(this.groupingToString(this.inputSchema.relDataType(), this.groupings)).append("), ").append(new StringBuilder(10).append("select: (").append(aggString).append(")").toString()).toString();
        String nonKeyedAggOpName = new StringBuilder(10).append("select: (").append(aggString).append(")").toString();
        ProcessFunction<CRow, CRow> processFunction = AggregateUtil$.MODULE$.createGroupAggregateFunction(generator, this.namedAggregates, this.inputSchema.relDataType(), this.inputSchema.fieldTypeInfos(), this.groupings, queryConfig, tableEnv.getConfig(), DataStreamRetractionRules$.MODULE$.isAccRetract(this), DataStreamRetractionRules$.MODULE$.isAccRetract(this.getInput()));
        SingleOutputStreamOperator result = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.groupings)).nonEmpty() ? inputDS.keyBy((KeySelector)new CRowKeySelector(this.groupings, this.inputSchema.projectedTypeInfo(this.groupings))).process(processFunction).returns((TypeInformation)outRowType).name(keyedAggOpName) : inputDS.keyBy((KeySelector)new NullByteKeySelector()).process(processFunction).setParallelism(1).setMaxParallelism(1).returns((TypeInformation)outRowType).name(nonKeyedAggOpName);
        return result;
    }

    public DataStreamGroupAggregate(RelOptCluster cluster, RelTraitSet traitSet, RelNode inputNode, Seq<Pair<AggregateCall, String>> namedAggregates, RowSchema schema, RowSchema inputSchema, int[] groupings) {
        this.cluster = cluster;
        this.namedAggregates = namedAggregates;
        this.schema = schema;
        this.inputSchema = inputSchema;
        this.groupings = groupings;
        super(cluster, traitSet, inputNode);
        CommonAggregate.$init$(this);
        FlinkRelNode.$init$(this);
        DataStreamRel.$init$(this);
        Logging.$init$(this);
    }
}

