/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes;

import java.io.Serializable;
import java.util.List;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.table.api.TableException;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4q!\u0001\u0002\u0011\u0002\u0007\u0005qB\u0001\u0007GY&t7NU3m\u001d>$WM\u0003\u0002\u0004\t\u0005)an\u001c3fg*\u0011QAB\u0001\u0005a2\fgN\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\u0001\u0002\u0004\u0005\u0002\u0012-5\t!C\u0003\u0002\u0014)\u0005!A.\u00198h\u0015\u0005)\u0012\u0001\u00026bm\u0006L!a\u0006\n\u0003\r=\u0013'.Z2u!\tIb$D\u0001\u001b\u0015\tYB$A\u0002sK2T!!\b\u0006\u0002\u000f\r\fGnY5uK&\u0011qD\u0007\u0002\b%\u0016dgj\u001c3f\u0011\u0015\t\u0003\u0001\"\u0001#\u0003\u0019!\u0013N\\5uIQ\t1\u0005\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0003V]&$\bB\u0002\u0016\u0001\t\u0003A1&A\nhKR,\u0005\u0010\u001d:fgNLwN\\*ue&tw\r\u0006\u0003-o}R\u0005CA\u00175\u001d\tq#\u0007\u0005\u00020K5\t\u0001G\u0003\u00022\u001d\u00051AH]8pizJ!aM\u0013\u0002\rA\u0013X\rZ3g\u0013\t)dG\u0001\u0004TiJLgn\u001a\u0006\u0003g\u0015BQ\u0001O\u0015A\u0002e\nA!\u001a=qeB\u0011!(P\u0007\u0002w)\u0011A\bH\u0001\u0004e\u0016D\u0018B\u0001 <\u0005\u001d\u0011V\r\u001f(pI\u0016DQ\u0001Q\u0015A\u0002\u0005\u000b\u0001\"\u001b8GS\u0016dGm\u001d\t\u0004\u0005\u001eccBA\"F\u001d\tyC)C\u0001'\u0013\t1U%A\u0004qC\u000e\\\u0017mZ3\n\u0005!K%aA*fc*\u0011a)\n\u0005\u0006\u0017&\u0002\r\u0001T\u0001\u0010Y>\u001c\u0017\r\\#yaJ\u001cH+\u00192mKB\u0019A%T(\n\u00059+#AB(qi&|g\u000eE\u0002C\u000ffBa!\u0015\u0001\u0005\u0002!\u0011\u0016aD3ti&l\u0017\r^3S_^\u001c\u0016N_3\u0015\u0005M3\u0006C\u0001\u0013U\u0013\t)VE\u0001\u0004E_V\u0014G.\u001a\u0005\u0006/B\u0003\r\u0001W\u0001\be><H+\u001f9f!\tIF,D\u0001[\u0015\tY&$\u0001\u0003usB,\u0017BA/[\u0005-\u0011V\r\u001c#bi\u0006$\u0016\u0010]3\t\r}\u0003A\u0011\u0001\u0005a\u0003Q)7\u000f^5nCR,G)\u0019;b)f\u0004XmU5{KR\u00111+\u0019\u0005\u0006Ez\u0003\r\u0001W\u0001\u0002i\u0002")
public interface FlinkRelNode
extends RelNode {
    public static /* synthetic */ String getExpressionString$(FlinkRelNode $this, RexNode expr, Seq inFields, Option localExprsTable) {
        return $this.getExpressionString(expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable);
    }

    default public String getExpressionString(RexNode expr, Seq<String> inFields, Option<Seq<RexNode>> localExprsTable) {
        String string;
        boolean bl = false;
        RexLocalRef rexLocalRef = null;
        RexNode rexNode = expr;
        if (rexNode instanceof RexPatternFieldRef) {
            RexPatternFieldRef rexPatternFieldRef = (RexPatternFieldRef)rexNode;
            String alpha = rexPatternFieldRef.getAlpha();
            String field = (String)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(inFields).get(rexPatternFieldRef.getIndex());
            string = new StringBuilder(1).append(alpha).append(".").append(field).toString();
        } else if (rexNode instanceof RexInputRef) {
            RexInputRef rexInputRef = (RexInputRef)rexNode;
            string = (String)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList(inFields).get(rexInputRef.getIndex());
        } else if (rexNode instanceof RexLiteral) {
            RexLiteral rexLiteral = (RexLiteral)rexNode;
            string = rexLiteral.toString();
        } else {
            if (rexNode instanceof RexLocalRef) {
                bl = true;
                rexLocalRef = (RexLocalRef)rexNode;
                if (localExprsTable.isEmpty()) {
                    throw new IllegalArgumentException("Encountered RexLocalRef without local expression table");
                }
            }
            if (bl) {
                RexNode lExpr = (RexNode)((SeqLike)localExprsTable.get()).apply(rexLocalRef.getIndex());
                string = this.getExpressionString(lExpr, inFields, localExprsTable);
            } else if (rexNode instanceof RexCall) {
                RexCall rexCall = (RexCall)rexNode;
                String op = rexCall.getOperator().toString();
                Buffer ops = (Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(rexCall.getOperands()).map((Function1 & Serializable & scala.Serializable)x$1 -> this.getExpressionString((RexNode)x$1, inFields, localExprsTable), Buffer$.MODULE$.canBuildFrom());
                SqlOperator sqlOperator = rexCall.getOperator();
                String string2 = sqlOperator instanceof SqlAsOperator ? (String)ops.head() : new StringBuilder(2).append(op).append("(").append(ops.mkString(", ")).append(")").toString();
                string = string2;
            } else if (rexNode instanceof RexFieldAccess) {
                RexFieldAccess rexFieldAccess = (RexFieldAccess)rexNode;
                String referenceExpr = this.getExpressionString(rexFieldAccess.getReferenceExpr(), inFields, localExprsTable);
                String field = rexFieldAccess.getField().getName();
                string = new StringBuilder(1).append(referenceExpr).append(".").append(field).toString();
            } else if (rexNode instanceof RexCorrelVariable) {
                RexCorrelVariable rexCorrelVariable = (RexCorrelVariable)rexNode;
                string = rexCorrelVariable.toString();
            } else {
                throw new IllegalArgumentException(new StringBuilder(28).append("Unknown expression type '").append(expr.getClass()).append("': ").append(expr).toString());
            }
        }
        return string;
    }

    public static /* synthetic */ double estimateRowSize$(FlinkRelNode $this, RelDataType rowType) {
        return $this.estimateRowSize(rowType);
    }

    default public double estimateRowSize(RelDataType rowType) {
        List<RelDataTypeField> fieldList = rowType.getFieldList();
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(fieldList).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getType(), Buffer$.MODULE$.canBuildFrom())).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2 & Serializable & scala.Serializable)(s, t) -> BoxesRunTime.boxToDouble((double)FlinkRelNode.$anonfun$estimateRowSize$2(this, BoxesRunTime.unboxToDouble((Object)s), t))));
    }

    public static /* synthetic */ double estimateDataTypeSize$(FlinkRelNode $this, RelDataType t) {
        return $this.estimateDataTypeSize(t);
    }

    default public double estimateDataTypeSize(RelDataType t) {
        double d;
        SqlTypeName sqlTypeName = t.getSqlTypeName();
        if (((Object)((Object)SqlTypeName.TINYINT)).equals((Object)sqlTypeName)) {
            d = 1.0;
        } else if (((Object)((Object)SqlTypeName.SMALLINT)).equals((Object)sqlTypeName)) {
            d = 2.0;
        } else if (((Object)((Object)SqlTypeName.INTEGER)).equals((Object)sqlTypeName)) {
            d = 4.0;
        } else if (((Object)((Object)SqlTypeName.BIGINT)).equals((Object)sqlTypeName)) {
            d = 8.0;
        } else if (((Object)((Object)SqlTypeName.BOOLEAN)).equals((Object)sqlTypeName)) {
            d = 1.0;
        } else if (((Object)((Object)SqlTypeName.FLOAT)).equals((Object)sqlTypeName)) {
            d = 4.0;
        } else if (((Object)((Object)SqlTypeName.DOUBLE)).equals((Object)sqlTypeName)) {
            d = 8.0;
        } else if (((Object)((Object)SqlTypeName.VARCHAR)).equals((Object)sqlTypeName)) {
            d = 12.0;
        } else if (((Object)((Object)SqlTypeName.CHAR)).equals((Object)sqlTypeName)) {
            d = 1.0;
        } else if (((Object)((Object)SqlTypeName.DECIMAL)).equals((Object)sqlTypeName)) {
            d = 12.0;
        } else if (SqlTypeName.YEAR_INTERVAL_TYPES.contains((Object)sqlTypeName)) {
            d = 8.0;
        } else if (SqlTypeName.DAY_INTERVAL_TYPES.contains((Object)sqlTypeName)) {
            d = 4.0;
        } else {
            boolean bl = ((Object)((Object)SqlTypeName.TIME)).equals((Object)sqlTypeName) ? true : (((Object)((Object)SqlTypeName.TIMESTAMP)).equals((Object)sqlTypeName) ? true : ((Object)((Object)SqlTypeName.DATE)).equals((Object)sqlTypeName));
            if (bl) {
                d = 12.0;
            } else if (((Object)((Object)SqlTypeName.ROW)).equals((Object)sqlTypeName)) {
                d = this.estimateRowSize(t);
            } else if (((Object)((Object)SqlTypeName.ARRAY)).equals((Object)sqlTypeName)) {
                d = this.estimateDataTypeSize(t.getComponentType()) * (double)16;
            } else {
                boolean bl2 = ((Object)((Object)SqlTypeName.MAP)).equals((Object)sqlTypeName) ? true : ((Object)((Object)SqlTypeName.MULTISET)).equals((Object)sqlTypeName);
                if (bl2) {
                    d = (this.estimateDataTypeSize(t.getKeyType()) + this.estimateDataTypeSize(t.getValueType())) * (double)16;
                } else if (((Object)((Object)SqlTypeName.ANY)).equals((Object)sqlTypeName)) {
                    d = 128.0;
                } else {
                    throw new TableException(new StringBuilder(35).append("Unsupported data type encountered: ").append(t).toString());
                }
            }
        }
        return d;
    }

    public static /* synthetic */ double $anonfun$estimateRowSize$2(FlinkRelNode $this, double s, RelDataType t) {
        return s + $this.estimateDataTypeSize(t);
    }

    public static void $init$(FlinkRelNode $this) {
    }
}

