/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.flink.table.api.AmbiguousTableFactoryException;
import org.apache.flink.table.api.NoMatchingTableFactoryException;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.descriptors.MetadataValidator$;
import org.apache.flink.table.descriptors.SchemaValidator$;
import org.apache.flink.table.descriptors.StatisticsValidator$;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.factories.TableFormatFactory;
import org.apache.flink.table.util.Logging;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class TableFactoryService$
implements Logging {
    public static TableFactoryService$ MODULE$;
    private ServiceLoader<TableFactory> defaultLoader;
    private transient Logger LOG;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    static {
        new TableFactoryService$();
    }

    private Logger LOG$lzycompute() {
        TableFactoryService$ tableFactoryService$ = this;
        synchronized (tableFactoryService$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private ServiceLoader<TableFactory> defaultLoader$lzycompute() {
        TableFactoryService$ tableFactoryService$ = this;
        synchronized (tableFactoryService$) {
            if (!this.bitmap$0) {
                this.defaultLoader = ServiceLoader.load(TableFactory.class);
                this.bitmap$0 = true;
            }
        }
        return this.defaultLoader;
    }

    private ServiceLoader<TableFactory> defaultLoader() {
        return !this.bitmap$0 ? this.defaultLoader$lzycompute() : this.defaultLoader;
    }

    public <T> T find(Class<T> factoryClass, Descriptor descriptor) {
        Preconditions.checkNotNull((Object)descriptor);
        return this.findInternal(factoryClass, descriptor.toProperties(), (Option<ClassLoader>)None$.MODULE$);
    }

    public <T> T find(Class<T> factoryClass, Descriptor descriptor, ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)descriptor);
        Preconditions.checkNotNull((Object)classLoader);
        return this.findInternal(factoryClass, descriptor.toProperties(), (Option<ClassLoader>)new Some((Object)classLoader));
    }

    public <T> T find(Class<T> factoryClass, Map<String, String> propertyMap) {
        return this.findInternal(factoryClass, propertyMap, (Option<ClassLoader>)None$.MODULE$);
    }

    public <T> T find(Class<T> factoryClass, Map<String, String> propertyMap, ClassLoader classLoader) {
        Preconditions.checkNotNull((Object)classLoader);
        return this.findInternal(factoryClass, propertyMap, (Option<ClassLoader>)new Some((Object)classLoader));
    }

    private <T> T findInternal(Class<T> factoryClass, Map<String, String> propertyMap, Option<ClassLoader> classLoader) {
        Preconditions.checkNotNull(factoryClass);
        Preconditions.checkNotNull(propertyMap);
        scala.collection.immutable.Map properties = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(propertyMap).asScala()).toMap(Predef$.MODULE$.$conforms());
        Seq<TableFactory> foundFactories = this.discoverFactories(classLoader);
        Seq<TableFactory> classFactories = this.filterByFactoryClass(factoryClass, (scala.collection.immutable.Map<String, String>)properties, foundFactories);
        Seq<TableFactory> contextFactories = this.filterByContext(factoryClass, (scala.collection.immutable.Map<String, String>)properties, foundFactories, classFactories);
        return this.filterBySupportedProperties(factoryClass, (scala.collection.immutable.Map<String, String>)properties, foundFactories, contextFactories);
    }

    private <T> Seq<TableFactory> discoverFactories(Option<ClassLoader> classLoader) {
        Seq seq;
        try {
            Iterator<TableFactory> iterator;
            Option<ClassLoader> option = classLoader;
            if (option instanceof Some) {
                Some some = (Some)option;
                ClassLoader customClassLoader = (ClassLoader)some.value();
                ServiceLoader<TableFactory> customLoader = ServiceLoader.load(TableFactory.class, customClassLoader);
                iterator = customLoader.iterator();
            } else if (None$.MODULE$.equals(option)) {
                iterator = this.defaultLoader().iterator();
            } else {
                throw new MatchError(option);
            }
            Iterator<TableFactory> iterator2 = iterator;
            seq = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(iterator2).asScala()).toSeq();
        }
        catch (ServiceConfigurationError e2) {
            this.LOG().error("Could not load service provider for table factories.", (Throwable)e2);
            throw new TableException("Could not load service provider for table factories.", e2);
        }
        return seq;
    }

    private <T> Seq<TableFactory> filterByFactoryClass(Class<T> factoryClass, scala.collection.immutable.Map<String, String> properties, Seq<TableFactory> foundFactories) {
        Seq classFactories = (Seq)foundFactories.filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)factoryClass.isAssignableFrom(f.getClass())));
        if (classFactories.isEmpty()) {
            throw new NoMatchingTableFactoryException(new StringBuilder(25).append("No factory implements '").append(factoryClass.getCanonicalName()).append("'.").toString(), factoryClass, foundFactories, properties);
        }
        return classFactories;
    }

    private <T> Seq<TableFactory> filterByContext(Class<T> factoryClass, scala.collection.immutable.Map<String, String> properties, Seq<TableFactory> foundFactories, Seq<TableFactory> classFactories) {
        Seq matchingFactories = (Seq)classFactories.filter((Function1 & Serializable & scala.Serializable)factory -> BoxesRunTime.boxToBoolean((boolean)TableFactoryService$.$anonfun$filterByContext$1(properties, factory)));
        if (matchingFactories.isEmpty()) {
            throw new NoMatchingTableFactoryException("No context matches.", factoryClass, foundFactories, properties);
        }
        return matchingFactories;
    }

    private scala.collection.immutable.Map<String, String> normalizeContext(TableFactory factory) {
        Map<String, String> requiredContextJava = factory.requiredContext();
        if (requiredContextJava == null) {
            throw new TableException(new StringBuilder(48).append("Required context of factory '").append(factory.getClass().getName()).append("' must not be null.").toString());
        }
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(requiredContextJava).asScala()).map((Function1 & Serializable & scala.Serializable)e2 -> new Tuple2((Object)((String)e2._1()).toLowerCase(), e2._2()), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private <T> T filterBySupportedProperties(Class<T> factoryClass, scala.collection.immutable.Map<String, String> properties, Seq<TableFactory> foundFactories, Seq<TableFactory> classFactories) {
        ArrayBuffer plainGivenKeys = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        properties.keys().foreach((Function1 & Serializable & scala.Serializable)k -> {
            String key = k.replaceAll(".\\d+", ".#");
            return !plainGivenKeys.contains((Object)key) ? plainGivenKeys.$plus$eq((Object)key) : BoxedUnit.UNIT;
        });
        ObjectRef lastKey = ObjectRef.create((Object)None$.MODULE$);
        Seq supportedFactories = (Seq)classFactories.filter((Function1 & Serializable & scala.Serializable)factory -> BoxesRunTime.boxToBoolean((boolean)TableFactoryService$.$anonfun$filterBySupportedProperties$2(plainGivenKeys, lastKey, factory)));
        if (supportedFactories.isEmpty() && classFactories.length() == 1 && ((Option)lastKey.elem).isDefined()) {
            Seq supportedKeys;
            TableFactory factory2 = (TableFactory)classFactories.head();
            Tuple2<Seq<String>, Seq<String>> tuple2 = this.normalizeSupportedProperties(factory2);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq seq = supportedKeys = (Seq)tuple2._1();
            Seq supportedKeys2 = seq;
            throw new NoMatchingTableFactoryException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(132).append("\n          |The matching factory '").append(factory2.getClass().getName()).append("' doesn't support '").append(((Option)lastKey.elem).get()).append("'.\n          |\n          |Supported properties of this factory are:\n          |").append(((TraversableOnce)supportedKeys2.sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).toString())).stripMargin(), factoryClass, foundFactories, properties);
        }
        if (supportedFactories.isEmpty()) {
            throw new NoMatchingTableFactoryException("No factory supports all properties.", factoryClass, foundFactories, properties);
        }
        if (supportedFactories.length() > 1) {
            throw new AmbiguousTableFactoryException((Seq<TableFactory>)supportedFactories, factoryClass, foundFactories, properties);
        }
        return (T)supportedFactories.head();
    }

    private Tuple2<Seq<String>, Seq<String>> normalizeSupportedProperties(TableFactory factory) {
        List<String> supportedPropertiesJava = factory.supportedProperties();
        if (supportedPropertiesJava == null) {
            throw new TableException(new StringBuilder(52).append("Supported properties of factory '").append(factory.getClass().getName()).append("' must not be null.").toString());
        }
        Buffer supportedKeys = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(supportedPropertiesJava).asScala()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toLowerCase(), Buffer$.MODULE$.canBuildFrom());
        Seq<String> wildcards = this.extractWildcardPrefixes((Seq<String>)supportedKeys);
        return new Tuple2((Object)supportedKeys, wildcards);
    }

    private Seq<String> extractWildcardPrefixes(Seq<String> propertyKeys) {
        return (Seq)((TraversableLike)propertyKeys.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.endsWith("*")))).map((Function1 & Serializable & scala.Serializable)s -> s.substring(0, s.length() - 1), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<String> filterSupportedPropertiesFactorySpecific(TableFactory factory, Seq<String> keys) {
        Seq seq;
        TableFactory tableFactory = factory;
        if (tableFactory instanceof TableFormatFactory) {
            TableFormatFactory tableFormatFactory = (TableFormatFactory)tableFactory;
            boolean includeSchema = tableFormatFactory.supportsSchemaDerivation();
            seq = (Seq)keys.filter((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)TableFactoryService$.$anonfun$filterSupportedPropertiesFactorySpecific$1(includeSchema, k)));
        } else {
            seq = keys;
        }
        return seq;
    }

    public static final /* synthetic */ boolean $anonfun$filterByContext$2(scala.collection.immutable.Map properties$1, Tuple2 e2) {
        return properties$1.contains(e2._1()) && BoxesRunTime.equals((Object)properties$1.apply(e2._1()), (Object)e2._2());
    }

    public static final /* synthetic */ boolean $anonfun$filterByContext$1(scala.collection.immutable.Map properties$1, TableFactory factory) {
        scala.collection.immutable.Map<String, String> requestedContext = MODULE$.normalizeContext(factory);
        scala.collection.mutable.Map plainContext = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        plainContext.$plus$plus$eq(requestedContext);
        plainContext.remove((Object)"connector.property-version");
        plainContext.remove((Object)"format.property-version");
        plainContext.remove((Object)MetadataValidator$.MODULE$.METADATA_PROPERTY_VERSION());
        plainContext.remove((Object)StatisticsValidator$.MODULE$.STATISTICS_PROPERTY_VERSION());
        return plainContext.forall((Function1 & Serializable & scala.Serializable)e2 -> BoxesRunTime.boxToBoolean((boolean)TableFactoryService$.$anonfun$filterByContext$2(properties$1, e2)));
    }

    public static final /* synthetic */ boolean $anonfun$filterBySupportedProperties$3(Set requiredContextKeys$1, String x$2) {
        return !requiredContextKeys$1.contains((Object)x$2);
    }

    public static final /* synthetic */ boolean $anonfun$filterBySupportedProperties$4(ObjectRef lastKey$1, Seq supportedKeys$1, Seq wildcards$1, String k) {
        lastKey$1.elem = Option$.MODULE$.apply((Object)k);
        return supportedKeys$1.contains((Object)k) || wildcards$1.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)k.startsWith(x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$filterBySupportedProperties$2(ArrayBuffer plainGivenKeys$1, ObjectRef lastKey$1, TableFactory factory) {
        Set requiredContextKeys = MODULE$.normalizeContext(factory).keySet();
        Tuple2<Seq<String>, Seq<String>> tuple2 = MODULE$.normalizeSupportedProperties(factory);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Seq supportedKeys = (Seq)tuple2._1();
        Seq wildcards = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)supportedKeys, (Object)wildcards);
        Tuple2 tuple23 = tuple22;
        Seq supportedKeys2 = (Seq)tuple23._1();
        Seq wildcards2 = (Seq)tuple23._2();
        ArrayBuffer givenContextFreeKeys = (ArrayBuffer)plainGivenKeys$1.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TableFactoryService$.$anonfun$filterBySupportedProperties$3(requiredContextKeys, x$2)));
        Seq<String> givenFilteredKeys = MODULE$.filterSupportedPropertiesFactorySpecific(factory, (Seq<String>)givenContextFreeKeys);
        return givenFilteredKeys.forall((Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)TableFactoryService$.$anonfun$filterBySupportedProperties$4(lastKey$1, supportedKeys2, wildcards2, k)));
    }

    public static final /* synthetic */ boolean $anonfun$filterSupportedPropertiesFactorySpecific$1(boolean includeSchema$1, String k) {
        return includeSchema$1 ? k.startsWith(new StringBuilder(1).append(SchemaValidator$.MODULE$.SCHEMA()).append(".").toString()) || k.startsWith("format.") : k.startsWith("format.");
    }

    private TableFactoryService$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

