/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.expressions;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.expressions.ArrayConstructor;
import org.apache.flink.table.expressions.Cast;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.Literal;
import org.apache.flink.table.expressions.Literal$;
import org.apache.flink.table.expressions.Mul;
import org.apache.flink.table.expressions.ResolvedFieldReference;
import org.apache.flink.table.typeutils.RowIntervalTypeInfo;
import org.apache.flink.table.typeutils.RowIntervalTypeInfo$;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo;
import org.apache.flink.table.typeutils.TimeIntervalTypeInfo$;
import scala.Array$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ExpressionUtils$ {
    public static ExpressionUtils$ MODULE$;

    static {
        new ExpressionUtils$();
    }

    public TypeInformation<?> getResultType(Expression expr) {
        return expr.resultType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTimeIntervalLiteral(Expression expr) {
        Expression expression = expr;
        if (!(expression instanceof Literal)) return false;
        Literal literal = (Literal)expression;
        TypeInformation<?> typeInformation = literal.resultType();
        TimeIntervalTypeInfo<Long> timeIntervalTypeInfo = TimeIntervalTypeInfo$.MODULE$.INTERVAL_MILLIS();
        TypeInformation<?> typeInformation2 = typeInformation;
        if (timeIntervalTypeInfo != null) {
            if (!((Object)timeIntervalTypeInfo).equals(typeInformation2)) return false;
            return true;
        }
        if (typeInformation2 == null) return true;
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRowCountLiteral(Expression expr) {
        Expression expression = expr;
        if (!(expression instanceof Literal)) return false;
        Literal literal = (Literal)expression;
        TypeInformation<?> typeInformation = literal.resultType();
        RowIntervalTypeInfo rowIntervalTypeInfo = RowIntervalTypeInfo$.MODULE$.INTERVAL_ROWS();
        TypeInformation<?> typeInformation2 = typeInformation;
        if (rowIntervalTypeInfo != null) {
            if (!((Object)((Object)rowIntervalTypeInfo)).equals(typeInformation2)) return false;
            return true;
        }
        if (typeInformation2 == null) return true;
        return false;
    }

    public boolean isTimeAttribute(Expression expr) {
        ResolvedFieldReference resolvedFieldReference;
        Expression expression = expr;
        boolean bl = expression instanceof ResolvedFieldReference && FlinkTypeFactory$.MODULE$.isTimeIndicatorType((resolvedFieldReference = (ResolvedFieldReference)expression).resultType());
        return bl;
    }

    public boolean isRowtimeAttribute(Expression expr) {
        ResolvedFieldReference resolvedFieldReference;
        Expression expression = expr;
        boolean bl = expression instanceof ResolvedFieldReference && FlinkTypeFactory$.MODULE$.isRowtimeIndicatorType((resolvedFieldReference = (ResolvedFieldReference)expression).resultType());
        return bl;
    }

    public boolean isProctimeAttribute(Expression expr) {
        ResolvedFieldReference resolvedFieldReference;
        Expression expression = expr;
        boolean bl = expression instanceof ResolvedFieldReference && FlinkTypeFactory$.MODULE$.isProctimeIndicatorType((resolvedFieldReference = (ResolvedFieldReference)expression).resultType());
        return bl;
    }

    public Time toTime(Expression expr) {
        long l;
        block3: {
            block2: {
                Expression expression = expr;
                if (!(expression instanceof Literal)) break block2;
                Literal literal = (Literal)expression;
                Object value = literal.value();
                TypeInformation<?> typeInformation = literal.resultType();
                if (!(value instanceof Long)) break block2;
                l = BoxesRunTime.unboxToLong((Object)value);
                TimeIntervalTypeInfo<Long> timeIntervalTypeInfo = TimeIntervalTypeInfo$.MODULE$.INTERVAL_MILLIS();
                TypeInformation<?> typeInformation2 = typeInformation;
                if (!(timeIntervalTypeInfo != null ? !((Object)timeIntervalTypeInfo).equals(typeInformation2) : typeInformation2 != null)) break block3;
            }
            throw new IllegalArgumentException();
        }
        Time time = Time.milliseconds((long)l);
        return time;
    }

    public long toLong(Expression expr) {
        long l;
        block3: {
            block2: {
                Expression expression = expr;
                if (!(expression instanceof Literal)) break block2;
                Literal literal = (Literal)expression;
                Object value = literal.value();
                TypeInformation<?> typeInformation = literal.resultType();
                if (!(value instanceof Long)) break block2;
                l = BoxesRunTime.unboxToLong((Object)value);
                RowIntervalTypeInfo rowIntervalTypeInfo = RowIntervalTypeInfo$.MODULE$.INTERVAL_ROWS();
                TypeInformation<?> typeInformation2 = typeInformation;
                if (!(rowIntervalTypeInfo != null ? !((Object)((Object)rowIntervalTypeInfo)).equals(typeInformation2) : typeInformation2 != null)) break block3;
            }
            throw new IllegalArgumentException();
        }
        long l2 = l;
        return l2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Expression toMonthInterval(Expression expr, int multiplier) {
        void var9_11;
        Expression expression = expr;
        if (expression instanceof Literal) {
            Literal literal = (Literal)expression;
            Object value = literal.value();
            TypeInformation<?> typeInformation = literal.resultType();
            if (value instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)value);
                BasicTypeInfo basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
                TypeInformation<?> typeInformation2 = typeInformation;
                if (!(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null)) {
                    Literal literal2 = new Literal(BoxesRunTime.boxToInteger((int)(n * multiplier)), TimeIntervalTypeInfo$.MODULE$.INTERVAL_MONTHS());
                    return var9_11;
                }
            }
        }
        Cast cast = new Cast(new Mul(expr, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)multiplier))), TimeIntervalTypeInfo$.MODULE$.INTERVAL_MONTHS());
        return var9_11;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public Expression toMilliInterval(Expression expr, long multiplier) {
        void var11_13;
        boolean bl = false;
        Literal literal = null;
        Expression expression = expr;
        if (expression instanceof Literal) {
            bl = true;
            literal = (Literal)expression;
            Object value = literal.value();
            TypeInformation<?> typeInformation = literal.resultType();
            if (value instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)value);
                BasicTypeInfo basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
                TypeInformation<?> typeInformation2 = typeInformation;
                if (!(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation2) : typeInformation2 != null)) {
                    Literal literal2 = new Literal(BoxesRunTime.boxToLong((long)((long)n * multiplier)), TimeIntervalTypeInfo$.MODULE$.INTERVAL_MILLIS());
                    return var11_13;
                }
            }
        }
        if (bl) {
            Object value = literal.value();
            TypeInformation<?> typeInformation = literal.resultType();
            if (value instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)value);
                BasicTypeInfo basicTypeInfo = BasicTypeInfo.LONG_TYPE_INFO;
                TypeInformation<?> typeInformation3 = typeInformation;
                if (!(basicTypeInfo != null ? !basicTypeInfo.equals(typeInformation3) : typeInformation3 != null)) {
                    Literal literal3 = new Literal(BoxesRunTime.boxToLong((long)(l * multiplier)), TimeIntervalTypeInfo$.MODULE$.INTERVAL_MILLIS());
                    return var11_13;
                }
            }
        }
        Cast cast = new Cast(new Mul(expr, Literal$.MODULE$.apply(BoxesRunTime.boxToLong((long)multiplier))), TimeIntervalTypeInfo$.MODULE$.INTERVAL_MILLIS());
        return var11_13;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Expression toRowInterval(Expression expr) {
        boolean bl = false;
        Literal literal = null;
        Expression expression = expr;
        if (expression instanceof Literal) {
            bl = true;
            literal = (Literal)expression;
            Object value = literal.value();
            TypeInformation<?> typeInformation = literal.resultType();
            if (value instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)value);
                BasicTypeInfo basicTypeInfo = BasicTypeInfo.INT_TYPE_INFO;
                TypeInformation<?> typeInformation2 = typeInformation;
                if (basicTypeInfo == null) {
                    if (typeInformation2 == null) return new Literal(BoxesRunTime.boxToLong((long)n), RowIntervalTypeInfo$.MODULE$.INTERVAL_ROWS());
                } else if (basicTypeInfo.equals(typeInformation2)) {
                    return new Literal(BoxesRunTime.boxToLong((long)n), RowIntervalTypeInfo$.MODULE$.INTERVAL_ROWS());
                }
            }
        }
        if (!bl) throw new IllegalArgumentException("Invalid value for row interval literal.");
        Object value = literal.value();
        TypeInformation<?> typeInformation = literal.resultType();
        if (!(value instanceof Long)) throw new IllegalArgumentException("Invalid value for row interval literal.");
        long l = BoxesRunTime.unboxToLong((Object)value);
        BasicTypeInfo basicTypeInfo = BasicTypeInfo.LONG_TYPE_INFO;
        TypeInformation<?> typeInformation3 = typeInformation;
        if (basicTypeInfo != null) {
            if (!basicTypeInfo.equals(typeInformation3)) throw new IllegalArgumentException("Invalid value for row interval literal.");
            return new Literal(BoxesRunTime.boxToLong((long)l), RowIntervalTypeInfo$.MODULE$.INTERVAL_ROWS());
        }
        if (typeInformation3 == null) return new Literal(BoxesRunTime.boxToLong((long)l), RowIntervalTypeInfo$.MODULE$.INTERVAL_ROWS());
        throw new IllegalArgumentException("Invalid value for row interval literal.");
    }

    public Expression convertArray(Object array2) {
        Expression expression;
        Object object = array2;
        if (object instanceof boolean[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof byte[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof short[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof int[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof long[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof float[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof double[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof Boolean[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof Byte[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof Short[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof Integer[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof Long[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof Float[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof Double[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof String[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof BigDecimal[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof Date[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof java.sql.Time[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof Timestamp[]) {
            expression = ExpressionUtils$.createArray$1(array2);
        } else if (object instanceof scala.math.BigDecimal[]) {
            scala.math.BigDecimal[] bigDecimalArray = (scala.math.BigDecimal[])object;
            expression = new ArrayConstructor((Seq<Expression>)((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])bigDecimalArray)).map((Function1 & Serializable & scala.Serializable)bd -> Literal$.MODULE$.apply(bd.bigDecimal()), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
        } else {
            if (ScalaRunTime$.MODULE$.array_length(array2) <= 0 || !ScalaRunTime$.MODULE$.isArray(Predef$.MODULE$.genericArrayOps(array2).head(), 1)) {
                throw new ValidationException("Unsupported array type.");
            }
            expression = new ArrayConstructor((Seq<Expression>)((Seq)Predef$.MODULE$.genericArrayOps(array2).map((Function1 & Serializable & scala.Serializable)na -> MODULE$.convertArray(na), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
        }
        return expression;
    }

    private static final Expression createArray$1(Object array$1) {
        return new ArrayConstructor((Seq<Expression>)((Seq)Predef$.MODULE$.genericArrayOps(array$1).map((Function1 & Serializable & scala.Serializable)x$1 -> Literal$.MODULE$.apply(x$1), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()))));
    }

    private ExpressionUtils$() {
        MODULE$ = this;
    }
}

