/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.descriptors;

import java.io.Serializable;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.plan.stats.ColumnStats;
import org.apache.flink.table.util.JavaScalaConversionUtil$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class StatisticsValidator$ {
    public static StatisticsValidator$ MODULE$;
    private final String STATISTICS_PROPERTY_VERSION;
    private final String STATISTICS_ROW_COUNT;
    private final String STATISTICS_COLUMNS;
    private final String NAME;
    private final String DISTINCT_COUNT;
    private final String NULL_COUNT;
    private final String AVG_LENGTH;
    private final String MAX_LENGTH;
    private final String MAX_VALUE;
    private final String MIN_VALUE;

    static {
        new StatisticsValidator$();
    }

    public String STATISTICS_PROPERTY_VERSION() {
        return this.STATISTICS_PROPERTY_VERSION;
    }

    public String STATISTICS_ROW_COUNT() {
        return this.STATISTICS_ROW_COUNT;
    }

    public String STATISTICS_COLUMNS() {
        return this.STATISTICS_COLUMNS;
    }

    public String NAME() {
        return this.NAME;
    }

    public String DISTINCT_COUNT() {
        return this.DISTINCT_COUNT;
    }

    public String NULL_COUNT() {
        return this.NULL_COUNT;
    }

    public String AVG_LENGTH() {
        return this.AVG_LENGTH;
    }

    public String MAX_LENGTH() {
        return this.MAX_LENGTH;
    }

    public String MAX_VALUE() {
        return this.MAX_VALUE;
    }

    public String MIN_VALUE() {
        return this.MIN_VALUE;
    }

    public Map<String, String> normalizeColumnStats(ColumnStats columnStats) {
        HashMap stats = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        Object object = columnStats.ndv() != null ? stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.DISTINCT_COUNT()), (Object)columnStats.ndv().toString())) : BoxedUnit.UNIT;
        Object object2 = columnStats.nullCount() != null ? stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NULL_COUNT()), (Object)columnStats.nullCount().toString())) : BoxedUnit.UNIT;
        Object object3 = columnStats.avgLen() != null ? stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.AVG_LENGTH()), (Object)columnStats.avgLen().toString())) : BoxedUnit.UNIT;
        Object object4 = columnStats.maxLen() != null ? stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MAX_LENGTH()), (Object)columnStats.maxLen().toString())) : BoxedUnit.UNIT;
        Object object5 = columnStats.max() != null ? stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MAX_VALUE()), (Object)columnStats.max().toString())) : BoxedUnit.UNIT;
        Object object6 = columnStats.min() != null ? stats.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.MIN_VALUE()), (Object)columnStats.min().toString())) : BoxedUnit.UNIT;
        return stats.toMap(Predef$.MODULE$.$conforms());
    }

    public void validateColumnStats(DescriptorProperties properties, String key) {
        int columnCount = properties.getIndexedProperty(key, this.NAME()).size();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), columnCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            properties.validateString(new StringBuilder(2).append(key).append(".").append(i).append(".").append(MODULE$.NAME()).toString(), false, 1);
            properties.validateLong(new StringBuilder(2).append(key).append(".").append(i).append(".").append(MODULE$.DISTINCT_COUNT()).toString(), true, 0L);
            properties.validateLong(new StringBuilder(2).append(key).append(".").append(i).append(".").append(MODULE$.NULL_COUNT()).toString(), true, 0L);
            properties.validateDouble(new StringBuilder(2).append(key).append(".").append(i).append(".").append(MODULE$.AVG_LENGTH()).toString(), true, 0.0);
            properties.validateInt(new StringBuilder(2).append(key).append(".").append(i).append(".").append(MODULE$.MAX_LENGTH()).toString(), true, 0);
            properties.validateDouble(new StringBuilder(2).append(key).append(".").append(i).append(".").append(MODULE$.MAX_VALUE()).toString(), true, 0.0);
            properties.validateDouble(new StringBuilder(2).append(key).append(".").append(i).append(".").append(MODULE$.MIN_VALUE()).toString(), true, 0.0);
        });
    }

    public Map<String, ColumnStats> readColumnStats(DescriptorProperties properties, String key) {
        int columnCount = properties.getIndexedProperty(key, this.NAME()).size();
        IndexedSeq stats = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), columnCount).map((Function1 & Serializable & scala.Serializable)i -> StatisticsValidator$.$anonfun$readColumnStats$1(properties, key, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        return stats.toMap(Predef$.MODULE$.$conforms());
    }

    public static final /* synthetic */ Tuple2 $anonfun$readColumnStats$1(DescriptorProperties properties$1, String key$1, int i) {
        String name = (String)JavaScalaConversionUtil$.MODULE$.toScala(properties$1.getOptionalString(new StringBuilder(2).append(key$1).append(".").append(i).append(".").append(MODULE$.NAME()).toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new ValidationException(new StringBuilder(37).append("Could not find name of property '").append(key$1).append(".").append(i).append(".").append(MODULE$.NAME()).append("'.").toString());
        });
        ColumnStats stats = new ColumnStats(properties$1.getOptionalLong(new StringBuilder(2).append(key$1).append(".").append(i).append(".").append(MODULE$.DISTINCT_COUNT()).toString()).orElse(null), properties$1.getOptionalLong(new StringBuilder(2).append(key$1).append(".").append(i).append(".").append(MODULE$.NULL_COUNT()).toString()).orElse(null), properties$1.getOptionalDouble(new StringBuilder(2).append(key$1).append(".").append(i).append(".").append(MODULE$.AVG_LENGTH()).toString()).orElse(null), properties$1.getOptionalInt(new StringBuilder(2).append(key$1).append(".").append(i).append(".").append(MODULE$.MAX_LENGTH()).toString()).orElse(null), properties$1.getOptionalDouble(new StringBuilder(2).append(key$1).append(".").append(i).append(".").append(MODULE$.MAX_VALUE()).toString()).orElse(null), properties$1.getOptionalDouble(new StringBuilder(2).append(key$1).append(".").append(i).append(".").append(MODULE$.MIN_VALUE()).toString()).orElse(null));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)stats);
    }

    private StatisticsValidator$() {
        MODULE$ = this;
        this.STATISTICS_PROPERTY_VERSION = "statistics.property-version";
        this.STATISTICS_ROW_COUNT = "statistics.row-count";
        this.STATISTICS_COLUMNS = "statistics.columns";
        this.NAME = "name";
        this.DISTINCT_COUNT = "distinct-count";
        this.NULL_COUNT = "null-count";
        this.AVG_LENGTH = "avg-length";
        this.MAX_LENGTH = "max-length";
        this.MAX_VALUE = "max-value";
        this.MIN_VALUE = "min-value";
    }
}

