/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataview;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.api.common.typeutils.CompositeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.api.dataview.MapView;
import org.apache.flink.table.dataview.MapViewSerializer;
import org.apache.flink.util.Preconditions;

public class MapViewSerializerSnapshot<K, V>
implements TypeSerializerSnapshot<MapView<K, V>> {
    private static final int CURRENT_VERSION = 1;
    private CompositeSerializerSnapshot nestedMapSerializerSnapshot;

    public MapViewSerializerSnapshot() {
    }

    public MapViewSerializerSnapshot(TypeSerializer<Map<K, V>> mapSerializer) {
        this.nestedMapSerializerSnapshot = new CompositeSerializerSnapshot(new TypeSerializer[]{(TypeSerializer)Preconditions.checkNotNull(mapSerializer)});
    }

    public int getCurrentVersion() {
        return 1;
    }

    public TypeSerializer<MapView<K, V>> restoreSerializer() {
        return new MapViewSerializer(this.nestedMapSerializerSnapshot.getRestoreSerializer(0));
    }

    public TypeSerializerSchemaCompatibility<MapView<K, V>> resolveSchemaCompatibility(TypeSerializer<MapView<K, V>> newSerializer) {
        Preconditions.checkState((this.nestedMapSerializerSnapshot != null ? 1 : 0) != 0);
        if (newSerializer instanceof MapViewSerializer) {
            MapViewSerializer serializer = (MapViewSerializer)newSerializer;
            return this.nestedMapSerializerSnapshot.resolveCompatibilityWithNested(TypeSerializerSchemaCompatibility.compatibleAsIs(), new TypeSerializer[]{serializer.getMapSerializer()});
        }
        return TypeSerializerSchemaCompatibility.incompatible();
    }

    public void writeSnapshot(DataOutputView out) throws IOException {
        this.nestedMapSerializerSnapshot.writeCompositeSnapshot(out);
    }

    public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        this.nestedMapSerializerSnapshot = CompositeSerializerSnapshot.readCompositeSnapshot((DataInputView)in, (ClassLoader)userCodeClassLoader);
    }
}

