/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway;

import org.apache.flink.api.common.JobID;

public class ProgramTargetDescriptor {
    private final String clusterId;
    private final String jobId;
    private final String webInterfaceUrl;

    public ProgramTargetDescriptor(String clusterId, String jobId, String webInterfaceUrl) {
        this.clusterId = clusterId;
        this.jobId = jobId;
        this.webInterfaceUrl = webInterfaceUrl;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getWebInterfaceUrl() {
        return this.webInterfaceUrl;
    }

    public String toString() {
        return String.format("Cluster ID: %s\nJob ID: %s\nWeb interface: %s", this.clusterId, this.jobId, this.webInterfaceUrl);
    }

    public static <C> ProgramTargetDescriptor of(C clusterId, JobID jobId, String webInterfaceUrl) {
        String clusterIdString;
        try {
            clusterId.getClass().getDeclaredMethod("toString", new Class[0]);
            clusterIdString = clusterId.toString();
        }
        catch (NoSuchMethodException e2) {
            clusterIdString = clusterId.getClass().getSimpleName();
        }
        return new ProgramTargetDescriptor(clusterIdString, jobId.toString(), webInterfaceUrl);
    }
}

