/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.config.entries;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.table.client.config.ConfigUtil;
import org.apache.flink.table.client.config.entries.ConfigEntry;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FunctionDescriptor;
import org.apache.flink.table.descriptors.FunctionDescriptorValidator;

public class FunctionEntry
extends ConfigEntry {
    public static final String FUNCTIONS_NAME = "name";
    private String name;

    private FunctionEntry(String name, DescriptorProperties properties) {
        super(properties);
        this.name = name;
    }

    @Override
    protected void validate(DescriptorProperties properties) {
        new FunctionDescriptorValidator().validate(properties);
    }

    public String getName() {
        return this.name;
    }

    public FunctionDescriptor getDescriptor() {
        return new FunctionEntryDescriptor();
    }

    public static FunctionEntry create(Map<String, Object> config) {
        return FunctionEntry.create(ConfigUtil.normalizeYaml(config));
    }

    private static FunctionEntry create(DescriptorProperties properties) {
        properties.validateString(FUNCTIONS_NAME, false, 1);
        String name = properties.getString(FUNCTIONS_NAME);
        DescriptorProperties cleanedProperties = properties.withoutKeys(Collections.singletonList(FUNCTIONS_NAME));
        return new FunctionEntry(name, cleanedProperties);
    }

    private class FunctionEntryDescriptor
    extends FunctionDescriptor {
        private FunctionEntryDescriptor() {
        }

        @Override
        public Map<String, String> toProperties() {
            return FunctionEntry.this.properties.asMap();
        }
    }
}

