/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.config;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.config.ConfigUtil;
import org.apache.flink.table.client.config.entries.DeploymentEntry;
import org.apache.flink.table.client.config.entries.ExecutionEntry;
import org.apache.flink.table.client.config.entries.FunctionEntry;
import org.apache.flink.table.client.config.entries.TableEntry;
import org.apache.flink.table.client.config.entries.ViewEntry;

public class Environment {
    public static final String EXECUTION_ENTRY = "execution";
    public static final String DEPLOYMENT_ENTRY = "deployment";
    private Map<String, TableEntry> tables = Collections.emptyMap();
    private Map<String, FunctionEntry> functions = Collections.emptyMap();
    private ExecutionEntry execution = ExecutionEntry.DEFAULT_INSTANCE;
    private DeploymentEntry deployment = DeploymentEntry.DEFAULT_INSTANCE;

    public Map<String, TableEntry> getTables() {
        return this.tables;
    }

    public void setTables(List<Map<String, Object>> tables) {
        this.tables = new LinkedHashMap<String, TableEntry>(tables.size());
        tables.forEach(config -> {
            TableEntry table = TableEntry.create(config);
            if (this.tables.containsKey(table.getName())) {
                throw new SqlClientException("Cannot create table '" + table.getName() + "' because a table with this name is already registered.");
            }
            this.tables.put(table.getName(), table);
        });
    }

    public Map<String, FunctionEntry> getFunctions() {
        return this.functions;
    }

    public void setFunctions(List<Map<String, Object>> functions) {
        this.functions = new HashMap<String, FunctionEntry>(functions.size());
        functions.forEach(config -> {
            FunctionEntry function = FunctionEntry.create(config);
            if (this.functions.containsKey(function.getName())) {
                throw new SqlClientException("Cannot create function '" + function.getName() + "' because a function with this name is already registered.");
            }
            this.functions.put(function.getName(), function);
        });
    }

    public void setExecution(Map<String, Object> config) {
        this.execution = ExecutionEntry.create(config);
    }

    public ExecutionEntry getExecution() {
        return this.execution;
    }

    public void setDeployment(Map<String, Object> config) {
        this.deployment = DeploymentEntry.create(config);
    }

    public DeploymentEntry getDeployment() {
        return this.deployment;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("===================== Tables =====================\n");
        this.tables.forEach((name, table) -> {
            sb.append("- ").append("name").append(": ").append((String)name).append("\n");
            table.asMap().forEach((k, v) -> sb.append("  ").append((String)k).append(": ").append((String)v).append('\n'));
        });
        sb.append("=================== Functions ====================\n");
        this.functions.forEach((name, function) -> {
            sb.append("- ").append("name").append(": ").append((String)name).append("\n");
            function.asMap().forEach((k, v) -> sb.append("  ").append((String)k).append(": ").append((String)v).append('\n'));
        });
        sb.append("=================== Execution ====================\n");
        this.execution.asTopLevelMap().forEach((k, v) -> sb.append((String)k).append(": ").append((String)v).append('\n'));
        sb.append("=================== Deployment ===================\n");
        this.deployment.asTopLevelMap().forEach((k, v) -> sb.append((String)k).append(": ").append((String)v).append('\n'));
        return sb.toString();
    }

    public static Environment parse(URL url) throws IOException {
        try {
            return (Environment)new ConfigUtil.LowerCaseYamlMapper().readValue(url, Environment.class);
        }
        catch (JsonMappingException e2) {
            throw new SqlClientException("Could not parse environment file. Cause: " + e2.getMessage());
        }
    }

    public static Environment parse(String content) throws IOException {
        try {
            return (Environment)new ConfigUtil.LowerCaseYamlMapper().readValue(content, Environment.class);
        }
        catch (JsonMappingException e2) {
            throw new SqlClientException("Could not parse environment file. Cause: " + e2.getMessage());
        }
    }

    public static Environment merge(Environment env1, Environment env2) {
        Environment mergedEnv = new Environment();
        LinkedHashMap<String, TableEntry> tables = new LinkedHashMap<String, TableEntry>(env1.getTables());
        tables.putAll(env2.getTables());
        mergedEnv.tables = tables;
        HashMap<String, FunctionEntry> functions = new HashMap<String, FunctionEntry>(env1.getFunctions());
        functions.putAll(env2.getFunctions());
        mergedEnv.functions = functions;
        mergedEnv.execution = ExecutionEntry.merge(env1.getExecution(), env2.getExecution());
        mergedEnv.deployment = DeploymentEntry.merge(env1.getDeployment(), env2.getDeployment());
        return mergedEnv;
    }

    public static Environment enrich(Environment env, Map<String, String> properties, Map<String, ViewEntry> views) {
        Environment enrichedEnv = new Environment();
        enrichedEnv.tables = new LinkedHashMap<String, TableEntry>(env.getTables());
        enrichedEnv.tables.putAll(views);
        enrichedEnv.functions = new HashMap<String, FunctionEntry>(env.getFunctions());
        enrichedEnv.execution = ExecutionEntry.enrich(env.execution, properties);
        enrichedEnv.deployment = DeploymentEntry.enrich(env.deployment, properties);
        return enrichedEnv;
    }
}

