/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.util.List;
import org.apache.flink.table.client.cli.SqlCommandParser;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.client.gateway.SessionContext;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;
import org.jline.utils.AttributedString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlCompleter
implements Completer {
    private static final Logger LOG = LoggerFactory.getLogger(SqlCompleter.class);
    public static final String[] COMMAND_HINTS = SqlCompleter.getCommandHints();
    private SessionContext context;
    private Executor executor;

    public SqlCompleter(SessionContext context, Executor executor) {
        this.context = context;
        this.executor = executor;
    }

    @Override
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        String statement = line.line();
        if (statement.endsWith(";")) {
            statement = statement.substring(0, statement.length() - 1);
        }
        String statementNormalized = statement.toUpperCase().trim();
        for (String commandHint : COMMAND_HINTS) {
            if (!commandHint.startsWith(statementNormalized) || line.cursor() >= commandHint.length()) continue;
            candidates.add(this.createCandidate(commandHint));
        }
        try {
            this.executor.completeStatement(this.context, statement, line.cursor()).forEach(hint -> candidates.add(this.createCandidate((String)hint)));
        }
        catch (SqlExecutionException e2) {
            LOG.debug("Could not complete statement at " + line.cursor() + ":" + statement, (Throwable)e2);
        }
    }

    private Candidate createCandidate(String hint) {
        return new Candidate(AttributedString.stripAnsi(hint), hint, null, null, null, null, true);
    }

    private static String[] getCommandHints() {
        SqlCommandParser.SqlCommand[] commands = SqlCommandParser.SqlCommand.values();
        String[] hints = new String[commands.length];
        for (int i = 0; i < commands.length; ++i) {
            SqlCommandParser.SqlCommand command = commands[i];
            hints[i] = command.hasOperands() ? command.toString() : command.toString() + ";";
        }
        return hints;
    }
}

