/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.operator;

import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.api.java.functions.NullByteKeySelector;
import org.apache.flink.cep.EventComparator;
import org.apache.flink.cep.PatternFlatSelectFunction;
import org.apache.flink.cep.PatternFlatTimeoutFunction;
import org.apache.flink.cep.PatternSelectFunction;
import org.apache.flink.cep.PatternTimeoutFunction;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.nfa.compiler.NFACompiler;
import org.apache.flink.cep.operator.FlatSelectCepOperator;
import org.apache.flink.cep.operator.FlatSelectTimeoutCepOperator;
import org.apache.flink.cep.operator.SelectCepOperator;
import org.apache.flink.cep.operator.SelectTimeoutCepOperator;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.KeyedStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.util.OutputTag;

public class CEPOperatorUtils {
    public static <IN, OUT> SingleOutputStreamOperator<OUT> createPatternStream(DataStream<IN> inputStream, Pattern<IN, ?> pattern, EventComparator<IN> comparator, final PatternSelectFunction<IN, OUT> selectFunction, TypeInformation<OUT> outTypeInfo, final OutputTag<IN> lateDataOutputTag) {
        return CEPOperatorUtils.createPatternStream(inputStream, pattern, outTypeInfo, false, comparator, new OperatorBuilder<IN, OUT>(){

            @Override
            public OneInputStreamOperator<IN, OUT> build(TypeSerializer<IN> inputSerializer, boolean isProcessingTime, NFACompiler.NFAFactory<IN> nfaFactory, EventComparator<IN> comparator, AfterMatchSkipStrategy skipStrategy) {
                return new SelectCepOperator(inputSerializer, isProcessingTime, nfaFactory, comparator, skipStrategy, selectFunction, lateDataOutputTag);
            }

            @Override
            public String getKeyedOperatorName() {
                return "SelectCepOperator";
            }

            @Override
            public String getOperatorName() {
                return "GlobalSelectCepOperator";
            }
        });
    }

    public static <IN, OUT> SingleOutputStreamOperator<OUT> createPatternStream(DataStream<IN> inputStream, Pattern<IN, ?> pattern, EventComparator<IN> comparator, final PatternFlatSelectFunction<IN, OUT> selectFunction, TypeInformation<OUT> outTypeInfo, final OutputTag<IN> lateDataOutputTag) {
        return CEPOperatorUtils.createPatternStream(inputStream, pattern, outTypeInfo, false, comparator, new OperatorBuilder<IN, OUT>(){

            @Override
            public OneInputStreamOperator<IN, OUT> build(TypeSerializer<IN> inputSerializer, boolean isProcessingTime, NFACompiler.NFAFactory<IN> nfaFactory, EventComparator<IN> comparator, AfterMatchSkipStrategy skipStrategy) {
                return new FlatSelectCepOperator(inputSerializer, isProcessingTime, nfaFactory, comparator, skipStrategy, selectFunction, lateDataOutputTag);
            }

            @Override
            public String getKeyedOperatorName() {
                return "FlatSelectCepOperator";
            }

            @Override
            public String getOperatorName() {
                return "GlobalFlatSelectCepOperator";
            }
        });
    }

    public static <IN, OUT1, OUT2> SingleOutputStreamOperator<OUT1> createTimeoutPatternStream(DataStream<IN> inputStream, Pattern<IN, ?> pattern, EventComparator<IN> comparator, final PatternFlatSelectFunction<IN, OUT1> selectFunction, TypeInformation<OUT1> outTypeInfo, final OutputTag<OUT2> outputTag, final PatternFlatTimeoutFunction<IN, OUT2> timeoutFunction, final OutputTag<IN> lateDataOutputTag) {
        return CEPOperatorUtils.createPatternStream(inputStream, pattern, outTypeInfo, true, comparator, new OperatorBuilder<IN, OUT1>(){

            @Override
            public OneInputStreamOperator<IN, OUT1> build(TypeSerializer<IN> inputSerializer, boolean isProcessingTime, NFACompiler.NFAFactory<IN> nfaFactory, EventComparator<IN> comparator, AfterMatchSkipStrategy skipStrategy) {
                return new FlatSelectTimeoutCepOperator(inputSerializer, isProcessingTime, nfaFactory, comparator, skipStrategy, selectFunction, timeoutFunction, outputTag, lateDataOutputTag);
            }

            @Override
            public String getKeyedOperatorName() {
                return "FlatSelectTimeoutCepOperator";
            }

            @Override
            public String getOperatorName() {
                return "GlobalFlatSelectTimeoutCepOperator";
            }
        });
    }

    public static <IN, OUT1, OUT2> SingleOutputStreamOperator<OUT1> createTimeoutPatternStream(DataStream<IN> inputStream, Pattern<IN, ?> pattern, EventComparator<IN> comparator, final PatternSelectFunction<IN, OUT1> selectFunction, TypeInformation<OUT1> outTypeInfo, final OutputTag<OUT2> outputTag, final PatternTimeoutFunction<IN, OUT2> timeoutFunction, final OutputTag<IN> lateDataOutputTag) {
        return CEPOperatorUtils.createPatternStream(inputStream, pattern, outTypeInfo, true, comparator, new OperatorBuilder<IN, OUT1>(){

            @Override
            public OneInputStreamOperator<IN, OUT1> build(TypeSerializer<IN> inputSerializer, boolean isProcessingTime, NFACompiler.NFAFactory<IN> nfaFactory, EventComparator<IN> comparator, AfterMatchSkipStrategy skipStrategy) {
                return new SelectTimeoutCepOperator(inputSerializer, isProcessingTime, nfaFactory, comparator, skipStrategy, selectFunction, timeoutFunction, outputTag, lateDataOutputTag);
            }

            @Override
            public String getKeyedOperatorName() {
                return "SelectTimeoutCepOperator";
            }

            @Override
            public String getOperatorName() {
                return "GlobalSelectTimeoutCepOperator";
            }
        });
    }

    private static <IN, OUT, K> SingleOutputStreamOperator<OUT> createPatternStream(DataStream<IN> inputStream, Pattern<IN, ?> pattern, TypeInformation<OUT> outTypeInfo, boolean timeoutHandling, EventComparator<IN> comparator, OperatorBuilder<IN, OUT> operatorBuilder) {
        SingleOutputStreamOperator patternStream;
        TypeSerializer inputSerializer = inputStream.getType().createSerializer(inputStream.getExecutionConfig());
        boolean isProcessingTime = inputStream.getExecutionEnvironment().getStreamTimeCharacteristic() == TimeCharacteristic.ProcessingTime;
        NFACompiler.NFAFactory<IN> nfaFactory = NFACompiler.compileFactory(pattern, timeoutHandling);
        if (inputStream instanceof KeyedStream) {
            KeyedStream keyedStream = (KeyedStream)inputStream;
            patternStream = keyedStream.transform(operatorBuilder.getKeyedOperatorName(), outTypeInfo, operatorBuilder.build(inputSerializer, isProcessingTime, nfaFactory, comparator, pattern.getAfterMatchSkipStrategy()));
        } else {
            NullByteKeySelector keySelector = new NullByteKeySelector();
            patternStream = inputStream.keyBy((KeySelector)keySelector).transform(operatorBuilder.getOperatorName(), outTypeInfo, operatorBuilder.build(inputSerializer, isProcessingTime, nfaFactory, comparator, pattern.getAfterMatchSkipStrategy())).forceNonParallel();
        }
        return patternStream;
    }

    private static interface OperatorBuilder<IN, OUT> {
        public OneInputStreamOperator<IN, OUT> build(TypeSerializer<IN> var1, boolean var2, NFACompiler.NFAFactory<IN> var3, EventComparator<IN> var4, AfterMatchSkipStrategy var5);

        public String getKeyedOperatorName();

        public String getOperatorName();
    }
}

