/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.sharedbuffer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.cep.nfa.sharedbuffer.SharedBufferEdge;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class SharedBufferNode {
    private final List<SharedBufferEdge> edges;

    public SharedBufferNode() {
        this.edges = new ArrayList<SharedBufferEdge>();
    }

    private SharedBufferNode(List<SharedBufferEdge> edges) {
        this.edges = edges;
    }

    public List<SharedBufferEdge> getEdges() {
        return this.edges;
    }

    public void addEdge(SharedBufferEdge edge) {
        this.edges.add(edge);
    }

    public String toString() {
        return "SharedBufferNode{edges=" + this.edges + '}';
    }

    public static class SharedBufferNodeSerializer
    extends TypeSerializerSingleton<SharedBufferNode> {
        private static final long serialVersionUID = -6687780732295439832L;
        private final ListSerializer<SharedBufferEdge> edgesSerializer = new ListSerializer((TypeSerializer)SharedBufferEdge.SharedBufferEdgeSerializer.INSTANCE);

        public boolean isImmutableType() {
            return false;
        }

        public SharedBufferNode createInstance() {
            return new SharedBufferNode(new ArrayList());
        }

        public SharedBufferNode copy(SharedBufferNode from) {
            return new SharedBufferNode(this.edgesSerializer.copy(from.edges));
        }

        public SharedBufferNode copy(SharedBufferNode from, SharedBufferNode reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return -1;
        }

        public void serialize(SharedBufferNode record, DataOutputView target) throws IOException {
            this.edgesSerializer.serialize(record.edges, target);
        }

        public SharedBufferNode deserialize(DataInputView source) throws IOException {
            List edges = this.edgesSerializer.deserialize(source);
            return new SharedBufferNode(edges);
        }

        public SharedBufferNode deserialize(SharedBufferNode reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            this.edgesSerializer.copy(source, target);
        }

        public boolean canEqual(Object obj) {
            return obj.getClass().equals(SharedBufferNodeSerializer.class);
        }
    }
}

