/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.sharedbuffer;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.sharedbuffer.NodeId;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class SharedBufferEdge {
    private final NodeId target;
    private final DeweyNumber deweyNumber;

    public SharedBufferEdge(NodeId target, DeweyNumber deweyNumber) {
        this.target = target;
        this.deweyNumber = deweyNumber;
    }

    NodeId getTarget() {
        return this.target;
    }

    DeweyNumber getDeweyNumber() {
        return this.deweyNumber;
    }

    public String toString() {
        return "SharedBufferEdge{target=" + this.target + ", deweyNumber=" + this.deweyNumber + '}';
    }

    public static class SharedBufferEdgeSerializer
    extends TypeSerializerSingleton<SharedBufferEdge> {
        private static final long serialVersionUID = -5122474955050663979L;
        static final SharedBufferEdgeSerializer INSTANCE = new SharedBufferEdgeSerializer();

        private SharedBufferEdgeSerializer() {
        }

        public boolean isImmutableType() {
            return true;
        }

        public SharedBufferEdge createInstance() {
            return null;
        }

        public SharedBufferEdge copy(SharedBufferEdge from) {
            return new SharedBufferEdge(from.target, from.deweyNumber);
        }

        public SharedBufferEdge copy(SharedBufferEdge from, SharedBufferEdge reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return -1;
        }

        public void serialize(SharedBufferEdge record, DataOutputView target) throws IOException {
            NodeId.NodeIdSerializer.INSTANCE.serialize(record.target, target);
            DeweyNumber.DeweyNumberSerializer.INSTANCE.serialize(record.deweyNumber, target);
        }

        public SharedBufferEdge deserialize(DataInputView source) throws IOException {
            NodeId target = NodeId.NodeIdSerializer.INSTANCE.deserialize(source);
            DeweyNumber deweyNumber = DeweyNumber.DeweyNumberSerializer.INSTANCE.deserialize(source);
            return new SharedBufferEdge(target, deweyNumber);
        }

        public SharedBufferEdge deserialize(SharedBufferEdge reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            NodeId.NodeIdSerializer.INSTANCE.copy(source, target);
            DeweyNumber.DeweyNumberSerializer.INSTANCE.copy(source, target);
        }

        public boolean canEqual(Object obj) {
            return obj.getClass().equals(SharedBufferEdgeSerializer.class);
        }
    }
}

