/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa.sharedbuffer;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;

public class NodeId {
    private final String pageName;
    private final EventId eventId;

    public NodeId(EventId eventId, String pageName) {
        this.eventId = eventId;
        this.pageName = pageName;
    }

    public EventId getEventId() {
        return this.eventId;
    }

    public String getPageName() {
        return this.pageName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeId nodeId = (NodeId)o;
        return Objects.equals(this.eventId, nodeId.eventId) && Objects.equals(this.pageName, nodeId.pageName);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.pageName);
    }

    public String toString() {
        return "NodeId{eventId=" + this.eventId + ", pageName='" + this.pageName + '\'' + '}';
    }

    public static class NodeIdSerializer
    extends TypeSerializerSingleton<NodeId> {
        private static final long serialVersionUID = 9209498028181378582L;
        public static final NodeIdSerializer INSTANCE = new NodeIdSerializer();

        private NodeIdSerializer() {
        }

        public boolean isImmutableType() {
            return true;
        }

        public NodeId createInstance() {
            return null;
        }

        public NodeId copy(NodeId from) {
            return new NodeId(from.eventId, from.pageName);
        }

        public NodeId copy(NodeId from, NodeId reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return -1;
        }

        public void serialize(NodeId record, DataOutputView target) throws IOException {
            if (record != null) {
                target.writeByte(1);
                EventId.EventIdSerializer.INSTANCE.serialize(record.eventId, target);
                StringSerializer.INSTANCE.serialize(record.pageName, target);
            } else {
                target.writeByte(0);
            }
        }

        public NodeId deserialize(DataInputView source) throws IOException {
            byte b = source.readByte();
            if (b == 0) {
                return null;
            }
            EventId eventId = EventId.EventIdSerializer.INSTANCE.deserialize(source);
            String pageName = StringSerializer.INSTANCE.deserialize(source);
            return new NodeId(eventId, pageName);
        }

        public NodeId deserialize(NodeId reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            target.writeByte((int)source.readByte());
            LongSerializer.INSTANCE.copy(source, target);
            LongSerializer.INSTANCE.copy(source, target);
            StringSerializer.INSTANCE.copy(source, target);
        }

        public boolean canEqual(Object obj) {
            return obj.getClass().equals(NodeIdSerializer.class);
        }
    }
}

