/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.nfa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.common.typeutils.base.TypeSerializerSingleton;
import org.apache.flink.cep.nfa.ComputationState;
import org.apache.flink.cep.nfa.DeweyNumber;
import org.apache.flink.cep.nfa.NFAState;
import org.apache.flink.cep.nfa.sharedbuffer.EventId;
import org.apache.flink.cep.nfa.sharedbuffer.NodeId;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;

public class NFAStateSerializer
extends TypeSerializerSingleton<NFAState> {
    private static final long serialVersionUID = 2098282423980597010L;
    public static final NFAStateSerializer INSTANCE = new NFAStateSerializer();
    private static final StringSerializer STATE_NAME_SERIALIZER = StringSerializer.INSTANCE;
    private static final LongSerializer TIMESTAMP_SERIALIZER = LongSerializer.INSTANCE;
    private static final DeweyNumber.DeweyNumberSerializer VERSION_SERIALIZER = DeweyNumber.DeweyNumberSerializer.INSTANCE;
    private static final NodeId.NodeIdSerializer NODE_ID_SERIALIZER = NodeId.NodeIdSerializer.INSTANCE;
    private static final EventId.EventIdSerializer EVENT_ID_SERIALIZER = EventId.EventIdSerializer.INSTANCE;

    private NFAStateSerializer() {
    }

    public boolean isImmutableType() {
        return false;
    }

    public NFAStateSerializer duplicate() {
        return new NFAStateSerializer();
    }

    public NFAState createInstance() {
        return null;
    }

    public NFAState copy(NFAState from) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.serialize(from, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)baos));
            baos.close();
            byte[] data = baos.toByteArray();
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            NFAState copy = this.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)bais));
            bais.close();
            return copy;
        }
        catch (IOException e2) {
            throw new RuntimeException("Could not copy NFA.", e2);
        }
    }

    public NFAState copy(NFAState from, NFAState reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(NFAState record, DataOutputView target) throws IOException {
        this.serializeComputationStates(record.getPartialMatches(), target);
        this.serializeComputationStates(record.getCompletedMatches(), target);
    }

    private void serializeComputationStates(Queue<ComputationState> states, DataOutputView target) throws IOException {
        target.writeInt(states.size());
        for (ComputationState computationState : states) {
            STATE_NAME_SERIALIZER.serialize(computationState.getCurrentStateName(), target);
            NODE_ID_SERIALIZER.serialize(computationState.getPreviousBufferEntry(), target);
            VERSION_SERIALIZER.serialize(computationState.getVersion(), target);
            TIMESTAMP_SERIALIZER.serialize(Long.valueOf(computationState.getStartTimestamp()), target);
            if (computationState.getStartEventID() != null) {
                target.writeByte(1);
                EVENT_ID_SERIALIZER.serialize(computationState.getStartEventID(), target);
                continue;
            }
            target.writeByte(0);
        }
    }

    public NFAState deserialize(DataInputView source) throws IOException {
        PriorityQueue<ComputationState> partialMatches = this.deserializeComputationStates(source);
        PriorityQueue<ComputationState> completedMatches = this.deserializeComputationStates(source);
        return new NFAState(partialMatches, completedMatches);
    }

    private PriorityQueue<ComputationState> deserializeComputationStates(DataInputView source) throws IOException {
        PriorityQueue<ComputationState> computationStates = new PriorityQueue<ComputationState>(NFAState.COMPUTATION_STATE_COMPARATOR);
        int computationStateNo = source.readInt();
        for (int i = 0; i < computationStateNo; ++i) {
            String state = STATE_NAME_SERIALIZER.deserialize(source);
            NodeId prevState = NODE_ID_SERIALIZER.deserialize(source);
            DeweyNumber version = VERSION_SERIALIZER.deserialize(source);
            long startTimestamp = TIMESTAMP_SERIALIZER.deserialize(source);
            byte isNull = source.readByte();
            EventId startEventId = null;
            if (isNull == 1) {
                startEventId = EVENT_ID_SERIALIZER.deserialize(source);
            }
            computationStates.add(ComputationState.createState(state, prevState, version, startTimestamp, startEventId));
        }
        return computationStates;
    }

    public NFAState deserialize(NFAState reuse, DataInputView source) throws IOException {
        return this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.copyStates(source, target);
        this.copyStates(source, target);
    }

    private void copyStates(DataInputView source, DataOutputView target) throws IOException {
        int computationStateNo = source.readInt();
        target.writeInt(computationStateNo);
        for (int i = 0; i < computationStateNo; ++i) {
            String state = STATE_NAME_SERIALIZER.deserialize(source);
            STATE_NAME_SERIALIZER.serialize(state, target);
            NodeId prevState = NODE_ID_SERIALIZER.deserialize(source);
            NODE_ID_SERIALIZER.serialize(prevState, target);
            DeweyNumber version = VERSION_SERIALIZER.deserialize(source);
            VERSION_SERIALIZER.serialize(version, target);
            long startTimestamp = TIMESTAMP_SERIALIZER.deserialize(source);
            TIMESTAMP_SERIALIZER.serialize(Long.valueOf(startTimestamp), target);
            byte isNull = source.readByte();
            target.writeByte((int)isNull);
            if (isNull != 1) continue;
            EventId startEventId = EVENT_ID_SERIALIZER.deserialize(source);
            EVENT_ID_SERIALIZER.serialize(startEventId, target);
        }
    }

    public boolean canEqual(Object obj) {
        return true;
    }
}

