/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep;

import java.util.UUID;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.EitherTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.cep.EventComparator;
import org.apache.flink.cep.PatternFlatSelectFunction;
import org.apache.flink.cep.PatternFlatTimeoutFunction;
import org.apache.flink.cep.PatternSelectFunction;
import org.apache.flink.cep.PatternTimeoutFunction;
import org.apache.flink.cep.operator.CEPOperatorUtils;
import org.apache.flink.cep.pattern.Pattern;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.SingleOutputStreamOperator;
import org.apache.flink.streaming.api.functions.co.CoMapFunction;
import org.apache.flink.types.Either;
import org.apache.flink.util.OutputTag;

public class PatternStream<T> {
    private final DataStream<T> inputStream;
    private final Pattern<T, ?> pattern;
    private final EventComparator<T> comparator;
    private OutputTag<T> lateDataOutputTag;

    PatternStream(DataStream<T> inputStream, Pattern<T, ?> pattern) {
        this.inputStream = inputStream;
        this.pattern = pattern;
        this.comparator = null;
    }

    PatternStream(DataStream<T> inputStream, Pattern<T, ?> pattern, EventComparator<T> comparator) {
        this.inputStream = inputStream;
        this.pattern = pattern;
        this.comparator = comparator;
    }

    public Pattern<T, ?> getPattern() {
        return this.pattern;
    }

    public DataStream<T> getInputStream() {
        return this.inputStream;
    }

    public EventComparator<T> getComparator() {
        return this.comparator;
    }

    public <R> SingleOutputStreamOperator<R> select(PatternSelectFunction<T, R> patternSelectFunction) {
        TypeInformation returnType = TypeExtractor.getUnaryOperatorReturnType(patternSelectFunction, PatternSelectFunction.class, (int)0, (int)1, (int[])TypeExtractor.NO_INDEX, (TypeInformation)this.inputStream.getType(), null, (boolean)false);
        return this.select(patternSelectFunction, returnType);
    }

    private <F> F clean(F f) {
        return (F)this.inputStream.getExecutionEnvironment().clean(f);
    }

    public <R> SingleOutputStreamOperator<R> select(PatternSelectFunction<T, R> patternSelectFunction, TypeInformation<R> outTypeInfo) {
        return CEPOperatorUtils.createPatternStream(this.inputStream, this.pattern, this.comparator, this.clean(patternSelectFunction), outTypeInfo, this.lateDataOutputTag);
    }

    public <L, R> SingleOutputStreamOperator<R> select(OutputTag<L> timeoutOutputTag, PatternTimeoutFunction<T, L> patternTimeoutFunction, PatternSelectFunction<T, R> patternSelectFunction) {
        TypeInformation rightTypeInfo = TypeExtractor.getUnaryOperatorReturnType(patternSelectFunction, PatternSelectFunction.class, (int)0, (int)1, (int[])TypeExtractor.NO_INDEX, (TypeInformation)this.inputStream.getType(), null, (boolean)false);
        return this.select(timeoutOutputTag, patternTimeoutFunction, rightTypeInfo, patternSelectFunction);
    }

    public <L, R> SingleOutputStreamOperator<R> select(OutputTag<L> timeoutOutputTag, PatternTimeoutFunction<T, L> patternTimeoutFunction, TypeInformation<R> outTypeInfo, PatternSelectFunction<T, R> patternSelectFunction) {
        return CEPOperatorUtils.createTimeoutPatternStream(this.inputStream, this.pattern, this.comparator, this.clean(patternSelectFunction), outTypeInfo, timeoutOutputTag, this.clean(patternTimeoutFunction), this.lateDataOutputTag);
    }

    @Deprecated
    public <L, R> SingleOutputStreamOperator<Either<L, R>> select(PatternTimeoutFunction<T, L> patternTimeoutFunction, PatternSelectFunction<T, R> patternSelectFunction) {
        TypeInformation rightTypeInfo = TypeExtractor.getUnaryOperatorReturnType(patternSelectFunction, PatternSelectFunction.class, (int)0, (int)1, (int[])TypeExtractor.NO_INDEX, (TypeInformation)this.inputStream.getType(), null, (boolean)false);
        TypeInformation leftTypeInfo = TypeExtractor.getUnaryOperatorReturnType(patternTimeoutFunction, PatternTimeoutFunction.class, (int)0, (int)1, (int[])TypeExtractor.NO_INDEX, (TypeInformation)this.inputStream.getType(), null, (boolean)false);
        OutputTag outputTag = new OutputTag(UUID.randomUUID().toString(), leftTypeInfo);
        SingleOutputStreamOperator<R> mainStream = CEPOperatorUtils.createTimeoutPatternStream(this.inputStream, this.pattern, this.comparator, this.clean(patternSelectFunction), rightTypeInfo, outputTag, this.clean(patternTimeoutFunction), this.lateDataOutputTag);
        DataStream timedOutStream = mainStream.getSideOutput(outputTag);
        EitherTypeInfo outTypeInfo = new EitherTypeInfo(leftTypeInfo, rightTypeInfo);
        return mainStream.connect(timedOutStream).map(new CoMapTimeout()).returns((TypeInformation)outTypeInfo);
    }

    public <R> SingleOutputStreamOperator<R> flatSelect(PatternFlatSelectFunction<T, R> patternFlatSelectFunction) {
        TypeInformation outTypeInfo = TypeExtractor.getUnaryOperatorReturnType(patternFlatSelectFunction, PatternFlatSelectFunction.class, (int)0, (int)1, (int[])new int[]{1, 0}, (TypeInformation)this.inputStream.getType(), null, (boolean)false);
        return this.flatSelect(patternFlatSelectFunction, outTypeInfo);
    }

    public <R> SingleOutputStreamOperator<R> flatSelect(PatternFlatSelectFunction<T, R> patternFlatSelectFunction, TypeInformation<R> outTypeInfo) {
        return CEPOperatorUtils.createPatternStream(this.inputStream, this.pattern, this.comparator, this.clean(patternFlatSelectFunction), outTypeInfo, this.lateDataOutputTag);
    }

    public <L, R> SingleOutputStreamOperator<R> flatSelect(OutputTag<L> timeoutOutputTag, PatternFlatTimeoutFunction<T, L> patternFlatTimeoutFunction, PatternFlatSelectFunction<T, R> patternFlatSelectFunction) {
        TypeInformation rightTypeInfo = TypeExtractor.getUnaryOperatorReturnType(patternFlatSelectFunction, PatternFlatSelectFunction.class, (int)0, (int)1, (int[])new int[]{1, 0}, (TypeInformation)this.inputStream.getType(), null, (boolean)false);
        return this.flatSelect(timeoutOutputTag, patternFlatTimeoutFunction, rightTypeInfo, patternFlatSelectFunction);
    }

    public <L, R> SingleOutputStreamOperator<R> flatSelect(OutputTag<L> timeoutOutputTag, PatternFlatTimeoutFunction<T, L> patternFlatTimeoutFunction, TypeInformation<R> outTypeInfo, PatternFlatSelectFunction<T, R> patternFlatSelectFunction) {
        return CEPOperatorUtils.createTimeoutPatternStream(this.inputStream, this.pattern, this.comparator, this.clean(patternFlatSelectFunction), outTypeInfo, timeoutOutputTag, this.clean(patternFlatTimeoutFunction), this.lateDataOutputTag);
    }

    @Deprecated
    public <L, R> SingleOutputStreamOperator<Either<L, R>> flatSelect(PatternFlatTimeoutFunction<T, L> patternFlatTimeoutFunction, PatternFlatSelectFunction<T, R> patternFlatSelectFunction) {
        TypeInformation leftTypeInfo = TypeExtractor.getUnaryOperatorReturnType(patternFlatTimeoutFunction, PatternFlatTimeoutFunction.class, (int)0, (int)1, (int[])new int[]{2, 0}, (TypeInformation)this.inputStream.getType(), null, (boolean)false);
        TypeInformation rightTypeInfo = TypeExtractor.getUnaryOperatorReturnType(patternFlatSelectFunction, PatternFlatSelectFunction.class, (int)0, (int)1, (int[])new int[]{1, 0}, (TypeInformation)this.inputStream.getType(), null, (boolean)false);
        OutputTag outputTag = new OutputTag(UUID.randomUUID().toString(), leftTypeInfo);
        SingleOutputStreamOperator<R> mainStream = CEPOperatorUtils.createTimeoutPatternStream(this.inputStream, this.pattern, this.comparator, this.clean(patternFlatSelectFunction), rightTypeInfo, outputTag, this.clean(patternFlatTimeoutFunction), this.lateDataOutputTag);
        DataStream timedOutStream = mainStream.getSideOutput(outputTag);
        EitherTypeInfo outTypeInfo = new EitherTypeInfo(leftTypeInfo, rightTypeInfo);
        return mainStream.connect(timedOutStream).map(new CoMapTimeout()).returns((TypeInformation)outTypeInfo);
    }

    public PatternStream<T> sideOutputLateData(OutputTag<T> outputTag) {
        this.lateDataOutputTag = this.clean(outputTag);
        return this;
    }

    @Internal
    public static class CoMapTimeout<R, L>
    implements CoMapFunction<R, L, Either<L, R>> {
        private static final long serialVersionUID = 2059391566945212552L;

        public Either<L, R> map1(R value) throws Exception {
            return Either.Right(value);
        }

        public Either<L, R> map2(L value) throws Exception {
            return Either.Left(value);
        }
    }
}

