/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.calcite.shaded.com.esri.core.geometry;

import org.apache.flink.calcite.shaded.com.esri.core.geometry.AttributeStreamOfInt32;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.AttributeStreamOfInt8;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.EditShape;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.IndexMultiDCList;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.Line;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.Point2D;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.Segment;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.Treap;

class RingOrientationFixer {
    EditShape m_shape;
    Treap m_AET = new Treap();
    double m_y_scanline;
    int m_geometry;
    int m_unknown_ring_orientation_count;
    IndexMultiDCList m_sorted_vertices;
    AttributeStreamOfInt32 m_unknown_nodes;
    int m_node_1_user_index;
    int m_node_2_user_index;
    int m_path_orientation_index;
    int m_path_parentage_index;
    boolean m_fixSelfTangency;
    Edges m_edges;
    RingOrientationTestComparator m_sweep_comparator;

    RingOrientationFixer() {
        this.m_AET.disableBalancing();
        this.m_sweep_comparator = new RingOrientationTestComparator(this);
        this.m_AET.setComparator(this.m_sweep_comparator);
    }

    boolean fixRingOrientation_() {
        boolean bFound = false;
        if (this.m_fixSelfTangency) {
            bFound = this.fixRingSelfTangency_();
        }
        if (this.m_shape.getPathCount(this.m_geometry) == 1) {
            int path = this.m_shape.getFirstPath(this.m_geometry);
            double area = this.m_shape.getRingArea(path);
            this.m_shape.setExterior(path, true);
            if (area < 0.0) {
                int first = this.m_shape.getFirstVertex(path);
                this.m_shape.reverseRingInternal_(first);
                this.m_shape.setLastVertex_(path, this.m_shape.getPrevVertex(first));
                return true;
            }
            return false;
        }
        this.m_path_orientation_index = this.m_shape.createPathUserIndex();
        this.m_path_parentage_index = this.m_shape.createPathUserIndex();
        int path = this.m_shape.getFirstPath(this.m_geometry);
        while (path != -1) {
            this.m_shape.setPathUserIndex(path, this.m_path_orientation_index, 0);
            this.m_shape.setPathUserIndex(path, this.m_path_parentage_index, -1);
            path = this.m_shape.getNextPath(path);
        }
        AttributeStreamOfInt32 bunch = new AttributeStreamOfInt32(0);
        this.m_y_scanline = Double.NaN;
        Point2D pt = new Point2D();
        this.m_unknown_ring_orientation_count = this.m_shape.getPathCount(this.m_geometry);
        this.m_node_1_user_index = this.m_shape.createUserIndex();
        this.m_node_2_user_index = this.m_shape.createUserIndex();
        int ivertex = this.m_sorted_vertices.getFirst(this.m_sorted_vertices.getFirstList());
        while (ivertex != -1) {
            int vertex = this.m_sorted_vertices.getData(ivertex);
            this.m_shape.getXY(vertex, pt);
            if (pt.y != this.m_y_scanline && bunch.size() != 0) {
                bFound |= this.processBunchForRingOrientationTest_(bunch);
                this.m_sweep_comparator.reset();
                bunch.clear(false);
            }
            bunch.add(vertex);
            this.m_y_scanline = pt.y;
            if (this.m_unknown_ring_orientation_count == 0) break;
            ivertex = this.m_sorted_vertices.getNext(ivertex);
        }
        if (this.m_unknown_ring_orientation_count > 0) {
            bFound |= this.processBunchForRingOrientationTest_(bunch);
            bunch.clear(false);
        }
        this.m_shape.removeUserIndex(this.m_node_1_user_index);
        this.m_shape.removeUserIndex(this.m_node_2_user_index);
        int path2 = this.m_shape.getFirstPath(this.m_geometry);
        while (path2 != -1) {
            if (this.m_shape.getPathUserIndex(path2, this.m_path_orientation_index) == 3) {
                this.m_shape.setExterior(path2, true);
                int afterPath = path2;
                int nextHole = this.m_shape.getPathUserIndex(path2, this.m_path_parentage_index);
                while (nextHole != -1) {
                    int p = this.m_shape.getPathUserIndex(nextHole, this.m_path_parentage_index);
                    this.m_shape.movePath(this.m_geometry, this.m_shape.getNextPath(afterPath), nextHole);
                    afterPath = nextHole;
                    nextHole = p;
                }
                path2 = this.m_shape.getNextPath(afterPath);
                continue;
            }
            this.m_shape.setExterior(path2, false);
            path2 = this.m_shape.getNextPath(path2);
        }
        this.m_shape.removePathUserIndex(this.m_path_orientation_index);
        this.m_shape.removePathUserIndex(this.m_path_parentage_index);
        return bFound;
    }

    boolean processBunchForRingOrientationTest_(AttributeStreamOfInt32 bunch) {
        return this.processBunchForRingOrientationTestOddEven_(bunch);
    }

    boolean processBunchForRingOrientationTestOddEven_(AttributeStreamOfInt32 bunch) {
        int i;
        boolean bModified = false;
        if (this.m_edges == null) {
            this.m_edges = new Edges(this.m_shape);
        }
        if (this.m_unknown_nodes == null) {
            this.m_unknown_nodes = new AttributeStreamOfInt32(0);
            this.m_unknown_nodes.reserve(16);
        } else {
            this.m_unknown_nodes.clear(false);
        }
        this.processBunchForRingOrientationRemoveEdges_(bunch);
        int n = bunch.size();
        for (i = 0; i < n; ++i) {
            int vertex = bunch.get(i);
            if (vertex == -1) continue;
            this.insertEdge_(vertex, -1);
        }
        for (i = 0; i < this.m_unknown_nodes.size() && this.m_unknown_ring_orientation_count > 0; ++i) {
            int orientation1;
            int path1;
            int edge1;
            int aetNode = this.m_unknown_nodes.get(i);
            int edge = this.m_AET.getElement(aetNode);
            int path = this.m_edges.getPath(edge);
            int orientation = this.m_shape.getPathUserIndex(path, this.m_path_orientation_index);
            int prevPath = -1;
            if (orientation != 0) continue;
            int node = this.m_AET.getPrev(aetNode);
            int prevNode = aetNode;
            boolean odd_even = false;
            while (node != Treap.nullNode()) {
                edge1 = this.m_AET.getElement(node);
                path1 = this.m_edges.getPath(edge1);
                orientation1 = this.m_shape.getPathUserIndex(path1, this.m_path_orientation_index);
                if (orientation1 != 0) {
                    prevPath = path1;
                    break;
                }
                prevNode = node;
                node = this.m_AET.getPrev(node);
            }
            if (node == Treap.nullNode()) {
                odd_even = true;
                node = prevNode;
            } else {
                edge1 = this.m_AET.getElement(node);
                odd_even = this.m_edges.isBottomUp(edge1);
                node = this.m_AET.getNext(node);
                boolean bl = odd_even = !odd_even;
            }
            do {
                if ((orientation1 = this.m_shape.getPathUserIndex(path1 = this.m_edges.getPath(edge1 = this.m_AET.getElement(node)), this.m_path_orientation_index)) == 0) {
                    if (odd_even != this.m_edges.isBottomUp(edge1)) {
                        int first = this.m_shape.getFirstVertex(path1);
                        this.m_shape.reverseRingInternal_(first);
                        this.m_shape.setLastVertex_(path1, this.m_shape.getPrevVertex(first));
                        bModified = true;
                    }
                    this.m_shape.setPathUserIndex(path1, this.m_path_orientation_index, odd_even ? 3 : 2);
                    if (!odd_even) {
                        int lastHole = this.m_shape.getPathUserIndex(prevPath, this.m_path_parentage_index);
                        this.m_shape.setPathUserIndex(prevPath, this.m_path_parentage_index, path1);
                        this.m_shape.setPathUserIndex(path1, this.m_path_parentage_index, lastHole);
                    }
                    --this.m_unknown_ring_orientation_count;
                    if (this.m_unknown_ring_orientation_count == 0) {
                        return bModified;
                    }
                }
                prevPath = path1;
                prevNode = node;
                node = this.m_AET.getNext(node);
                boolean bl = odd_even = !odd_even;
            } while (prevNode != aetNode);
        }
        return bModified;
    }

    void processBunchForRingOrientationRemoveEdges_(AttributeStreamOfInt32 bunch) {
        int n = bunch.size();
        for (int i = 0; i < n; ++i) {
            int edge;
            int vertex = bunch.get(i);
            int node1 = this.m_shape.getUserIndex(vertex, this.m_node_1_user_index);
            int node2 = this.m_shape.getUserIndex(vertex, this.m_node_2_user_index);
            if (node1 != -1) {
                edge = this.m_AET.getElement(node1);
                this.m_edges.freeEdge(edge);
                this.m_shape.setUserIndex(vertex, this.m_node_1_user_index, -1);
            }
            if (node2 != -1) {
                edge = this.m_AET.getElement(node2);
                this.m_edges.freeEdge(edge);
                this.m_shape.setUserIndex(vertex, this.m_node_2_user_index, -1);
            }
            int reused_node = -1;
            if (node1 != -1 && node2 != -1) {
                this.m_AET.deleteNode(node1, -1);
                this.m_AET.deleteNode(node2, -1);
                bunch.set(i, -1);
            } else {
                int n2 = reused_node = node1 != -1 ? node1 : node2;
            }
            if (reused_node == -1) continue;
            if (!this.insertEdge_(vertex, reused_node)) {
                this.m_AET.deleteNode(reused_node, -1);
            }
            bunch.set(i, -1);
        }
    }

    boolean insertEdge_(int vertex, int reused_node) {
        Point2D pt_1 = new Point2D();
        Point2D pt_2 = new Point2D();
        this.m_shape.getXY(vertex, pt_1);
        int next = this.m_shape.getNextVertex(vertex);
        this.m_shape.getXY(next, pt_2);
        boolean b_res = false;
        if (pt_1.y < pt_2.y) {
            int aetNode;
            b_res = true;
            int edge = this.m_edges.newEdge(vertex);
            if (reused_node == -1) {
                aetNode = this.m_AET.addElement(edge, -1);
            } else {
                aetNode = reused_node;
                this.m_AET.setElement(aetNode, edge);
            }
            int node = this.m_shape.getUserIndex(next, this.m_node_1_user_index);
            if (node == -1) {
                this.m_shape.setUserIndex(next, this.m_node_1_user_index, aetNode);
            } else {
                this.m_shape.setUserIndex(next, this.m_node_2_user_index, aetNode);
            }
            int path = this.m_shape.getPathFromVertex(vertex);
            if (this.m_shape.getPathUserIndex(path, this.m_path_orientation_index) == 0) {
                this.m_unknown_nodes.add(aetNode);
            }
        }
        int prev = this.m_shape.getPrevVertex(vertex);
        this.m_shape.getXY(prev, pt_2);
        if (pt_1.y < pt_2.y) {
            int aetNode;
            b_res = true;
            int edge = this.m_edges.newEdge(prev);
            if (reused_node == -1) {
                aetNode = this.m_AET.addElement(edge, -1);
            } else {
                aetNode = reused_node;
                this.m_AET.setElement(aetNode, edge);
            }
            int node = this.m_shape.getUserIndex(prev, this.m_node_1_user_index);
            if (node == -1) {
                this.m_shape.setUserIndex(prev, this.m_node_1_user_index, aetNode);
            } else {
                this.m_shape.setUserIndex(prev, this.m_node_2_user_index, aetNode);
            }
            int path = this.m_shape.getPathFromVertex(vertex);
            if (this.m_shape.getPathUserIndex(path, this.m_path_orientation_index) == 0) {
                this.m_unknown_nodes.add(aetNode);
            }
        }
        return b_res;
    }

    static boolean execute(EditShape shape, int geometry, IndexMultiDCList sorted_vertices, boolean fixSelfTangency) {
        RingOrientationFixer fixer = new RingOrientationFixer();
        fixer.m_shape = shape;
        fixer.m_geometry = geometry;
        fixer.m_sorted_vertices = sorted_vertices;
        fixer.m_fixSelfTangency = fixSelfTangency;
        return fixer.fixRingOrientation_();
    }

    boolean fixRingSelfTangency_() {
        AttributeStreamOfInt32 self_tangent_paths = new AttributeStreamOfInt32(0);
        AttributeStreamOfInt32 self_tangency_clusters = new AttributeStreamOfInt32(0);
        int tangent_path_first_vertex_index = -1;
        int tangent_vertex_cluster_index = -1;
        Point2D pt_prev = new Point2D();
        pt_prev.setNaN();
        int prev_vertex = -1;
        int old_path = -1;
        int current_cluster = -1;
        Point2D pt = new Point2D();
        int ivertex = this.m_sorted_vertices.getFirst(this.m_sorted_vertices.getFirstList());
        while (ivertex != -1) {
            int vertex = this.m_sorted_vertices.getData(ivertex);
            this.m_shape.getXY(vertex, pt);
            int path = this.m_shape.getPathFromVertex(vertex);
            if (pt_prev.isEqual(pt) && old_path == path) {
                if (tangent_vertex_cluster_index == -1) {
                    tangent_path_first_vertex_index = this.m_shape.createPathUserIndex();
                    tangent_vertex_cluster_index = this.m_shape.createUserIndex();
                }
                if (current_cluster == -1) {
                    current_cluster = self_tangency_clusters.size();
                    this.m_shape.setUserIndex(prev_vertex, tangent_vertex_cluster_index, current_cluster);
                    self_tangency_clusters.add(1);
                    int p = this.m_shape.getPathUserIndex(path, tangent_path_first_vertex_index);
                    if (p == -1) {
                        this.m_shape.setPathUserIndex(path, tangent_path_first_vertex_index, prev_vertex);
                        self_tangent_paths.add(path);
                    }
                }
                this.m_shape.setUserIndex(vertex, tangent_vertex_cluster_index, current_cluster);
                self_tangency_clusters.setLast(self_tangency_clusters.getLast() + 1);
            } else {
                current_cluster = -1;
                pt_prev.setCoords(pt);
            }
            prev_vertex = vertex;
            old_path = path;
            ivertex = this.m_sorted_vertices.getNext(ivertex);
        }
        if (self_tangent_paths.size() == 0) {
            return false;
        }
        AttributeStreamOfInt32 vertex_stack = new AttributeStreamOfInt32(0);
        AttributeStreamOfInt32 cluster_stack = new AttributeStreamOfInt32(0);
        int npath = self_tangent_paths.size();
        for (int ipath = 0; ipath < npath; ++ipath) {
            int path = self_tangent_paths.get(ipath);
            int first_vertex = this.m_shape.getPathUserIndex(path, tangent_path_first_vertex_index);
            int cluster = this.m_shape.getUserIndex(first_vertex, tangent_vertex_cluster_index);
            vertex_stack.clear(false);
            cluster_stack.clear(false);
            vertex_stack.add(first_vertex);
            cluster_stack.add(cluster);
            int vertex = this.m_shape.getNextVertex(first_vertex);
            while (vertex != first_vertex) {
                int vertex_to = vertex;
                int cluster_to = this.m_shape.getUserIndex(vertex_to, tangent_vertex_cluster_index);
                if (cluster_to != -1) {
                    if (cluster_stack.size() == 0) {
                        cluster_stack.add(cluster_to);
                        vertex_stack.add(vertex_to);
                    } else if (cluster_stack.getLast() == cluster_to) {
                        int vertex_from = vertex_stack.getLast();
                        int from_next = this.m_shape.getNextVertex(vertex_from);
                        int from_prev = this.m_shape.getPrevVertex(vertex_from);
                        int to_next = this.m_shape.getNextVertex(vertex_to);
                        int to_prev = this.m_shape.getPrevVertex(vertex_to);
                        this.m_shape.setNextVertex_(vertex_from, to_next);
                        this.m_shape.setPrevVertex_(to_next, vertex_from);
                        this.m_shape.setNextVertex_(vertex_to, from_next);
                        this.m_shape.setPrevVertex_(from_next, vertex_to);
                        boolean[] first_vertex_correction_requied = new boolean[]{false};
                        int new_path = this.m_shape.insertClosedPath_(this.m_geometry, -1, from_next, this.m_shape.getFirstVertex(path), first_vertex_correction_requied);
                        this.m_shape.setUserIndex(vertex, tangent_vertex_cluster_index, -1);
                        if (first_vertex_correction_requied[0]) {
                            this.m_shape.setFirstVertex_(path, to_next);
                        }
                        int path_size = this.m_shape.getPathSize(path);
                        int new_path_size = this.m_shape.getPathSize(new_path);
                        assert ((path_size -= new_path_size) >= 3);
                        this.m_shape.setPathSize_(path, path_size);
                        self_tangency_clusters.set(cluster_to, self_tangency_clusters.get(cluster_to) - 1);
                        if (self_tangency_clusters.get(cluster_to) == 1) {
                            self_tangency_clusters.set(cluster_to, 0);
                            cluster_stack.removeLast();
                            vertex_stack.removeLast();
                        }
                        first_vertex = vertex_from;
                        vertex = vertex_from;
                    } else {
                        vertex_stack.add(vertex);
                        cluster_stack.add(cluster_to);
                    }
                }
                vertex = this.m_shape.getNextVertex(vertex);
            }
        }
        this.m_shape.removePathUserIndex(tangent_path_first_vertex_index);
        this.m_shape.removeUserIndex(tangent_vertex_cluster_index);
        return true;
    }

    class RingOrientationTestComparator
    extends Treap.Comparator {
        RingOrientationFixer m_helper;
        Line m_line_1;
        Line m_line_2;
        int m_left_elm;
        double m_leftx;
        Segment m_seg_1;

        RingOrientationTestComparator(RingOrientationFixer helper) {
            this.m_helper = helper;
            this.m_line_1 = new Line();
            this.m_line_2 = new Line();
            this.m_leftx = 0.0;
            this.m_seg_1 = null;
            this.m_left_elm = -1;
        }

        @Override
        int compare(Treap treap, int left, int node) {
            double x2;
            double x_1;
            int right = treap.getElement(node);
            Edges edges = this.m_helper.m_edges;
            if (this.m_left_elm == left) {
                x_1 = this.m_leftx;
            } else {
                this.m_seg_1 = edges.getSegment(left);
                if (this.m_seg_1 == null) {
                    EditShape shape = edges.getShape();
                    shape.queryLineConnector(edges.getStart(left), this.m_line_1);
                    this.m_seg_1 = this.m_line_1;
                    x_1 = this.m_line_1.intersectionOfYMonotonicWithAxisX(this.m_helper.m_y_scanline, 0.0);
                } else {
                    x_1 = this.m_seg_1.intersectionOfYMonotonicWithAxisX(this.m_helper.m_y_scanline, 0.0);
                }
                this.m_leftx = x_1;
                this.m_left_elm = left;
            }
            Segment seg_2 = edges.getSegment(right);
            if (seg_2 == null) {
                EditShape shape = edges.getShape();
                shape.queryLineConnector(edges.getStart(right), this.m_line_2);
                seg_2 = this.m_line_2;
                x2 = this.m_line_2.intersectionOfYMonotonicWithAxisX(this.m_helper.m_y_scanline, 0.0);
            } else {
                x2 = seg_2.intersectionOfYMonotonicWithAxisX(this.m_helper.m_y_scanline, 0.0);
            }
            if (x_1 == x2) {
                boolean bStartLower2;
                double y2;
                boolean bStartLower1 = edges.isBottomUp(left);
                double y1 = !bStartLower1 ? this.m_seg_1.getStartY() : this.m_seg_1.getEndY();
                double miny = Math.min(y1, y2 = !(bStartLower2 = edges.isBottomUp(right)) ? seg_2.getStartY() : seg_2.getEndY());
                double y = (miny + this.m_helper.m_y_scanline) * 0.5;
                if (y == this.m_helper.m_y_scanline) {
                    y = miny;
                }
                x_1 = this.m_seg_1.intersectionOfYMonotonicWithAxisX(y, 0.0);
                x2 = seg_2.intersectionOfYMonotonicWithAxisX(y, 0.0);
                assert (x_1 != x2);
            }
            return x_1 < x2 ? -1 : (x_1 > x2 ? 1 : 0);
        }

        void reset() {
            this.m_left_elm = -1;
        }
    }

    static final class Edges {
        EditShape m_shape;
        AttributeStreamOfInt32 m_end_1_nodes;
        AttributeStreamOfInt32 m_end_2_nodes;
        AttributeStreamOfInt8 m_directions;
        Point2D pt_1 = new Point2D();
        Point2D pt_2 = new Point2D();
        int m_first_free;

        boolean getDirection_(int index) {
            return this.m_shape.getNextVertex(this.getEnd1(index)) == this.getEnd2(index);
        }

        int getEnd_(int index) {
            int v_1 = this.getEnd1(index);
            int v_2 = this.getEnd2(index);
            if (this.m_shape.getNextVertex(v_1) == v_2) {
                return v_2;
            }
            return v_1;
        }

        Edges(EditShape shape) {
            this.m_shape = shape;
            this.m_first_free = -1;
        }

        Segment getSegment(int index) {
            return this.m_shape.getSegment(this.getStart(index));
        }

        boolean isBottomUp(int index) {
            int v_1 = this.getEnd1(index);
            int v_2 = this.getEnd2(index);
            if (this.m_shape.getPrevVertex(v_1) == v_2) {
                int temp = v_1;
                v_1 = v_2;
                v_2 = temp;
            }
            this.m_shape.getXY(v_1, this.pt_1);
            this.m_shape.getXY(v_2, this.pt_2);
            return this.pt_1.y < this.pt_2.y;
        }

        int getStart(int index) {
            int v_1 = this.getEnd1(index);
            int v_2 = this.getEnd2(index);
            return this.m_shape.getNextVertex(v_1) == v_2 ? v_1 : v_2;
        }

        int getEnd1(int index) {
            return this.m_end_1_nodes.get(index);
        }

        int getEnd2(int index) {
            return this.m_end_2_nodes.get(index);
        }

        void freeEdge(int edge) {
            this.m_end_1_nodes.set(edge, this.m_first_free);
            this.m_first_free = edge;
        }

        int newEdge(int vertex) {
            if (this.m_first_free != -1) {
                int index = this.m_first_free;
                this.m_first_free = this.m_end_1_nodes.get(index);
                this.m_end_1_nodes.set(index, vertex);
                this.m_end_2_nodes.set(index, this.m_shape.getNextVertex(vertex));
                return index;
            }
            if (this.m_end_1_nodes == null) {
                this.m_end_1_nodes = new AttributeStreamOfInt32(0);
                this.m_end_2_nodes = new AttributeStreamOfInt32(0);
            }
            int index = this.m_end_1_nodes.size();
            this.m_end_1_nodes.add(vertex);
            this.m_end_2_nodes.add(this.m_shape.getNextVertex(vertex));
            return index;
        }

        EditShape getShape() {
            return this.m_shape;
        }

        int getPath(int index) {
            return this.m_shape.getPathFromVertex(this.getEnd1(index));
        }
    }
}

