/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.calcite.shaded.com.esri.core.geometry;

import org.apache.flink.calcite.shaded.com.esri.core.geometry.GeometryException;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.JsonReader;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.NumberUtils;

final class JSONUtils {
    JSONUtils() {
    }

    static boolean isObjectStart(JsonReader parser) throws Exception {
        return parser.currentToken() == null ? parser.nextToken() == JsonReader.Token.START_OBJECT : parser.currentToken() == JsonReader.Token.START_OBJECT;
    }

    static double readDouble(JsonReader parser) {
        if (parser.currentToken() == JsonReader.Token.VALUE_NUMBER_FLOAT) {
            return parser.currentDoubleValue();
        }
        if (parser.currentToken() == JsonReader.Token.VALUE_NUMBER_INT) {
            return parser.currentIntValue();
        }
        if (parser.currentToken() == JsonReader.Token.VALUE_NULL) {
            return NumberUtils.NaN();
        }
        if (parser.currentToken() == JsonReader.Token.VALUE_STRING && parser.currentString().equals("NaN")) {
            return NumberUtils.NaN();
        }
        throw new GeometryException("invalid parameter");
    }
}

