/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.calcite.util.Holder;

public enum Hook {
    CURRENT_TIME,
    STANDARD_STREAMS,
    REL_BUILDER_SIMPLIFY,
    ENABLE_BINDABLE,
    PARSE_TREE,
    STRING_TO_QUERY,
    JAVA_PLAN,
    CONVERTED,
    PLANNER,
    TRIMMED,
    SUB,
    EXPRESSION_REDUCER,
    PROGRAM,
    CREATE_MATERIALIZATION,
    QUERY_PLAN;

    private final List<Consumer<Object>> handlers = new CopyOnWriteArrayList<Consumer<Object>>();
    private final ThreadLocal<List<Consumer<Object>>> threadHandlers = ThreadLocal.withInitial(ArrayList::new);

    public <T, R> Closeable add(Consumer<T> handler) {
        this.handlers.add(handler);
        return () -> this.remove(handler);
    }

    @Deprecated
    public <T, R> Closeable add(Function<T, R> handler) {
        return this.add(handler::apply);
    }

    private boolean remove(Consumer handler) {
        return this.handlers.remove(handler);
    }

    public <T> Closeable addThread(Consumer<T> handler) {
        this.threadHandlers.get().add(handler);
        return () -> this.removeThread(handler);
    }

    @Deprecated
    public <T, R> Closeable addThread(org.apache.flink.calcite.shaded.com.google.common.base.Function<T, R> handler) {
        return this.addThread(handler::apply);
    }

    private boolean removeThread(Consumer handler) {
        return this.threadHandlers.get().remove(handler);
    }

    @Deprecated
    public static <V> org.apache.flink.calcite.shaded.com.google.common.base.Function<Holder<V>, Void> property(V v) {
        return holder -> {
            holder.set(v);
            return null;
        };
    }

    public static <V> Consumer<Holder<V>> propertyJ(V v) {
        return holder -> holder.set(v);
    }

    public void run(Object arg) {
        for (Consumer<Object> handler : this.handlers) {
            handler.accept(arg);
        }
        for (Consumer<Object> handler : this.threadHandlers.get()) {
            handler.accept(arg);
        }
    }

    public <V> V get(V defaultValue) {
        Holder<V> holder = Holder.of(defaultValue);
        this.run(holder);
        return holder.get();
    }

    public static interface Closeable
    extends AutoCloseable {
        public static final Closeable EMPTY = () -> {};

        @Override
        public void close();
    }
}

