/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.calcite.plan.RelMultipleTrait;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.flink.calcite.shaded.com.google.common.collect.Ordering;

public class RelDistributions {
    private static final ImmutableIntList EMPTY = ImmutableIntList.of();
    public static final RelDistribution SINGLETON = new RelDistributionImpl(RelDistribution.Type.SINGLETON, EMPTY);
    public static final RelDistribution RANDOM_DISTRIBUTED = new RelDistributionImpl(RelDistribution.Type.RANDOM_DISTRIBUTED, EMPTY);
    public static final RelDistribution ROUND_ROBIN_DISTRIBUTED = new RelDistributionImpl(RelDistribution.Type.ROUND_ROBIN_DISTRIBUTED, EMPTY);
    public static final RelDistribution BROADCAST_DISTRIBUTED = new RelDistributionImpl(RelDistribution.Type.BROADCAST_DISTRIBUTED, EMPTY);
    public static final RelDistribution ANY = new RelDistributionImpl(RelDistribution.Type.ANY, EMPTY);

    private RelDistributions() {
    }

    public static RelDistribution hash(Collection<? extends Number> numbers) {
        ImmutableIntList list = ImmutableIntList.copyOf(numbers);
        if (numbers.size() > 1 && !Ordering.natural().isOrdered(list)) {
            list = ImmutableIntList.copyOf(Ordering.natural().sortedCopy(list));
        }
        RelDistributionImpl trait = new RelDistributionImpl(RelDistribution.Type.HASH_DISTRIBUTED, list);
        return RelDistributionTraitDef.INSTANCE.canonize(trait);
    }

    public static RelDistribution range(Collection<? extends Number> numbers) {
        ImmutableIntList list = ImmutableIntList.copyOf(numbers);
        RelDistributionImpl trait = new RelDistributionImpl(RelDistribution.Type.RANGE_DISTRIBUTED, list);
        return RelDistributionTraitDef.INSTANCE.canonize(trait);
    }

    private static class RelDistributionImpl
    implements RelDistribution {
        private static final Ordering<Iterable<Integer>> ORDERING = Ordering.natural().lexicographical();
        private final RelDistribution.Type type;
        private final ImmutableIntList keys;

        private RelDistributionImpl(RelDistribution.Type type, ImmutableIntList keys) {
            this.type = Objects.requireNonNull(type);
            this.keys = ImmutableIntList.copyOf(keys);
            assert (type != RelDistribution.Type.HASH_DISTRIBUTED || keys.size() < 2 || Ordering.natural().isOrdered(keys)) : "key columns of hash distribution must be in order";
            assert (type == RelDistribution.Type.HASH_DISTRIBUTED || type == RelDistribution.Type.RANDOM_DISTRIBUTED || keys.isEmpty());
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.keys});
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj || obj instanceof RelDistributionImpl && this.type == ((RelDistributionImpl)obj).type && this.keys.equals(((RelDistributionImpl)obj).keys);
        }

        @Override
        public String toString() {
            if (this.keys.isEmpty()) {
                return this.type.shortName;
            }
            return this.type.shortName + this.keys;
        }

        @Override
        @Nonnull
        public RelDistribution.Type getType() {
            return this.type;
        }

        @Override
        @Nonnull
        public List<Integer> getKeys() {
            return this.keys;
        }

        @Override
        public RelDistributionTraitDef getTraitDef() {
            return RelDistributionTraitDef.INSTANCE;
        }

        @Override
        public RelDistribution apply(Mappings.TargetMapping mapping) {
            if (this.keys.isEmpty()) {
                return this;
            }
            return this.getTraitDef().canonize(new RelDistributionImpl(this.type, ImmutableIntList.copyOf(Mappings.apply((Mapping)mapping, this.keys))));
        }

        @Override
        public boolean satisfies(RelTrait trait) {
            if (trait == this || trait == ANY) {
                return true;
            }
            if (trait instanceof RelDistributionImpl) {
                RelDistributionImpl distribution = (RelDistributionImpl)trait;
                if (this.type == distribution.type) {
                    switch (this.type) {
                        case HASH_DISTRIBUTED: {
                            return this.keys.equals(distribution.keys);
                        }
                        case RANGE_DISTRIBUTED: {
                            return Util.startsWith(distribution.keys, this.keys);
                        }
                    }
                    return true;
                }
            }
            if (trait == RANDOM_DISTRIBUTED) {
                return this.type == RelDistribution.Type.HASH_DISTRIBUTED || this.type == RelDistribution.Type.ROUND_ROBIN_DISTRIBUTED || this.type == RelDistribution.Type.RANGE_DISTRIBUTED;
            }
            return false;
        }

        @Override
        public void register(RelOptPlanner planner) {
        }

        @Override
        public boolean isTop() {
            return this.type == RelDistribution.Type.ANY;
        }

        @Override
        public int compareTo(@Nonnull RelMultipleTrait o) {
            RelDistribution distribution = (RelDistribution)o;
            if (this.type == distribution.getType() && (this.type == RelDistribution.Type.HASH_DISTRIBUTED || this.type == RelDistribution.Type.RANGE_DISTRIBUTED)) {
                return ORDERING.compare(this.getKeys(), distribution.getKeys());
            }
            return this.type.compareTo(distribution.getType());
        }
    }
}

