/*
 * Decompiled with CFR 0.152.
 */
package org.jline.reader.impl;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import org.jline.reader.CompletingParsedLine;
import org.jline.reader.EOFError;
import org.jline.reader.ParsedLine;
import org.jline.reader.Parser;

public class DefaultParser
implements Parser {
    private char[] quoteChars = new char[]{'\'', '\"'};
    private char[] escapeChars = new char[]{'\\'};
    private boolean eofOnUnclosedQuote;
    private boolean eofOnEscapedNewLine;

    public DefaultParser quoteChars(char[] chars) {
        this.quoteChars = chars;
        return this;
    }

    public DefaultParser escapeChars(char[] chars) {
        this.escapeChars = chars;
        return this;
    }

    public DefaultParser eofOnUnclosedQuote(boolean eofOnUnclosedQuote) {
        this.eofOnUnclosedQuote = eofOnUnclosedQuote;
        return this;
    }

    public DefaultParser eofOnEscapedNewLine(boolean eofOnEscapedNewLine) {
        this.eofOnEscapedNewLine = eofOnEscapedNewLine;
        return this;
    }

    public void setQuoteChars(char[] chars) {
        this.quoteChars = chars;
    }

    public char[] getQuoteChars() {
        return this.quoteChars;
    }

    public void setEscapeChars(char[] chars) {
        this.escapeChars = chars;
    }

    public char[] getEscapeChars() {
        return this.escapeChars;
    }

    public void setEofOnUnclosedQuote(boolean eofOnUnclosedQuote) {
        this.eofOnUnclosedQuote = eofOnUnclosedQuote;
    }

    public boolean isEofOnUnclosedQuote() {
        return this.eofOnUnclosedQuote;
    }

    public void setEofOnEscapedNewLine(boolean eofOnEscapedNewLine) {
        this.eofOnEscapedNewLine = eofOnEscapedNewLine;
    }

    public boolean isEofOnEscapedNewLine() {
        return this.eofOnEscapedNewLine;
    }

    @Override
    public ParsedLine parse(String line, int cursor, Parser.ParseContext context) {
        LinkedList<String> words = new LinkedList<String>();
        StringBuilder current = new StringBuilder();
        int wordCursor = -1;
        int wordIndex = -1;
        int quoteStart = -1;
        int rawWordCursor = -1;
        int rawWordLength = -1;
        int rawWordStart = 0;
        for (int i = 0; line != null && i < line.length(); ++i) {
            if (i == cursor) {
                wordIndex = words.size();
                wordCursor = current.length();
                rawWordCursor = i - rawWordStart;
            }
            if (quoteStart < 0 && this.isQuoteChar(line, i)) {
                quoteStart = i;
                continue;
            }
            if (quoteStart >= 0) {
                if (line.charAt(quoteStart) == line.charAt(i) && !this.isEscaped(line, i)) {
                    words.add(current.toString());
                    current.setLength(0);
                    quoteStart = -1;
                    if (rawWordCursor < 0 || rawWordLength >= 0) continue;
                    rawWordLength = i - rawWordStart + 1;
                    continue;
                }
                if (this.isEscapeChar(line, i)) continue;
                current.append(line.charAt(i));
                continue;
            }
            if (this.isDelimiter(line, i)) {
                if (current.length() > 0) {
                    words.add(current.toString());
                    current.setLength(0);
                    if (rawWordCursor >= 0 && rawWordLength < 0) {
                        rawWordLength = i - rawWordStart;
                    }
                }
                rawWordStart = i + 1;
                continue;
            }
            if (this.isEscapeChar(line, i)) continue;
            current.append(line.charAt(i));
        }
        if (current.length() > 0 || cursor == line.length()) {
            words.add(current.toString());
            if (rawWordCursor >= 0 && rawWordLength < 0) {
                rawWordLength = line.length() - rawWordStart;
            }
        }
        if (cursor == line.length()) {
            wordIndex = words.size() - 1;
            wordCursor = ((String)words.get(words.size() - 1)).length();
            rawWordLength = rawWordCursor = cursor - rawWordStart;
        }
        if (this.eofOnEscapedNewLine && this.isEscapeChar(line, line.length() - 1)) {
            throw new EOFError(-1, -1, "Escaped new line", "newline");
        }
        if (this.eofOnUnclosedQuote && quoteStart >= 0 && context != Parser.ParseContext.COMPLETE) {
            throw new EOFError(-1, -1, "Missing closing quote", line.charAt(quoteStart) == '\'' ? "quote" : "dquote");
        }
        String openingQuote = quoteStart >= 0 ? line.substring(quoteStart, quoteStart + 1) : null;
        return new ArgumentList(line, words, wordIndex, wordCursor, cursor, openingQuote, rawWordCursor, rawWordLength);
    }

    public boolean isDelimiter(CharSequence buffer, int pos) {
        return !this.isQuoted(buffer, pos) && !this.isEscaped(buffer, pos) && this.isDelimiterChar(buffer, pos);
    }

    public boolean isQuoted(CharSequence buffer, int pos) {
        return false;
    }

    public boolean isQuoteChar(CharSequence buffer, int pos) {
        if (pos < 0) {
            return false;
        }
        if (this.quoteChars != null) {
            for (char e2 : this.quoteChars) {
                if (e2 != buffer.charAt(pos)) continue;
                return !this.isEscaped(buffer, pos);
            }
        }
        return false;
    }

    public boolean isEscapeChar(CharSequence buffer, int pos) {
        if (pos < 0) {
            return false;
        }
        if (this.escapeChars != null) {
            for (char e2 : this.escapeChars) {
                if (e2 != buffer.charAt(pos)) continue;
                return !this.isEscaped(buffer, pos);
            }
        }
        return false;
    }

    public boolean isEscaped(CharSequence buffer, int pos) {
        if (pos <= 0) {
            return false;
        }
        return this.isEscapeChar(buffer, pos - 1);
    }

    public boolean isDelimiterChar(CharSequence buffer, int pos) {
        return Character.isWhitespace(buffer.charAt(pos));
    }

    private boolean isRawEscapeChar(char key) {
        if (this.escapeChars != null) {
            for (char e2 : this.escapeChars) {
                if (e2 != key) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRawQuoteChar(char key) {
        if (this.quoteChars != null) {
            for (char e2 : this.quoteChars) {
                if (e2 != key) continue;
                return true;
            }
        }
        return false;
    }

    public class ArgumentList
    implements ParsedLine,
    CompletingParsedLine {
        private final String line;
        private final List<String> words;
        private final int wordIndex;
        private final int wordCursor;
        private final int cursor;
        private final String openingQuote;
        private final int rawWordCursor;
        private final int rawWordLength;

        @Deprecated
        public ArgumentList(String line, List<String> words, int wordIndex, int wordCursor, int cursor) {
            this(line, words, wordIndex, wordCursor, cursor, null, wordCursor, words.get(wordIndex).length());
        }

        public ArgumentList(String line, List<String> words, int wordIndex, int wordCursor, int cursor, String openingQuote, int rawWordCursor, int rawWordLength) {
            this.line = line;
            this.words = Collections.unmodifiableList(Objects.requireNonNull(words));
            this.wordIndex = wordIndex;
            this.wordCursor = wordCursor;
            this.cursor = cursor;
            this.openingQuote = openingQuote;
            this.rawWordCursor = rawWordCursor;
            this.rawWordLength = rawWordLength;
        }

        @Override
        public int wordIndex() {
            return this.wordIndex;
        }

        @Override
        public String word() {
            if (this.wordIndex < 0 || this.wordIndex >= this.words.size()) {
                return "";
            }
            return this.words.get(this.wordIndex);
        }

        @Override
        public int wordCursor() {
            return this.wordCursor;
        }

        @Override
        public List<String> words() {
            return this.words;
        }

        @Override
        public int cursor() {
            return this.cursor;
        }

        @Override
        public String line() {
            return this.line;
        }

        @Override
        public CharSequence escape(CharSequence candidate, boolean complete) {
            StringBuilder sb = new StringBuilder(candidate);
            Predicate<Integer> needToBeEscaped = this.openingQuote != null ? i -> DefaultParser.this.isRawEscapeChar(sb.charAt((int)i)) || String.valueOf(sb.charAt((int)i)).equals(this.openingQuote) : i -> DefaultParser.this.isDelimiterChar(sb, (int)i) || DefaultParser.this.isRawEscapeChar(sb.charAt((int)i)) || DefaultParser.this.isRawQuoteChar(sb.charAt((int)i));
            for (int i2 = 0; i2 < sb.length(); ++i2) {
                if (!needToBeEscaped.test(i2)) continue;
                sb.insert(i2++, DefaultParser.this.escapeChars[0]);
            }
            if (this.openingQuote != null) {
                sb.insert(0, this.openingQuote);
                if (complete) {
                    sb.append(this.openingQuote);
                }
            }
            return sb;
        }

        @Override
        public int rawWordCursor() {
            return this.rawWordCursor;
        }

        @Override
        public int rawWordLength() {
            return this.rawWordLength;
        }
    }
}

