/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.calcite.FlinkTypeFactory;
import org.apache.flink.table.expressions.Cast;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ResolvedFieldReference;
import org.apache.flink.table.sources.DefinedFieldMapping;
import org.apache.flink.table.sources.DefinedProctimeAttribute;
import org.apache.flink.table.sources.DefinedRowtimeAttributes;
import org.apache.flink.table.sources.RowtimeAttributeDescriptor;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.tsextractors.TimestampExtractor;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo;
import org.apache.flink.table.typeutils.TimeIndicatorTypeInfo$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenSeq;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class TableSourceUtil$ {
    public static TableSourceUtil$ MODULE$;

    static {
        new TableSourceUtil$();
    }

    public boolean hasRowtimeAttribute(TableSource<?> tableSource) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getRowtimeAttributes(tableSource))).nonEmpty();
    }

    public boolean hasProctimeAttribute(TableSource<?> tableSource) {
        return this.getProctimeAttribute(tableSource).nonEmpty();
    }

    public void validateTableSource(TableSource<?> tableSource) {
        DefinedProctimeAttribute definedProctimeAttribute;
        TableSchema schema = tableSource.getTableSchema();
        String[] tableFieldNames = schema.getFieldNames();
        TypeInformation<?>[] tableFieldTypes = schema.getFieldTypes();
        String[] rowtimeAttributes = this.getRowtimeAttributes(tableSource);
        Option<String> proctimeAttribute = this.getProctimeAttribute(tableSource);
        IntRef mappedFieldCnt = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableFieldTypes)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])tableFieldNames), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TableSourceUtil$.$anonfun$validateTableSource$1(tableSource, rowtimeAttributes, proctimeAttribute, mappedFieldCnt, x0$1);
            return BoxedUnit.UNIT;
        });
        if (!(tableSource.getReturnType() instanceof CompositeType) && mappedFieldCnt.elem > 1) {
            throw new ValidationException(new StringBuilder(56).append("More than one table field matched to atomic input type ").append(tableSource.getReturnType()).append(".").toString());
        }
        TableSource<?> tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedRowtimeAttributes) {
            BoxedUnit boxedUnit;
            DefinedRowtimeAttributes definedRowtimeAttributes = (DefinedRowtimeAttributes)((Object)tableSource2);
            List<RowtimeAttributeDescriptor> descriptors = definedRowtimeAttributes.getRowtimeAttributeDescriptors();
            if (descriptors.size() > 1) {
                throw new ValidationException(new StringBuilder(110).append("Currently, only a single rowtime attribute is supported. ").append("Please remove all but one RowtimeAttributeDescriptor.").toString());
            }
            if (descriptors.size() == 1) {
                RowtimeAttributeDescriptor descriptor = descriptors.get(0);
                String rowtimeAttribute = descriptor.getAttributeName();
                int rowtimeIdx = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.getFieldNames())).indexOf((Object)rowtimeAttribute);
                if (rowtimeIdx < 0) {
                    throw new ValidationException(new StringBuilder(45).append("Found a RowtimeAttributeDescriptor for field ").append(new StringBuilder(40).append("'").append(rowtimeAttribute).append("' but field '").append(rowtimeAttribute).append("' does not exist in table.").toString()).toString());
                }
                TypeInformation<?> typeInformation = schema.getFieldTypes()[rowtimeIdx];
                TypeInformation<Timestamp> typeInformation2 = Types$.MODULE$.SQL_TIMESTAMP();
                if (typeInformation == null ? typeInformation2 != null : !typeInformation.equals(typeInformation2)) {
                    throw new ValidationException(new StringBuilder(45).append("Found a RowtimeAttributeDescriptor for field ").append(new StringBuilder(41).append("'").append(rowtimeAttribute).append("' but field '").append(rowtimeAttribute).append("' is not of type TIMESTAMP.").toString()).toString());
                }
                String[] extractorInputFields = descriptor.getTimestampExtractor().getArgumentFields();
                TypeInformation[] physicalTypes = (TypeInformation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.resolveInputFields(extractorInputFields, tableSource))).map((Function1 & Serializable & scala.Serializable)x$2 -> (TypeInformation)x$2._3(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class)));
                descriptor.getTimestampExtractor().validateArgumentFields(physicalTypes);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        TableSource<?> tableSource3 = tableSource;
        if (tableSource3 instanceof DefinedProctimeAttribute && (definedProctimeAttribute = (DefinedProctimeAttribute)((Object)tableSource3)).getProctimeAttribute() != null) {
            String proctimeAttribute2 = definedProctimeAttribute.getProctimeAttribute();
            int proctimeIdx = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.getFieldNames())).indexOf((Object)proctimeAttribute2);
            if (proctimeIdx < 0) {
                throw new ValidationException(new StringBuilder(45).append("Found a RowtimeAttributeDescriptor for field ").append(new StringBuilder(40).append("'").append(proctimeAttribute2).append("' but field '").append(proctimeAttribute2).append("' does not exist in table.").toString()).toString());
            }
            TypeInformation<?> typeInformation = schema.getFieldTypes()[proctimeIdx];
            TypeInformation<Timestamp> typeInformation3 = Types$.MODULE$.SQL_TIMESTAMP();
            if (typeInformation == null ? typeInformation3 != null : !typeInformation.equals(typeInformation3)) {
                throw new ValidationException(new StringBuilder(45).append("Found a RowtimeAttributeDescriptor for field ").append(new StringBuilder(41).append("'").append(proctimeAttribute2).append("' but field '").append(proctimeAttribute2).append("' is not of type TIMESTAMP.").toString()).toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (proctimeAttribute.isDefined() && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rowtimeAttributes)).contains(proctimeAttribute.get())) {
            throw new ValidationException(new StringBuilder(76).append("Field '").append(proctimeAttribute.get()).append("' must not be ").append("processing time and rowtime attribute at the same time.").toString());
        }
    }

    public int[] computeIndexMapping(TableSource<?> tableSource, boolean isStreamTable, Option<int[]> selectedFields) {
        TypeInformation<?>[] typeInformationArray;
        String[] tableFieldNames;
        String[] stringArray;
        TypeInformation<?> inputType = tableSource.getReturnType();
        TableSchema tableSchema = tableSource.getTableSchema();
        if (selectedFields.isDefined()) {
            String[] names = tableSchema.getFieldNames();
            stringArray = (String[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])selectedFields.get())).map((Function1 & Serializable & scala.Serializable)x$3 -> TableSourceUtil$.$anonfun$computeIndexMapping$1(names, BoxesRunTime.unboxToInt((Object)x$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        } else {
            stringArray = tableFieldNames = tableSchema.getFieldNames();
        }
        if (selectedFields.isDefined()) {
            TypeInformation<?>[] types = tableSchema.getFieldTypes();
            typeInformationArray = (TypeInformation[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])selectedFields.get())).map((Function1 & Serializable & scala.Serializable)x$4 -> TableSourceUtil$.$anonfun$computeIndexMapping$2(types, BoxesRunTime.unboxToInt((Object)x$4)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class)));
        } else {
            typeInformationArray = tableSchema.getFieldTypes();
        }
        TypeInformation<?>[] tableFieldTypes = typeInformationArray;
        String[] rowtimeAttributes = this.getRowtimeAttributes(tableSource);
        Option<String> proctimeAttributes = this.getProctimeAttribute(tableSource);
        int[] mapping = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableFieldTypes)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])tableFieldNames), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToInteger((int)TableSourceUtil$.$anonfun$computeIndexMapping$3(tableSource, isStreamTable, rowtimeAttributes, proctimeAttributes, x0$2)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        if (!(inputType instanceof CompositeType) && new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(mapping)).count((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$6 -> x$6 >= 0) > 1) {
            throw new ValidationException(new StringBuilder(56).append("More than one table field matched to atomic input type ").append(inputType).append(".").toString());
        }
        return mapping;
    }

    public RelDataType getRelDataType(TableSource<?> tableSource, Option<int[]> selectedFields, boolean streaming, FlinkTypeFactory typeFactory) {
        Tuple2 tuple2;
        String[] fieldNames = tableSource.getTableSchema().getFieldNames();
        ObjectRef fieldTypes = ObjectRef.create(tableSource.getTableSchema().getFieldTypes());
        if (streaming) {
            String[] rowtimeAttributes = this.getRowtimeAttributes(tableSource);
            Option<String> proctimeAttributes = this.getProctimeAttribute(tableSource);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rowtimeAttributes)).foreach((Function1 & Serializable & scala.Serializable)rowtimeField -> {
                TableSourceUtil$.$anonfun$getRelDataType$1(fieldNames, fieldTypes, rowtimeField);
                return BoxedUnit.UNIT;
            });
            proctimeAttributes.foreach((Function1 & Serializable & scala.Serializable)proctimeField -> {
                TableSourceUtil$.$anonfun$getRelDataType$2(fieldNames, fieldTypes, proctimeField);
                return BoxedUnit.UNIT;
            });
        }
        Tuple2 tuple22 = tuple2 = selectedFields.isDefined() ? new Tuple2(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])selectedFields.get())).map((Function1 & Serializable & scala.Serializable)x$7 -> TableSourceUtil$.$anonfun$getRelDataType$3(fieldNames, BoxesRunTime.unboxToInt((Object)x$7)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])selectedFields.get())).map((Function1 & Serializable & scala.Serializable)x$8 -> TableSourceUtil$.$anonfun$getRelDataType$4(fieldTypes, BoxesRunTime.unboxToInt((Object)x$8)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class)))) : new Tuple2((Object)fieldNames, (Object)((TypeInformation[])fieldTypes.elem));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] selectedFieldNames = (String[])tuple2._1();
        TypeInformation[] selectedFieldTypes = (TypeInformation[])tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)selectedFieldNames, (Object)selectedFieldTypes);
        Tuple2 tuple24 = tuple23;
        String[] selectedFieldNames2 = (String[])tuple24._1();
        TypeInformation[] selectedFieldTypes2 = (TypeInformation[])tuple24._2();
        return typeFactory.buildLogicalRowType((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])selectedFieldNames2), (Seq<TypeInformation<?>>)Predef$.MODULE$.wrapRefArray((Object[])selectedFieldTypes2));
    }

    public Option<RowtimeAttributeDescriptor> getRowtimeAttributeDescriptor(TableSource<?> tableSource, Option<int[]> selectedFields) {
        None$ none$;
        TableSource<?> tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedRowtimeAttributes) {
            Object object;
            DefinedRowtimeAttributes definedRowtimeAttributes = (DefinedRowtimeAttributes)((Object)tableSource2);
            List<RowtimeAttributeDescriptor> descriptors = definedRowtimeAttributes.getRowtimeAttributeDescriptors();
            if (descriptors.size() == 0) {
                object = None$.MODULE$;
            } else {
                if (descriptors.size() > 1) {
                    throw new ValidationException("Table with has more than a single rowtime attribute.");
                }
                if (selectedFields.isEmpty()) {
                    object = new Some((Object)descriptors.get(0));
                } else {
                    RowtimeAttributeDescriptor descriptor = descriptors.get(0);
                    int fieldIdx = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tableSource.getTableSchema().getFieldNames())).indexOf((Object)descriptor.getAttributeName());
                    object = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])selectedFields.get())).contains((Object)BoxesRunTime.boxToInteger((int)fieldIdx)) ? new Some((Object)descriptor) : None$.MODULE$;
                }
            }
            none$ = object;
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<RexNode> getRowtimeExtractionExpression(TableSource<?> tableSource, Option<int[]> selectedFields, RelOptCluster cluster, RelBuilder relBuilder, TypeInformation<?> resultType) {
        FlinkTypeFactory typeFactory = (FlinkTypeFactory)cluster.getTypeFactory();
        Option<RowtimeAttributeDescriptor> rowtimeDesc = this.getRowtimeAttributeDescriptor(tableSource, selectedFields);
        return rowtimeDesc.map((Function1 & Serializable & scala.Serializable)r -> {
            ResolvedFieldReference[] resolvedFieldReferenceArray;
            TimestampExtractor tsExtractor = r.getTimestampExtractor();
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])tsExtractor.getArgumentFields())).nonEmpty()) {
                Tuple3<String, Object, TypeInformation<?>>[] resolvedFields = MODULE$.resolveInputFields(tsExtractor.getArgumentFields(), tableSource);
                relBuilder.push(TableSourceUtil$.createSchemaRelNode$1(resolvedFields, cluster, typeFactory));
                resolvedFieldReferenceArray = (ResolvedFieldReference[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])resolvedFields)).map((Function1 & Serializable & scala.Serializable)f -> new ResolvedFieldReference((String)f._1(), (TypeInformation)f._3()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ResolvedFieldReference.class)));
            } else {
                resolvedFieldReferenceArray = new ResolvedFieldReference[]{};
            }
            ResolvedFieldReference[] fieldAccesses = resolvedFieldReferenceArray;
            Expression expression = tsExtractor.getExpression(fieldAccesses);
            RexNode rexExpression = new Cast(expression, resultType).toRexNode(relBuilder);
            relBuilder.clear();
            return rexExpression;
        });
    }

    public int[] getPhysicalIndexes(TableSource<?> tableSource, int[] logicalFieldIndexes) {
        int[] fieldMapping = this.computeIndexMapping(tableSource, true, (Option<int[]>)None$.MODULE$);
        return (int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(logicalFieldIndexes)).map((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$12 -> fieldMapping[x$12], Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).flatMap((Function1 & Serializable & scala.Serializable)x0$3 -> TableSourceUtil$.$anonfun$getPhysicalIndexes$2(tableSource, BoxesRunTime.unboxToInt((Object)x0$3)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
    }

    private String[] getRowtimeAttributes(TableSource<?> tableSource) {
        String[] stringArray;
        TableSource<?> tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedRowtimeAttributes) {
            DefinedRowtimeAttributes definedRowtimeAttributes = (DefinedRowtimeAttributes)((Object)tableSource2);
            stringArray = (String[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(definedRowtimeAttributes.getRowtimeAttributeDescriptors()).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.getAttributeName(), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        } else {
            stringArray = (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class));
        }
        return stringArray;
    }

    private Option<String> getProctimeAttribute(TableSource<?> tableSource) {
        DefinedProctimeAttribute definedProctimeAttribute;
        TableSource<?> tableSource2 = tableSource;
        Object object = tableSource2 instanceof DefinedProctimeAttribute && (definedProctimeAttribute = (DefinedProctimeAttribute)((Object)tableSource2)).getProctimeAttribute() != null ? new Some((Object)definedProctimeAttribute.getProctimeAttribute()) : None$.MODULE$;
        return object;
    }

    private Tuple3<String, Object, TypeInformation<?>> resolveInputField(String fieldName, TableSource<?> tableSource) {
        Tuple3 tuple3;
        DefinedFieldMapping definedFieldMapping;
        TypeInformation<?> returnType = tableSource.getReturnType();
        TableSource<?> tableSource2 = tableSource;
        if (tableSource2 instanceof DefinedFieldMapping && (definedFieldMapping = (DefinedFieldMapping)((Object)tableSource2)).getFieldMapping() != null) {
            String resolvedFieldName = definedFieldMapping.getFieldMapping().get(fieldName);
            if (resolvedFieldName == null) {
                throw new ValidationException(new StringBuilder(52).append("Field '").append(fieldName).append("' could not be resolved by the field mapping.").toString());
            }
            tuple3 = TableSourceUtil$.lookupField$1(resolvedFieldName, new StringBuilder(112).append("Table field '").append(fieldName).append("' was resolved to TableSource return type field ").append(new StringBuilder(45).append("'").append(resolvedFieldName).append("', but field '").append(resolvedFieldName).append("' was not found in the return ").toString()).append(new StringBuilder(26).append("type ").append(returnType).append(" of the TableSource. ").toString()).append("Please verify the field mapping of the TableSource.").toString(), returnType);
        } else {
            tuple3 = TableSourceUtil$.lookupField$1(fieldName, new StringBuilder(68).append("Table field '").append(fieldName).append("' was not found in the return type ").append(returnType).append(" of the ").append("TableSource.").toString(), returnType);
        }
        return tuple3;
    }

    private Tuple3<String, Object, TypeInformation<?>>[] resolveInputFields(String[] fieldNames, TableSource<?> tableSource) {
        return (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames)).map((Function1 & Serializable & scala.Serializable)x$15 -> MODULE$.resolveInputField((String)x$15, tableSource), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$validateTableSource$1(TableSource tableSource$4, String[] rowtimeAttributes$1, Option proctimeAttribute$1, IntRef mappedFieldCnt$1, Tuple2 x0$1) {
        TypeInformation tpe;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            TypeInformation t = (TypeInformation)tuple2._1();
            String name = (String)tuple2._2();
            if (t instanceof SqlTimeTypeInfo) {
                SqlTimeTypeInfo sqlTimeTypeInfo = (SqlTimeTypeInfo)t;
                if (name != null) {
                    String string = name;
                    Class clazz = sqlTimeTypeInfo.getTypeClass();
                    Class<Timestamp> clazz2 = Timestamp.class;
                    if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) && proctimeAttribute$1.contains((Object)string)) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
            }
        }
        if (tuple2 != null) {
            TypeInformation t = (TypeInformation)tuple2._1();
            String name = (String)tuple2._2();
            if (t instanceof SqlTimeTypeInfo) {
                SqlTimeTypeInfo sqlTimeTypeInfo = (SqlTimeTypeInfo)t;
                if (name != null) {
                    String string = name;
                    Class clazz = sqlTimeTypeInfo.getTypeClass();
                    Class<Timestamp> clazz3 = Timestamp.class;
                    if (!(clazz != null ? !clazz.equals(clazz3) : clazz3 != null) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rowtimeAttributes$1)).contains((Object)string)) {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TypeInformation t = (TypeInformation)tuple2._1();
        String name = (String)tuple2._2();
        if (!(t instanceof TypeInformation)) throw new MatchError((Object)tuple2);
        TypeInformation typeInformation = t;
        if (MODULE$.getProctimeAttribute(tableSource$4).contains((Object)name)) {
            throw new ValidationException(new StringBuilder(44).append("Processing time field '").append(name).append("' has invalid type ").append(typeInformation).append(". ").append(new StringBuilder(44).append("Processing time attributes must be of type ").append(Types$.MODULE$.SQL_TIMESTAMP()).append(".").toString()).toString());
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MODULE$.getRowtimeAttributes(tableSource$4))).contains((Object)name)) {
            throw new ValidationException(new StringBuilder(36).append("Rowtime field '").append(name).append("' has invalid type ").append(typeInformation).append(". ").append(new StringBuilder(36).append("Rowtime attributes must be of type ").append(Types$.MODULE$.SQL_TIMESTAMP()).append(".").toString()).toString());
        }
        Tuple3<String, Object, TypeInformation<?>> tuple3 = MODULE$.resolveInputField(name, tableSource$4);
        if (tuple3 == null) throw new MatchError(tuple3);
        String physicalName = (String)tuple3._1();
        TypeInformation tpe2 = (TypeInformation)tuple3._3();
        Tuple2 tuple22 = new Tuple2((Object)physicalName, (Object)tpe2);
        Tuple2 tuple23 = tuple22;
        String physicalName2 = (String)tuple23._1();
        TypeInformation typeInformation2 = tpe = (TypeInformation)tuple23._2();
        TypeInformation typeInformation3 = typeInformation;
        if (typeInformation2 == null ? typeInformation3 != null : !typeInformation2.equals(typeInformation3)) {
            throw new ValidationException(new StringBuilder(33).append("Type ").append(typeInformation).append(" of table field '").append(name).append("' does not ").append(new StringBuilder(64).append("match with type ").append(tpe).append(" of the field '").append(physicalName2).append("' of the TableSource return type.").toString()).toString());
        }
        ++mappedFieldCnt$1.elem;
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ String $anonfun$computeIndexMapping$1(String[] names$1, int x$3) {
        return names$1[x$3];
    }

    public static final /* synthetic */ TypeInformation $anonfun$computeIndexMapping$2(TypeInformation[] types$1, int x$4) {
        return types$1[x$4];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ int $anonfun$computeIndexMapping$3(TableSource tableSource$1, boolean isStreamTable$1, String[] rowtimeAttributes$2, Option proctimeAttributes$1, Tuple2 x0$2) {
        TypeInformation tpe;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            TypeInformation t = (TypeInformation)tuple2._1();
            String name = (String)tuple2._2();
            if (t instanceof SqlTimeTypeInfo) {
                SqlTimeTypeInfo sqlTimeTypeInfo = (SqlTimeTypeInfo)t;
                if (name != null) {
                    String string = name;
                    Class clazz = sqlTimeTypeInfo.getTypeClass();
                    Class<Timestamp> clazz2 = Timestamp.class;
                    if (!(clazz != null ? !clazz.equals(clazz2) : clazz2 != null) && proctimeAttributes$1.contains((Object)string)) {
                        return isStreamTable$1 ? TimeIndicatorTypeInfo$.MODULE$.PROCTIME_STREAM_MARKER() : TimeIndicatorTypeInfo$.MODULE$.PROCTIME_BATCH_MARKER();
                    }
                }
            }
        }
        if (tuple2 != null) {
            TypeInformation t = (TypeInformation)tuple2._1();
            String name = (String)tuple2._2();
            if (t instanceof SqlTimeTypeInfo) {
                SqlTimeTypeInfo sqlTimeTypeInfo = (SqlTimeTypeInfo)t;
                if (name != null) {
                    String string = name;
                    Class clazz = sqlTimeTypeInfo.getTypeClass();
                    Class<Timestamp> clazz3 = Timestamp.class;
                    if (!(clazz != null ? !clazz.equals(clazz3) : clazz3 != null) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rowtimeAttributes$2)).contains((Object)string)) {
                        return isStreamTable$1 ? TimeIndicatorTypeInfo$.MODULE$.ROWTIME_STREAM_MARKER() : TimeIndicatorTypeInfo$.MODULE$.ROWTIME_BATCH_MARKER();
                    }
                }
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        TypeInformation t = (TypeInformation)tuple2._1();
        String name = (String)tuple2._2();
        if (!(t instanceof TypeInformation)) throw new MatchError((Object)tuple2);
        TypeInformation typeInformation = t;
        if (MODULE$.getProctimeAttribute(tableSource$1).contains((Object)name)) {
            throw new ValidationException(new StringBuilder(44).append("Processing time field '").append(name).append("' has invalid type ").append(typeInformation).append(". ").append(new StringBuilder(44).append("Processing time attributes must be of type ").append(Types$.MODULE$.SQL_TIMESTAMP()).append(".").toString()).toString());
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MODULE$.getRowtimeAttributes(tableSource$1))).contains((Object)name)) {
            throw new ValidationException(new StringBuilder(36).append("Rowtime field '").append(name).append("' has invalid type ").append(typeInformation).append(". ").append(new StringBuilder(36).append("Rowtime attributes must be of type ").append(Types$.MODULE$.SQL_TIMESTAMP()).append(".").toString()).toString());
        }
        Tuple3<String, Object, TypeInformation<?>> tuple3 = MODULE$.resolveInputField(name, tableSource$1);
        if (tuple3 == null) throw new MatchError(tuple3);
        String physicalName = (String)tuple3._1();
        int idx = BoxesRunTime.unboxToInt((Object)tuple3._2());
        TypeInformation tpe2 = (TypeInformation)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)physicalName, (Object)BoxesRunTime.boxToInteger((int)idx), (Object)tpe2);
        Tuple3 tuple33 = tuple32;
        String physicalName2 = (String)tuple33._1();
        int idx2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
        TypeInformation typeInformation2 = tpe = (TypeInformation)tuple33._3();
        TypeInformation typeInformation3 = typeInformation;
        if (typeInformation2 == null) {
            if (typeInformation3 == null) return idx2;
            throw new ValidationException(new StringBuilder(33).append("Type ").append(typeInformation).append(" of table field '").append(name).append("' does not ").append(new StringBuilder(64).append("match with type ").append(tpe).append(" of the field '").append(physicalName2).append("' of the TableSource return type.").toString()).toString());
        } else if (typeInformation2.equals(typeInformation3)) return idx2;
        throw new ValidationException(new StringBuilder(33).append("Type ").append(typeInformation).append(" of table field '").append(name).append("' does not ").append(new StringBuilder(64).append("match with type ").append(tpe).append(" of the field '").append(physicalName2).append("' of the TableSource return type.").toString()).toString());
    }

    public static final /* synthetic */ void $anonfun$getRelDataType$1(String[] fieldNames$1, ObjectRef fieldTypes$1, String rowtimeField) {
        int idx = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames$1)).indexOf((Object)rowtimeField);
        fieldTypes$1.elem = (TypeInformation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TypeInformation[])fieldTypes$1.elem))).patch(idx, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimeIndicatorTypeInfo[]{TimeIndicatorTypeInfo$.MODULE$.ROWTIME_INDICATOR()})), 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class)));
    }

    public static final /* synthetic */ void $anonfun$getRelDataType$2(String[] fieldNames$1, ObjectRef fieldTypes$1, String proctimeField) {
        int idx = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fieldNames$1)).indexOf((Object)proctimeField);
        fieldTypes$1.elem = (TypeInformation[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TypeInformation[])fieldTypes$1.elem))).patch(idx, (GenSeq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TimeIndicatorTypeInfo[]{TimeIndicatorTypeInfo$.MODULE$.PROCTIME_INDICATOR()})), 1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TypeInformation.class)));
    }

    public static final /* synthetic */ String $anonfun$getRelDataType$3(String[] fieldNames$1, int x$7) {
        return fieldNames$1[x$7];
    }

    public static final /* synthetic */ TypeInformation $anonfun$getRelDataType$4(ObjectRef fieldTypes$1, int x$8) {
        return ((TypeInformation[])fieldTypes$1.elem)[x$8];
    }

    public static final /* synthetic */ int $anonfun$getRowtimeExtractionExpression$1(Tuple3 x$10) {
        return BoxesRunTime.unboxToInt((Object)x$10._2());
    }

    public static final /* synthetic */ Tuple2 $anonfun$getRowtimeExtractionExpression$3(Map idxMap$1, int i) {
        return (Tuple2)idxMap$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)i), (Function0 & Serializable & scala.Serializable)() -> new Tuple2((Object)"", Types$.MODULE$.BYTE()));
    }

    private static final RelNode createSchemaRelNode$1(Tuple3[] fields, RelOptCluster cluster$1, FlinkTypeFactory typeFactory$1) {
        int maxIdx = BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)TableSourceUtil$.$anonfun$getRowtimeExtractionExpression$1(x$10)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).max((Ordering)Ordering.Int$.MODULE$));
        Map idxMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])((Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(f._2()), (Object)new Tuple2(f._1(), f._3())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))));
        Tuple2 tuple2 = ((GenericTraversableTemplate)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxIdx).map((Function1 & Serializable & scala.Serializable)i -> TableSourceUtil$.$anonfun$getRowtimeExtractionExpression$3(idxMap, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        IndexedSeq physicalFields = (IndexedSeq)tuple2._1();
        IndexedSeq physicalTypes = (IndexedSeq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)physicalFields, (Object)physicalTypes);
        Tuple2 tuple23 = tuple22;
        IndexedSeq physicalFields2 = (IndexedSeq)tuple23._1();
        IndexedSeq physicalTypes2 = (IndexedSeq)tuple23._2();
        RelDataType physicalSchema = typeFactory$1.buildLogicalRowType((Seq<String>)physicalFields2, (Seq<TypeInformation<?>>)physicalTypes2);
        return LogicalValues.create(cluster$1, physicalSchema, ImmutableList.of());
    }

    public static final /* synthetic */ int $anonfun$getPhysicalIndexes$3(Tuple3 x$13) {
        return BoxesRunTime.unboxToInt((Object)x$13._2());
    }

    public static final /* synthetic */ SeqLike $anonfun$getPhysicalIndexes$2(TableSource tableSource$3, int x0$3) {
        SeqLike seqLike;
        int n = x0$3;
        if (TimeIndicatorTypeInfo$.MODULE$.PROCTIME_STREAM_MARKER() == n) {
            seqLike = (SeqLike)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        } else if (TimeIndicatorTypeInfo$.MODULE$.ROWTIME_STREAM_MARKER() == n) {
            Option<RowtimeAttributeDescriptor> rowtimeAttributeDescriptor = MODULE$.getRowtimeAttributeDescriptor(tableSource$3, (Option<int[]>)None$.MODULE$);
            if (!rowtimeAttributeDescriptor.isDefined()) {
                throw new TableException("Computed field mapping includes a rowtime marker but the TableSource does not provide a RowtimeAttributeDescriptor. This is a bug and should be reported.");
            }
            String[] accessedFields = ((RowtimeAttributeDescriptor)rowtimeAttributeDescriptor.get()).getTimestampExtractor().getArgumentFields();
            seqLike = new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])MODULE$.resolveInputFields(accessedFields, tableSource$3))).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)TableSourceUtil$.$anonfun$getPhysicalIndexes$3(x$13)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))));
        } else {
            seqLike = (SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{n}));
        }
        return seqLike;
    }

    private static final Tuple3 lookupField$1(String fieldName, String failMsg, TypeInformation returnType$1) {
        Tuple3 tuple3;
        TypeInformation typeInformation = returnType$1;
        if (typeInformation instanceof CompositeType) {
            CompositeType compositeType = (CompositeType)typeInformation;
            int idx = compositeType.getFieldIndex(fieldName);
            if (idx < 0) {
                throw new ValidationException(failMsg);
            }
            tuple3 = new Tuple3((Object)fieldName, (Object)BoxesRunTime.boxToInteger((int)idx), (Object)compositeType.getTypeAt(idx));
        } else if (typeInformation != null) {
            TypeInformation typeInformation2 = typeInformation;
            tuple3 = new Tuple3((Object)fieldName, (Object)BoxesRunTime.boxToInteger((int)0), (Object)typeInformation2);
        } else {
            throw new MatchError((Object)typeInformation);
        }
        return tuple3;
    }

    private TableSourceUtil$() {
        MODULE$ = this;
    }
}

