/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.CsvValidator;
import org.apache.flink.table.descriptors.CsvValidator$;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FileSystemValidator;
import org.apache.flink.table.descriptors.FileSystemValidator$;
import org.apache.flink.table.descriptors.SchemaValidator;
import org.apache.flink.table.descriptors.SchemaValidator$;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.sources.CsvTableSource;
import org.apache.flink.table.util.JavaScalaConversionUtil$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001-3Q!\u0001\u0002\u0002\u00025\u0011\u0011dQ:w)\u0006\u0014G.Z*pkJ\u001cWMR1di>\u0014\u0018PQ1tK*\u00111\u0001B\u0001\bg>,(oY3t\u0015\t)a!A\u0003uC\ndWM\u0003\u0002\b\u0011\u0005)a\r\\5oW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0017!\tyA#D\u0001\u0011\u0015\t\t\"#\u0001\u0003mC:<'\"A\n\u0002\t)\fg/Y\u0005\u0003+A\u0011aa\u00142kK\u000e$\bCA\f\u001b\u001b\u0005A\"BA\r\u0005\u0003%1\u0017m\u0019;pe&,7/\u0003\u0002\u001c1\taA+\u00192mK\u001a\u000b7\r^8ss\")Q\u0004\u0001C\u0001=\u00051A(\u001b8jiz\"\u0012a\b\t\u0003A\u0001i\u0011A\u0001\u0005\u0006E\u0001!\teI\u0001\u0010e\u0016\fX/\u001b:fI\u000e{g\u000e^3yiR\tA\u0005\u0005\u0003&Q)RS\"\u0001\u0014\u000b\u0005\u001d\u0012\u0012\u0001B;uS2L!!\u000b\u0014\u0003\u00075\u000b\u0007\u000f\u0005\u0002,i9\u0011AF\r\t\u0003[Aj\u0011A\f\u0006\u0003_1\ta\u0001\u0010:p_Rt$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002\u0014A\u0002)sK\u0012,g-\u0003\u00026m\t11\u000b\u001e:j]\u001eT!a\r\u0019\t\u000ba\u0002A\u0011I\u001d\u0002'M,\b\u000f]8si\u0016$\u0007K]8qKJ$\u0018.Z:\u0015\u0003i\u00022!J\u001e+\u0013\tadE\u0001\u0003MSN$\b\"\u0002 \u0001\t#y\u0014!E2sK\u0006$X\rV1cY\u0016\u001cv.\u001e:dKR\u0019\u0001iQ%\u0011\u0005\u0001\n\u0015B\u0001\"\u0003\u00059\u00195O\u001e+bE2,7k\\;sG\u0016DQ\u0001R\u001fA\u0002\u0015\u000b1\"[:TiJ,\u0017-\\5oOB\u0011aiR\u0007\u0002a%\u0011\u0001\n\r\u0002\b\u0005>|G.Z1o\u0011\u0015QU\b1\u0001%\u0003)\u0001(o\u001c9feRLWm\u001d")
public abstract class CsvTableSourceFactoryBase
implements TableFactory {
    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> requiredContext() {
        void var1_1;
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("connector.type", FileSystemValidator$.MODULE$.CONNECTOR_TYPE_VALUE());
        context.put("format.type", CsvValidator$.MODULE$.FORMAT_TYPE_VALUE());
        context.put("connector.property-version", "1");
        context.put("format.property-version", "1");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> supportedProperties() {
        void var1_1;
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(FileSystemValidator$.MODULE$.CONNECTOR_PATH());
        properties.add(new StringBuilder(7).append(CsvValidator$.MODULE$.FORMAT_FIELDS()).append(".#.").append("type").toString());
        properties.add(new StringBuilder(7).append(CsvValidator$.MODULE$.FORMAT_FIELDS()).append(".#.").append("name").toString());
        properties.add(CsvValidator$.MODULE$.FORMAT_FIELD_DELIMITER());
        properties.add(CsvValidator$.MODULE$.FORMAT_LINE_DELIMITER());
        properties.add(CsvValidator$.MODULE$.FORMAT_QUOTE_CHARACTER());
        properties.add(CsvValidator$.MODULE$.FORMAT_COMMENT_PREFIX());
        properties.add(CsvValidator$.MODULE$.FORMAT_IGNORE_FIRST_LINE());
        properties.add(CsvValidator$.MODULE$.FORMAT_IGNORE_PARSE_ERRORS());
        properties.add(FileSystemValidator$.MODULE$.CONNECTOR_PATH());
        properties.add(new StringBuilder(7).append(SchemaValidator$.MODULE$.SCHEMA()).append(".#.").append("type").toString());
        properties.add(new StringBuilder(7).append(SchemaValidator$.MODULE$.SCHEMA()).append(".#.").append("name").toString());
        return var1_1;
    }

    public CsvTableSource createTableSource(boolean isStreaming, Map<String, String> properties) {
        DescriptorProperties params = new DescriptorProperties();
        params.putProperties(properties);
        new FileSystemValidator().validate(params);
        new CsvValidator().validate(params);
        new SchemaValidator(isStreaming, false, false).validate(params);
        CsvTableSource.Builder csvTableSourceBuilder = new CsvTableSource.Builder();
        TableSchema formatSchema = params.getTableSchema(CsvValidator$.MODULE$.FORMAT_FIELDS());
        TableSchema tableSchema = params.getTableSchema(SchemaValidator$.MODULE$.SCHEMA());
        if (!formatSchema.equals(tableSchema)) {
            throw new TableException("Encodings that differ from the schema are not supported yet for CsvTableSources.");
        }
        JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalString(FileSystemValidator$.MODULE$.CONNECTOR_PATH())).foreach((Function1 & Serializable & scala.Serializable)path -> csvTableSourceBuilder.path((String)path));
        JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalString(CsvValidator$.MODULE$.FORMAT_FIELD_DELIMITER())).foreach((Function1 & Serializable & scala.Serializable)delim -> csvTableSourceBuilder.fieldDelimiter((String)delim));
        JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalString(CsvValidator$.MODULE$.FORMAT_LINE_DELIMITER())).foreach((Function1 & Serializable & scala.Serializable)delim -> csvTableSourceBuilder.lineDelimiter((String)delim));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])formatSchema.getFieldNames())).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])formatSchema.getFieldTypes()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String name = (String)tuple2._1();
            TypeInformation tpe = (TypeInformation)tuple2._2();
            CsvTableSource.Builder builder = csvTableSourceBuilder.field(name, tpe);
            return builder;
        });
        JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalCharacter(CsvValidator$.MODULE$.FORMAT_QUOTE_CHARACTER())).foreach((Function1 & Serializable & scala.Serializable)quote -> csvTableSourceBuilder.quoteCharacter((Character)quote));
        JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalString(CsvValidator$.MODULE$.FORMAT_COMMENT_PREFIX())).foreach((Function1 & Serializable & scala.Serializable)prefix -> csvTableSourceBuilder.commentPrefix((String)prefix));
        JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalBoolean(CsvValidator$.MODULE$.FORMAT_IGNORE_FIRST_LINE())).foreach((Function1 & Serializable & scala.Serializable)flag -> Predef$.MODULE$.Boolean2boolean(flag) ? csvTableSourceBuilder.ignoreFirstLine() : BoxedUnit.UNIT);
        JavaScalaConversionUtil$.MODULE$.toScala(params.getOptionalBoolean(CsvValidator$.MODULE$.FORMAT_IGNORE_PARSE_ERRORS())).foreach((Function1 & Serializable & scala.Serializable)flag -> Predef$.MODULE$.Boolean2boolean(flag) ? csvTableSourceBuilder.ignoreParseErrors() : BoxedUnit.UNIT);
        return csvTableSourceBuilder.build();
    }
}

