/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.match;

import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rex.RexNode;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.cep.PatternFlatSelectFunction;
import org.apache.flink.cep.PatternSelectFunction;
import org.apache.flink.cep.pattern.conditions.IterativeCondition;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.codegen.GeneratedExpression;
import org.apache.flink.table.codegen.GeneratedFunction;
import org.apache.flink.table.codegen.MatchCodeGenerator;
import org.apache.flink.table.codegen.MatchCodeGenerator$;
import org.apache.flink.table.plan.schema.RowSchema;
import org.apache.flink.table.runtime.match.IterativeConditionRunner;
import org.apache.flink.table.runtime.match.PatternSelectFunctionRunner;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.types.Row;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;

public final class MatchUtil$ {
    public static MatchUtil$ MODULE$;

    static {
        new MatchUtil$();
    }

    public IterativeConditionRunner generateIterativeCondition(TableConfig config, RexNode patternDefinition, TypeInformation<?> inputTypeInfo, String patternName, Seq<String> names) {
        MatchCodeGenerator generator = new MatchCodeGenerator(config, inputTypeInfo, names, (Option<String>)new Some((Object)patternName));
        GeneratedExpression condition = generator.generateExpression(patternDefinition);
        String body = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n         |").append(condition.code()).append("\n         |return ").append(condition.resultTerm()).append(";\n         |").toString())).stripMargin();
        GeneratedFunction<IterativeCondition, ?> genCondition = generator.generateMatchFunction("MatchRecognizeCondition", IterativeCondition.class, body, condition.resultType());
        return new IterativeConditionRunner(genCondition.name(), genCondition.code());
    }

    public PatternFlatSelectFunction<Row, CRow> generateOneRowPerMatchExpression(TableConfig config, RowSchema returnType, List<RexNode> partitionKeys, List<RelFieldCollation> orderKeys, Map<String, RexNode> measures, TypeInformation<?> inputTypeInfo, Seq<String> patternNames) {
        MatchCodeGenerator generator = new MatchCodeGenerator(config, inputTypeInfo, patternNames, MatchCodeGenerator$.MODULE$.$lessinit$greater$default$4());
        GeneratedExpression resultExpression = generator.generateOneRowPerMatchExpression(partitionKeys, measures, returnType);
        String body = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(41).append("\n         |").append(resultExpression.code()).append("\n         |return ").append(resultExpression.resultTerm()).append(";\n         |").toString())).stripMargin();
        GeneratedFunction<PatternSelectFunction, ?> genFunction = generator.generateMatchFunction("MatchRecognizePatternSelectFunction", PatternSelectFunction.class, body, resultExpression.resultType());
        return new PatternSelectFunctionRunner(genFunction.name(), genFunction.code());
    }

    private MatchUtil$() {
        MODULE$ = this;
    }
}

